package com.bcxin.sync.common;

import java.util.Arrays;
import java.util.List;

/**
 * description: 常量
 * author: linchunpeng
 * date:  2023-07-14 9:52
 */
public class CommonConstant {

    /**
     * 接口请求id key
     */
    public static final String REQUEST_ID = "MSG_REQUEST_ID";
    public static final String HTTP_REQUEST_FAIL_RESULT = "fail";
    /**
     * 接口请求头部：Authorization key
     */
    public static final String REQUEST_HEADER_ACCESSTOKEN = "Accesstoken";

    public static final String EMPLOYEE_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.tenant_employees";
    public static final String TENANT_USERS_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.tenant_users";
    public static final String TENANT_ORGANIZATIONS_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.tenant_organizations";
    public static final String TLK_EVENT_TEAM_KAFKA_TOPIC="baibaodunflow.binlog-cdc.topic.v2.tlk_event_team";
    public static final String TLK_EVENT_PROJECT_KAFKA_TOPIC="baibaodunflow.binlog-cdc.topic.v2.tlk_event_project";
    public static final String DEPARTMENT_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.tenant_departments";
    public static final String EXTERNAL_GROUPS_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.external_groups";
    public static final String EXTERNAL_MEMBERS_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.external_members";
    public static final String ATTENDANCESITE_KAFKA_TOPIC="baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_base_info";
    public static final String ATTENDANCESITE_PERSON_KAFKA_TOPIC="baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_person_info";
    public static final String EMPLOYEE_ATTENDANCE_TOPIC="dispatch.binlog-cdc.topic.v2.tenant_employee_attendance_records";

    public static final String RBAC_PERMIT_OPTION_USER_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.rbac_permit_option_user";
    public static final String RBAC_PERMIT_OPTION_ROLE_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.rbac_permit_option_role";
    public static final String RBAC_CUSTOM_ROLE_USER_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.rbac_custom_role_user";
    public static final String TENANT_DEPARTMENT_EMPLOYEE_RELATIONS_KAFKA_TOPIC="obpm2.binlog-cdc.topic.v2.tenant_department_employee_relations";
    public static final String EB_ENTERPRISE_MESSAGE_NOTICE_KAFKA_TOPIC="tuoluojiang.binlog-cdc.topic.v2.eb_enterprise_message_notice";

    public static final String TOPIC_DEAD_LETTER_DISPATCH = "dispatch.dead.letter.dlt.topic";
    public static final String HEADER_ORIGINAL_TOPIC_NAME = "ORIGINAL_HEADER_TOPIC_NAME";

    /**
     * description：需要同步权限的操作码
     * author：linchunpeng
     * date：2025/2/20
     */
    public static final List<String> NEED_SYNC_PERMIT_CODES = Arrays.asList("attendance_manager");
    public static final String ATTENDANCE_MANAGER_CODE = "attendance_manager";

    //1 请假
    //3	加班申请
    //2	补卡申请
    //9	开票申请
    //4	外出申请
    //5	出差申请
    public static final int TLJ_APPROVE_TYPE_QJ = 1;
    public static final int TLJ_APPROVE_TYPE_JB = 3;
    public static final int TLJ_APPROVE_TYPE_Bk = 2;
    public static final int TLJ_APPROVE_TYPE_KP = 9;
    public static final int TLJ_APPROVE_TYPE_WC = 4;
    public static final int TLJ_APPROVE_TYPE_CC = 5;


    /**
     * http请求
     */
    public static final String HTTP = "http://";

    /**
     * https请求
     */
    public static final String HTTPS = "https://";
    /**
     * UTF-8 字符集
     */
    public static final String UTF8 = "UTF-8";

}
