/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class WebUtil {
    public static List<String> getRequestParamNames(HttpServletRequest request) {
        Enumeration paramNameEnum = request.getParameterNames();
        ArrayList<String> result = new ArrayList<String>();
        while (paramNameEnum.hasMoreElements()) {
            result.add(((String)paramNameEnum.nextElement()).trim());
        }
        return result;
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        List<String> paramNameList = WebUtil.getRequestParamNames(request);
        HashMap<String, String> result = new HashMap<String, String>();
        if (paramNameList == null || paramNameList.size() == 0) {
            return result;
        }
        for (String paramName : paramNameList) {
            result.put(paramName, request.getParameter(paramName));
        }
        return result;
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        response.addCookie(cookie);
    }

    public static String getIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (StringUtils.isNotEmpty((CharSequence)ip) && !"unKnown".equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String accept = request.getHeader("accept");
        if (accept != null && accept.indexOf("application/json") != -1) {
            return true;
        }
        String xRequestedWith = request.getHeader("X-Requested-With");
        return xRequestedWith != null && xRequestedWith.indexOf("XMLHttpRequest") != -1;
    }
}

