/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.util;

import com.bcxin.risk.base.domain.ConfigFunction;
import com.bcxin.risk.sys.resources.ConfigResources;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ConfigUtil {
    private static Map<String, String> data = new HashMap<String, String>();
    private static Map<String, String> regionData = new HashMap<String, String>();
    private static Map<String, ConfigFunction> dataFunction = new HashMap<String, ConfigFunction>();

    public static String getValue(String key) {
        String profileEnvi;
        String os;
        String value = data.get(key.toUpperCase());
        if (("materialupload_path".equalsIgnoreCase(key) || "temp_path".equalsIgnoreCase(key)) && (os = System.getProperty("os.name")).toLowerCase().startsWith("win") && value.startsWith("/")) {
            value = "D:" + value;
        }
        if ("web_url".equalsIgnoreCase(key) && Objects.equals(profileEnvi = ConfigResources.PROFILE_ENVI, "dev")) {
            value = "http://localhost:8080/";
        }
        if ("main_url".equalsIgnoreCase(key) && Objects.equals(profileEnvi = ConfigResources.PROFILE_ENVI, "dev")) {
            value = "http://localhost:9000/";
        }
        if ("limit_minDay".equalsIgnoreCase(key)) {
            ConfigFunction function = dataFunction.get(ConfigUtil.getValue("envi_code"));
            return function.getActivityLimitMinDay();
        }
        return value;
    }

    public static String envi() {
        return ConfigUtil.getValue("envi");
    }

    public static String material() {
        return ConfigUtil.getValue("materialUpload_path");
    }

    public static void putValue(String key, String value) {
        data.put(key, value);
    }

    public static Map<String, String> getData() {
        return data;
    }

    public static String webSiteUrl() {
        return ConfigUtil.getValue("web_url");
    }

    public static ConfigFunction getFunction(String province) {
        return dataFunction.get(province);
    }

    public static void putFunction(ConfigFunction config) {
        dataFunction.put(config.getProvince(), config);
    }

    public static String getRegion(String key) {
        return regionData.get(key);
    }

    public static void putRegion(String key, String value) {
        regionData.put(key, value);
    }
}

