/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.hibernateplus.converter.config;

import com.bcxin.risk.hibernateplus.converter.TypeConverter;
import com.bcxin.risk.hibernateplus.converter.context.ContextClassLoaderLocal;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class BeanConverterConfig {
    private static final ContextClassLoaderLocal BEANS_BY_CLASSLOADER = new ContextClassLoaderLocal(){

        @Override
        protected Object initialValue() {
            return new BeanConverterConfig();
        }
    };
    private SoftReference<Map<String, TypeConverter>> converters = new SoftReference(new HashMap());

    public static BeanConverterConfig getInstance() {
        return (BeanConverterConfig)BEANS_BY_CLASSLOADER.get();
    }

    public static void setInstance(BeanConverterConfig newInstance) {
        BEANS_BY_CLASSLOADER.set(newInstance);
    }

    public static String getCovertKey(Class<?> sourceClass, Class<?> targetClass) {
        return sourceClass.getName() + "_" + targetClass.getName();
    }

    public void registerConverter(TypeConverter converter) {
        Map<String, TypeConverter> map = this.converters.get();
        if (map == null) {
            map = new HashMap<String, TypeConverter>();
            this.converters = new SoftReference<HashMap<String, TypeConverter>>((HashMap<String, TypeConverter>)map);
        }
        map.put(BeanConverterConfig.getCovertKey(converter.getSourceTypeClass(), converter.getTargetTypeClass()), converter);
    }

    public void unregisterConverter(Class<?> sourceClass, Class<?> targetClass) {
        Map<String, TypeConverter> map = this.converters.get();
        if (map == null) {
            return;
        }
        map.remove(BeanConverterConfig.getCovertKey(sourceClass, targetClass));
    }

    public Map<String, TypeConverter> getConverters() {
        return this.converters.get();
    }

    public void clearConverter() {
        this.converters.clear();
    }
}

