package com.bcxin.risk.sys;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.train.VideoDao;
import com.bcxin.risk.train.domain.Video;
import com.bcxin.risk.train.dto.VideoDTO;
import com.bcxin.risk.train.dto.VideoProgressDTO;
import com.bcxin.risk.train.dto.search.VideoSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Repository("videoDao")
public class VideoDaoImpl extends DaoImpl<Video> implements VideoDao {

	@Resource
	private BaseDao baseDao;


	@Override
	public List<Video> findVideoList(VideoSearchDTO searchDTO, DwzPage page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if(StringUtil.isNotEmpty(searchDTO.getTitle())){
			criterionList.add(Restrictions.like("title","%"+ searchDTO.getTitle() +"%"));
		}
		List<Order> orderList = new ArrayList<Order>();
		orderList.add(Order.desc("createOn"));
		if ( page == null ) {
			return baseDao.findByCriterion(Video.class, criterionList,orderList);
		}
		return baseDao.findByCriterionForPage(Video.class, criterionList, page,orderList);
	}

	@Override
	public Video findVideoByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<VideoDTO> findVideoProgress(Long userId)  {
		String sql = "SELECT videoId,completed FROM risk_user_video_progress where userId=" + userId;
		List<VideoDTO> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql);
		list.forEach(result->{
			VideoDTO dto = new VideoDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public List<VideoProgressDTO> findVideoProgress(VideoSearchDTO searchDto, DwzPage page)  {
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "SELECT " +
				" t4.title as videoTitle," +
				" t3.name as contractorName, " +
				" t1.completed, " +
				" DATE_FORMAT(t1.createOn,'%Y-%m-%d %H:%i:%s') AS createOn " +
				" FROM risk_user_video_progress t1" +
				" inner join risk_se_user t2 on t1.userId = t2.oid" +
				" inner join risk_org t3 on t3.oid = t2.org_id" +
				" inner join sys_video t4 on t4.oid = t1.videoId" +
				" where 1=1 ";
		if (StringUtil.isNotEmpty(searchDto.getContractorName())) {
			sql = sql + " and t3.name = " + searchDto.getContractorName();
		}
		if (page != null) {
			page.setTotalCount(querySqlCounts(sql, wrapper));
			sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
		}
		List<VideoProgressDTO> dtoList = Lists.newArrayList();
		List<Map<String, Object>> list = queryMaps(sql, wrapper);
		list.forEach(result->{
			VideoProgressDTO dto = new VideoProgressDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}


	@Override
	public void deleteAll() {
		DeleteWrapper wrapper = DeleteWrapper.instance();
		delete(wrapper);
	}

}
