package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.hibernateplus.condition.CriterionWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormModuleDao;
import com.bcxin.risk.report.material.domain.MaterialFormModule;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class MaterialFormModuleDaoImpl extends DaoImpl<MaterialFormModule> implements MaterialFormModuleDao {

	@Override
	public MaterialFormModule findByActivityAndType(Activity activity, String moduleType) {
		Criteria criteria = createCriteria(MaterialFormModule.class)
				.add(Restrictions.eq("activity", activity))
				.add(Restrictions.eq("materialModule", moduleType));
		Object result = criteria.uniqueResult();
		if(result == null) {
			return null;
		} else {
			return (MaterialFormModule)result;
		}
	}


	@Override
	public List<MaterialFormModule> findByActivity(Activity activity) {
		CriterionWrapper wrapper = CriterionWrapper.instance();
		return selectList(wrapper.eq("activity", activity));
	}


	/**
	 * 如果已经选择，则清除所选择的所有主体信息
	 * @param activityId
	 */
	@Override
	public void deleteMaterialInfo(Long activityId){
		String sql = "delete from RISK_MaterialFormModule where activity_id = " + activityId;
		String sql2 = "delete from RISK_MaterialFormValue where activity_id = " + activityId;
		String sql3 = "delete from RISK_MaterialFormAttr where activity_id = " + activityId;
		String sql4 = "delete from RISK_MaterialFormMenu where activity_id = " + activityId;
		executeSqlUpdate(sql);
		executeSqlUpdate(sql2);
		executeSqlUpdate(sql3);
		executeSqlUpdate(sql4);
	}
}
