package com.bcxin.risk.report.material;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.util.CollectionUtil;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.report.material.dao.MaterialFormMenuDao;
import com.bcxin.risk.report.material.domain.MaterialFormMenu;
import com.bcxin.risk.report.material.dto.MaterialFormMenuDTO;
import com.bcxin.risk.report.material.dto.MaterialFormMenuSearchDto;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class MaterialFormMenuDaoImpl extends DaoImpl<MaterialFormMenu> implements MaterialFormMenuDao {

	@Override
	public MaterialFormMenu findMaterialFormMenuByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public MaterialFormMenu findByActivityAndMenuCode(Activity activity, String menuCode){
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity",activity));
		criterionList.add(Restrictions.eq("menuCode",menuCode));
		List list = selectList(criterionList);
		if (CollectionUtil.isEmpty(list)) {
			return null;
		}
		return (MaterialFormMenu)list.get(0);
	}

	@Override
	public List<MaterialFormMenu> selectListByDto(MaterialFormMenuSearchDto searchDto) {
		List<Criterion> criterionList = Lists.newArrayList();
		if ( searchDto.getMaterialFormClass()!= null ) {
			criterionList.add(Restrictions.eq("formClass", searchDto.getMaterialFormClass()));
		}
		if ( searchDto.getActivity() != null ) {
			criterionList.add(Restrictions.eq("activity", searchDto.getActivity()));
		}
		if ( searchDto.getMenuCodes() != null && searchDto.getMenuCodes().length > 0){
			criterionList.add(Restrictions.in("menuCode", searchDto.getMenuCodes()));
		}

		return selectList(criterionList,Order.asc("seq"));
	}


	@Override
	public List<MaterialFormMenu> findByActivity(Activity activity) {
		List<Criterion> criterionList = Lists.newArrayList();
		criterionList.add(Restrictions.eq("activity",activity));
		return selectList(criterionList);
	}

	//@Override
	//public List<String> findCodeByActivity(Activity activity) {
	//	String sql = "select m.menuCode as code from risk_materialformmenu m ";
	//	SelectWrapper wrapper = SelectWrapper.instance();
	//	wrapper.eq("m.oid",activity.getOid());
	//	List<Map<String, Object>> list = queryMaps(sql, wrapper);
    //
	//	List<MaterialDTO> dtoList = Lists.newArrayList();
	//	list.forEach(result -> {
	//		MaterialDTO dto = new MaterialDTO(result);
	//		dtoList.add(dto);
	//	});
	//	return dtoList;
	//}


	@Override
	public List<MaterialFormMenuDTO> selectDTOByOrg(Activity activity) {
		String sql = "select m.oid,m.menuCode,m.menuName,m.class_id,m.required,m.completed" +
				" from risk_materialformorg mo " +
				" inner join risk_materialformmenu m on mo.menuCode = m.menuCode" +
				" inner join risk_activity a on a.oid = m.activity_id" ;
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq("a.oid",activity.getOid());
		List<Map<String, Object>> list = queryMaps(sql, wrapper);

		List<MaterialFormMenuDTO> dtoList = Lists.newArrayList();
		list.forEach(result -> {
			MaterialFormMenuDTO dto = new MaterialFormMenuDTO(result);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public void deleteByActivityId(Long activityId){
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq("activity_id",activityId);
		this.delete(wrapper);
//		String sql = "SET FOREIGN_KEY_CHECKS=0; ";
//		sql+="delete from risk_materialformmenu where activity_id = " + activityId+";";
//		sql+="SET FOREIGN_KEY_CHECKS=1;";
//		this.executeSqlUpdate(sql);
	}

	@Override
	public List<Map<String,Object>> getFormMenuRequired(Long activityId){
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql="select A.oid menuId,A.menuCode,A.menuName,\n" +
				" sum(\n" +
				" case when A.required=1 and B.isRequired=1 then 1 else 0 end) requiredNum\n" +
				" from RISK_MaterialFormMenu A\n" +
				" inner join risk_materialformattr B on A.oid=B.menu_id\n" +
				" where A.activity_id=" +activityId+
				" group by A.oid,A.menuCode,A.menuName";
		return this.queryMaps(sql,wrapper);
	}
}
