package com.bcxin.risk.news;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.news.domain.News;
import com.bcxin.risk.news.dto.NewsDto;
import com.bcxin.risk.news.dto.search.NewsSearchDTO;
import com.google.common.collect.Lists;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Repository("newsDao")
public class NewsDaoImpl extends DaoImpl<News> implements NewsDao {

	@Resource
	private BaseDao baseDao;


	@Override
	public List<News> findNewsList(NewsSearchDTO searchDTO, DwzPage page) {
		List<Criterion> criterionList = Lists.newArrayList();
		if(StringUtil.isNotEmpty(searchDTO.getNewsType())){
			criterionList.add(Restrictions.eq("newsType",searchDTO.getNewsType()));
		}
		if(StringUtil.isNotEmpty(searchDTO.getProvinceId())){
			criterionList.add(Restrictions.eq("provinceId",searchDTO.getProvinceId()));
		}
		if(StringUtil.isNotEmpty(searchDTO.getTitle())){
			criterionList.add(Restrictions.like("title","%"+ searchDTO.getTitle() +"%"));
		}
		List<Order> orderList = new ArrayList<Order>();
		orderList.add(Order.desc("createOn"));
		if ( page == null ) {
			return baseDao.findByCriterion(News.class, criterionList,orderList);
		}
		return baseDao.findByCriterionForPage(News.class, criterionList, page,orderList);
	}

	//@Override
	//public List<News> findProvinceNewsList(String provinceId) {
	//	List<Criterion> criterionList = Lists.newArrayList();
	//	criterionList.add(Restrictions.or(Restrictions.eq("provinceId",provinceId),
	//			Restrictions.eq("provinceId", DictConst.REGION_CHINA)));
	//	return baseDao.findByCriterion(News.class, criterionList);
	//}

	//@Autowired
	//private BaseDao baseDao;
	//
	@Override
	public News findNewsByOid(Long oid){
		return selectById(oid);
	}

	@Override
	public List<NewsDto> findNewsList(NewsSearchDTO searchDto, Page page)  {
		String sql = "SELECT a.oid," +
				             "DATE_FORMAT(a.updateOn,'%Y-%m-%d %H:%i:%s') AS updateOn," +
				             "DATE_FORMAT(a.publishDate,'%Y-%m-%d') AS publishDate," +
				             "DATE_FORMAT(a.createOn,'%Y-%m-%d %H:%i:%s') AS createOn," +
				             "a.title," +
				             "a.content," +
				             "a.category," +
				             "a.newsType," +
				             "a.priority," +
				             "a.attachment" +
				" FROM sys_news a " +
				" WHERE 1=1 ";
		if (StringUtil.isNotEmpty(searchDto.getNewsType())&&!searchDto.getNewsType().equals("All") ) {
			sql += " AND a.newsType = '" + searchDto.getNewsType() + "'" ;
		}
		if (StringUtil.isNotEmpty(searchDto.getTitle()) ) {
			sql += " AND a.title like '%" + searchDto.getTitle() + "%'" ;
		}
		if (StringUtil.isNotEmpty(searchDto.getStartDate()) && StringUtil.isNotEmpty(searchDto.getEndDate())) {
			sql += " AND a.publishDate >= '" + searchDto.getStartDate() + " 00:00:00'";
			sql += " AND a.publishDate <= '" + searchDto.getEndDate() + " 00:00:00' ";
		}
		if (StringUtil.isNotEmpty(searchDto.getPriority())){
			//按时间排序
			if(searchDto.getPriority().equalsIgnoreCase("priority")){
				sql += " ORDER BY a.publishDate DESC" ;
			}
			//按重要程度排行priority为前台传来的important
			if (searchDto.getPriority().equalsIgnoreCase("important")){
				sql += " ORDER BY a.priority ASC,a.publishDate DESC" ;
			}
		} else {
			sql += " ORDER BY a.publishDate DESC" ;
		}


		List<NewsDto> dtoList = Lists.newArrayList();
		Page<Map<String, Object>> pageList = queryMapsPage(sql,page);
		List<Map<String, Object>> list = pageList.getRecords();
		list.forEach(result->{
			NewsDto dto = new NewsDto(result);
			dto.setPage(page);
			dtoList.add(dto);
		});
		return dtoList;
	}
	//
	//@Override
	//public List<News> findBox(StringBuffer hql, Page page) {
	//	return null;
	//}
	//
	//
	//@Override
	//public List<News> findCurrentDateArti() {
	//
	//	Date dt = new Date();
	//	Calendar rightNow = Calendar.getInstance();
	//	rightNow.setTime(dt);
	//	Date closeDate = rightNow.getTime();
	//	List<Criterion> criterionList = Lists.newArrayList();
	//	criterionList.add(Restrictions.eq("createOn", closeDate));
	//	criterionList.add(Restrictions.eq("createStatic", 0));
	//	return selectList(criterionList);
	//}
	//
	//
	//@Override
	//public List<News> findArticle(NewsSearchDto newsDto,DwzPage page) {
	//	List<Criterion> criterionList = Lists.newArrayList();
	//	if(StringUtil.isNotEmpty(newsDto.getCategory())){
	//		criterionList.add(Restrictions.eq("category",newsDto.getCategory()));
	//	}
	//	if(StringUtil.isNotEmpty(newsDto.getNewsType())){
	//		criterionList.add(Restrictions.eq("newsType",newsDto.getNewsType()));
	//	}
	//	if(StringUtil.isNotEmpty(newsDto.getProvinceId())){
	//		criterionList.add(Restrictions.eq("provinceId",Long.parseLong(newsDto.getProvinceId())));
	//	}
	//	if(StringUtil.isNotEmpty(newsDto.getTitle())){
	//		criterionList.add(Restrictions.like("title","%"+ newsDto.getTitle() +"%"));
	//	}
	//	List<Order> orderList = new ArrayList<Order>();
	//	orderList.add(Order.desc("createOn"));
	//
	//	if ( page == null ) {
	//		return baseDao.findByCriterion(News.class, criterionList,orderList);
	//	}
	//	return baseDao.findByCriterionForPage(News.class, criterionList, page,orderList);
	//}
	//
	//@Override
	//public List<News> findByCriterion(Class<News> newsClass, boolean createStatic) {
	//	List<Criterion> criterionList = Lists.newArrayList();
	//	criterionList.add(Restrictions.eq("createStatic", createStatic));
	//	return selectList(criterionList);
	//}
	//
	//@Override
	//public int newsListSize() {
	//	return selectList().size();
	//}
	//
	@Override
	public List<NewsDto> findNewNotice() {
		Page page = new Page();
		SelectWrapper wrapper = SelectWrapper.instance();
		String sql = "select * from sys_news"  ;
		List<NewsDto> dtoList = Lists.newArrayList();
		wrapper.orderBy("createOn",false);
		wrapper.orderBy("oid",false);
		Page<Map<String, Object>> pageList = queryMapsPage("select * from sys_news ", wrapper,page);
		List<Map<String, Object>> list = pageList.getRecords();
		list.forEach(result->{
			NewsDto dto = new NewsDto(result);
			dto.setPage(page);
			dtoList.add(dto);
		});
		return dtoList;
	}

	@Override
	public void deleteByUUID(String uuid) {
		DeleteWrapper wrapper = DeleteWrapper.instance();
		wrapper.eq("uuid",uuid);
		delete(wrapper);
	}

	@Override
	public void deleteAll() {
		DeleteWrapper wrapper = DeleteWrapper.instance();
		delete(wrapper);
	}

	@Override
	public News selectByUUID(String uuid) {
		SelectWrapper wrapper = SelectWrapper.instance();
		wrapper.eq("uuid", uuid);
		return selectOne(wrapper);
	}

}
