package com.bcxin.risk.common.dao;

import com.bcxin.risk.common.domain.Region;
import com.bcxin.risk.constant.DictConst;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by PVer on 2017/4/24.
 */
@Repository
public class RegionDaoImpl extends DaoImpl<Region> implements RegionDao{


    @Override
    public List<Region> selectRegionList(){
        Order[] orders = new Order[2];
        orders[0] = Order.asc("seq");
        orders[1] = Order.asc("oid");
        return selectList(orders);
    }

    @Override
    public List<Region> selectProvinceRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_PROVINCE);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectMarketProvinceRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_PROVINCE);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectCityRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_CITY);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectAreaRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_AREA);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public List<Region> selectUnitRegionList(){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("level", DictConst.REGIONLEVEL_UNIT);
        wrapper.orderBy("seq",true);
        return selectList(wrapper);
    }

    @Override
    public Region findRegionByname(String name){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("city",name);
        return  selectOne(wrapper);
    };

    @Override
    public Region findRegionByOid(Long oid){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("oid",oid);
        return  selectById(oid);
    };

    @Override
    public List<Region> findRegionByParentId(String parentId){
        SelectWrapper wrapper = SelectWrapper.instance();
        wrapper.eq("parent_id",parentId);
        wrapper.orderBy("seq,oid",true);
        return selectList(wrapper);
    }

}
