package com.bcxin.risk.user.dao;


import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.dao.IDao;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.user.dto.data.*;
import com.bcxin.risk.user.dto.search.PoliceUserSearchDto;
import com.bcxin.risk.user.dto.search.UserRoleSearchDto;

import java.util.List;


public interface UserDao extends IDao<User> {

        User findUserByName(String name);

        User findUserByZwid(String zwid);

        User findUserByEmail(String email);

        User findUserByOid(long oid);

        List userList(DwzPage page, UserDto userDto);

        User findAdminUser();

        List<UserRoleDataDto> queryUserList(UserRoleSearchDto dto);

        List<MenuDataDto> queryMenuByUser(Long userId);

        UserDataDto findUserByOrgId(Long orgId);

        List<UserRoleDataDto> queryUserListByOrgId(User user,String name,Page page);

        User findPoliceUserByArea(Long area_id);

        User findPoliceUserByRegion(Long regionId ,String regionLevel);

        List<UserRoleDataDto> queryUserOrRoleList(UserRoleSearchDto dto);

        int updateUser(User user);

        // 更新服务商用户
        int updateUserServiceOrg(String adminTel, String active);

        List findFrontUserList(UserDto userDto, DwzPage page);


        List<UserRoleDataDto>  findCashierByuserType(String usertypeGljgyhCw);

        List<User>  findUserListByDto(UserDto dto);

        List<PoliceUserDataDto> findPoliceUser(PoliceUserSearchDto dto, Page page);

        List<UserRoleDataDto> queryUserList(Long orgId ,String name,Page page);

        // 通过用户机构来获取机构的第一个用户
        UserDataDto findUserByOrgName(String orgName);

        void deleteUserDaoByOid(User user);

}