/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.sys;

import com.bcxin.risk.base.dao.BaseDao;
import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.vo.DwzPage;
import com.bcxin.risk.hibernateplus.condition.DeleteWrapper;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.train.VideoDao;
import com.bcxin.risk.train.domain.Video;
import com.bcxin.risk.train.dto.VideoDTO;
import com.bcxin.risk.train.dto.VideoProgressDTO;
import com.bcxin.risk.train.dto.search.VideoSearchDTO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository(value="videoDao")
public class VideoDaoImpl
extends DaoImpl<Video>
implements VideoDao {
    @Resource
    private BaseDao baseDao;

    public List<Video> findVideoList(VideoSearchDTO searchDTO, DwzPage page) {
        ArrayList criterionList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)searchDTO.getTitle())) {
            criterionList.add(Restrictions.like((String)"title", (Object)("%" + searchDTO.getTitle() + "%")));
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.desc((String)"createOn"));
        if (page == null) {
            return this.baseDao.findByCriterion(Video.class, (List)criterionList, orderList);
        }
        return this.baseDao.findByCriterionForPage(Video.class, (List)criterionList, page, orderList);
    }

    public Video findVideoByOid(Long oid) {
        return (Video)this.selectById(oid);
    }

    public List<VideoDTO> findVideoProgress(Long userId) {
        String sql = "SELECT videoId,completed FROM risk_user_video_progress where userId=" + userId;
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql);
        list.forEach(result -> {
            VideoDTO dto = new VideoDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public List<VideoProgressDTO> findVideoProgress(VideoSearchDTO searchDto, DwzPage page) {
        SelectWrapper wrapper = SelectWrapper.instance();
        String sql = "SELECT  t4.title as videoTitle, t3.name as contractorName,  t1.completed,  DATE_FORMAT(t1.createOn,'%Y-%m-%d %H:%i:%s') AS createOn  FROM risk_user_video_progress t1 inner join risk_se_user t2 on t1.userId = t2.oid inner join risk_org t3 on t3.oid = t2.org_id inner join sys_video t4 on t4.oid = t1.videoId where 1=1 ";
        if (StringUtil.isNotEmpty((String)searchDto.getContractorName())) {
            sql = sql + " and t3.name = " + searchDto.getContractorName();
        }
        if (page != null) {
            page.setTotalCount(this.querySqlCounts(sql, (Wrapper)wrapper));
            sql = sql + " limit " + (page.getPageNum() - 1) * page.getNumPerPage() + "," + page.getNumPerPage();
        }
        ArrayList dtoList = Lists.newArrayList();
        List list = this.queryMaps(sql, (Wrapper)wrapper);
        list.forEach(result -> {
            VideoProgressDTO dto = new VideoProgressDTO(result);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public void deleteAll() {
        DeleteWrapper wrapper = DeleteWrapper.instance();
        this.delete((Wrapper)wrapper);
    }
}

