/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.risk.common.dao;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.common.dao.MessageDao;
import com.bcxin.risk.common.domain.Message;
import com.bcxin.risk.common.dto.data.MessageDataDto;
import com.bcxin.risk.common.dto.search.MessageSearchDto;
import com.bcxin.risk.hibernateplus.condition.SelectWrapper;
import com.bcxin.risk.hibernateplus.condition.wrapper.Wrapper;
import com.bcxin.risk.hibernateplus.dao.impl.DaoImpl;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.user.domain.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class MessageDaoImpl
extends DaoImpl<Message>
implements MessageDao {
    public Message findMessageByOid(Long oid) {
        return (Message)this.selectById(oid);
    }

    public List<MessageDataDto> findMessageByDto(MessageSearchDto searchDto, Page page) {
        String sql = "SELECT oid, DATE_FORMAT(createOn,'%Y-%m-%d %H:%i:%s') AS createOn,readStatus ,content,title,keyword,url, checkFun FROM risk_message ";
        SelectWrapper wrapper = SelectWrapper.instance();
        if (searchDto.getUser() != null) {
            wrapper.eq("user_id", (Object)searchDto.getUser().getOid());
        }
        if (StringUtil.isNotEmpty((String)searchDto.getReadStatus())) {
            wrapper.eq("readStatus", (Object)searchDto.getReadStatus());
        }
        wrapper.orderBy("createOn", false);
        wrapper.orderBy("oid", false);
        ArrayList dtoList = Lists.newArrayList();
        Page pageList = this.queryMapsPage(sql, (Wrapper)wrapper, page);
        List list = pageList.getRecords();
        list.forEach(result -> {
            MessageDataDto dto = new MessageDataDto(result);
            dto.setPage(page);
            dtoList.add(dto);
        });
        return dtoList;
    }

    public Map<String, String> countMessage(User user) {
        SelectWrapper wrapper = SelectWrapper.instance();
        StringBuilder sql = new StringBuilder("select  sum(case readStatus when '1' then 1 else 0 end) as readtotal, sum(case readStatus when '0' then 1 else 0 end) as unreadtotal  from risk_message ");
        if (user == null) {
            return Maps.newHashMap();
        }
        wrapper.eq("user_id", (Object)user.getOid());
        HashMap countMap = Maps.newHashMap();
        Map result = this.queryMap(sql.toString(), (Wrapper)wrapper);
        countMap.put("readtotal", result.get("readtotal") == null ? "0" : result.get("readtotal").toString());
        countMap.put("unreadtotal", result.get("unreadtotal") == null ? "0" : result.get("unreadtotal").toString());
        return countMap;
    }

    public List<Message> findMessageList(MessageSearchDto searchDto, Page page) {
        ArrayList criterionList = Lists.newArrayList();
        if (searchDto.getUser() != null) {
            criterionList.add(Restrictions.eq((String)"user_id", (Object)searchDto.getUser().getOid()));
        }
        if (StringUtil.isNotEmpty((String)searchDto.getReadStatus())) {
            criterionList.add(Restrictions.eq((String)"readStatus", (Object)searchDto.getReadStatus()));
        }
        if (page == null) {
            return this.selectList(criterionList);
        }
        return this.selectPage(criterionList, page);
    }

    public void updateMessage(Message message) {
        this.update(message);
    }
}

