/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.eventHandlers;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.events.JoinDepartmentEvent;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.entities.TDepartmentUserEntity;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentUserRepository;
import java.util.Collection;
import java.util.Collections;
import org.springframework.stereotype.Component;

@Component
public class V5JoinDepartmentEventHandler
extends DomainEventHandlerAbstract<JoinDepartmentEvent> {
    private final TDepartmentUserRepository tDepartmentUserRepository;
    private final UnitWork unitWork;
    private final DataDispatcher dataDispatcher;

    public V5JoinDepartmentEventHandler(TDepartmentUserRepository tDepartmentUserRepository, UnitWork unitWork, DataDispatcher dataDispatcher) {
        this.tDepartmentUserRepository = tDepartmentUserRepository;
        this.unitWork = unitWork;
        this.dataDispatcher = dataDispatcher;
    }

    protected void execute(JoinDepartmentEvent event) {
        Collection<TDepartmentUserEntity> tDepartmentUserEntities = this.tDepartmentUserRepository.getByOrganIdAndUserIds(event.getOrganizationId(), Collections.singleton(event.getEmployeeId()));
        this.unitWork.executeTran(() -> {
            if (tDepartmentUserEntities.size() > 0) {
                tDepartmentUserEntities.forEach(ix -> ix.change(event.getDepartId(), ix.getRoleId()));
            } else {
                this.tDepartmentUserRepository.save((Object)TDepartmentUserEntity.create(event.getDepartId(), event.getEmployeeId()));
            }
        });
    }
}

