/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.autodownloadupload.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.autodownloadupload.common.utils.BcxinFtpClient;
import com.bcxin.autodownloadupload.common.utils.DatabaseUtil;
import com.bcxin.autodownloadupload.common.utils.FileUtils;
import com.bcxin.autodownloadupload.common.utils.FtpUtil;
import com.bcxin.autodownloadupload.configs.PushConfig;
import com.bcxin.autodownloadupload.dtos.FerryReceiveTaskPushResult;
import com.bcxin.autodownloadupload.entity.PushRecord;
import com.bcxin.autodownloadupload.service.PushDataService;
import com.bcxin.autodownloadupload.service.PushRecordService;
import com.bcxin.autodownloadupload.service.PushRecordSqlLogService;
import com.bcxin.autodownloadupload.service.PushRecordUploadLogService;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PushDataServiceImpl
implements PushDataService {
    private static final Logger log = LoggerFactory.getLogger(PushDataServiceImpl.class);
    @Autowired
    private PushConfig pushConfig;
    @Autowired
    private PushRecordService pushRecordService;
    @Autowired
    private PushRecordSqlLogService pushRecordSqlLogService;
    @Autowired
    private PushRecordUploadLogService pushRecordUploadLogService;
    @Value(value="${spring.shardingsphere.datasource.baiduutil.url}")
    private String url;
    @Value(value="${spring.shardingsphere.datasource.baiduutil.username}")
    private String username;
    @Value(value="${spring.shardingsphere.datasource.baiduutil.password}")
    private String password;

    @Async
    public void pushDataAsync(String requestId, boolean isNeedUnzip) {
        this.pushData(requestId, isNeedUnzip);
    }

    public PushRecord pushData(String requestId, boolean isNeedUnzip) {
        log.info("====================================\u5f00\u59cb\u81ea\u52a8\u63a8\u9001\u6587\u4ef6\uff0crequestId\uff1a{}=====================================", (Object)requestId);
        PushRecord pushRecord = this.unzipBaiduFile(requestId, isNeedUnzip);
        log.info("\u751f\u6210\u63a8\u9001\u8bb0\u5f55{}", (Object)JSONObject.toJSONString((Object)pushRecord));
        if ("success".equals(pushRecord.getUnzipResult())) {
            this.executeSqlFiles(pushRecord);
            this.uploadFiles(pushRecord);
            this.pushRecordService.updateById((Object)pushRecord);
        }
        log.info("====================================\u63a8\u9001\u6587\u4ef6\u7ed3\u675f=====================================");
        return pushRecord;
    }

    private PushRecord unzipBaiduFile(String requestId, boolean isNeedUnzip) {
        if (isNeedUnzip) {
            log.info("\u89e3\u538b\u6446\u6e21zip\u6587\u4ef6");
            String filePath = String.format(this.pushConfig.getFilePath(), requestId);
            File zipFile = new File(filePath);
            if (!zipFile.exists()) {
                return this.pushRecordService.createRecord(requestId, filePath, null, "zip\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            File unzip = ZipUtil.unzip((File)zipFile);
            if (!unzip.exists()) {
                return this.pushRecordService.createRecord(requestId, filePath, null, "zip\u89e3\u538b\u5931\u8d25");
            }
            log.info("\u89e3\u538b\u7ed3\u675f");
            return this.pushRecordService.createRecord(requestId, filePath, unzip.getAbsolutePath(), "success");
        }
        log.info("\u4e0d\u7528\u89e3\u538b\u6446\u6e21\u6587\u4ef6");
        String filePath = String.format(this.pushConfig.getFilePath(), requestId);
        filePath = filePath.substring(0, filePath.length() - 4);
        File folder = new File(filePath);
        if (!folder.exists()) {
            return this.pushRecordService.createRecord(requestId, filePath, null, "\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        }
        return this.pushRecordService.createRecord(requestId, filePath, filePath, "success");
    }

    private void uploadFiles(PushRecord pushRecord) {
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6");
        pushRecord.setUploadStartTime(new Date());
        if ("in".equals(this.pushConfig.getInternet().getType())) {
            this.uploadToIn(pushRecord);
        } else {
            this.uploadToOut(pushRecord);
        }
        pushRecord.setUploadEndTime(new Date());
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadToIn(PushRecord pushRecord) {
        log.info("\u4e0a\u4f20\u5230\u5185\u7f51ftp");
        PushConfig.FtpConfig ftpConfig = this.pushConfig.getInternet().getIn().getFtp();
        log.info("ftp\u914d\u7f6e\uff1a{}", (Object)ftpConfig);
        BcxinFtpClient ftpClient = new BcxinFtpClient();
        try {
            boolean conn = ftpClient.connect(ftpConfig.getIp(), ftpConfig.getUsername(), ftpConfig.getPassword(), ftpConfig.getPort().intValue());
            if (!conn) {
                pushRecord.setUploadResult("ftp\u8fde\u63a5\u5931\u8d25\uff01");
                log.info("ftp\u8fde\u63a5\u5931\u8d25");
            } else {
                log.info("ftp\u8fde\u63a5\u6210\u529f");
                int successCount = 0;
                ArrayList<String> uploadResultList = new ArrayList<String>();
                List fileList = FileUtil.loopFiles((File)new File(pushRecord.getUploadsPath()));
                if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                    pushRecord.setUploadFileCount(Integer.valueOf(fileList.size()));
                    for (File file : fileList) {
                        String absolutePath = file.getAbsolutePath();
                        absolutePath = absolutePath.replaceAll("\\\\", "/");
                        absolutePath = absolutePath.substring(absolutePath.indexOf("/uploads"));
                        String ftpFile = ftpConfig.getPath() + absolutePath;
                        ftpFile = ftpClient.getEncodingName(ftpFile);
                        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230ftp\uff0c\u672c\u5730\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c ftp\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)absolutePath, (Object)ftpFile);
                        boolean result = FtpUtil.bcxUploadFile((BcxinFtpClient)ftpClient, (String)ftpFile, (InputStream)new FileInputStream(file));
                        String uploadResult = "";
                        if (result) {
                            ++successCount;
                            continue;
                        }
                        uploadResult = String.format("fail\uff0c\u6587\u4ef6\uff1a%s\uff0c\u4e0a\u4f20ftp\u5931\u8d25\uff01", absolutePath);
                        log.info(uploadResult);
                        uploadResultList.add(uploadResult);
                    }
                }
                pushRecord.setUploadSuccessFileCount(Integer.valueOf(successCount));
                pushRecord.setUploadResult(uploadResultList.size() > 0 ? String.join((CharSequence)"\r\n", uploadResultList) : "all-success");
                log.info("\u4e0a\u4f20ftp\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            pushRecord.setUploadResult(e.getMessage());
            log.info("ftp\u4e0a\u4f20\u5931\u8d25\uff0c{}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            try {
                ftpClient.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void uploadToOut(PushRecord pushRecord) {
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u5916\u7f51");
        String srcPath = pushRecord.getUploadsPath();
        if (FileUtil.exist((String)srcPath)) {
            String savePath = this.pushConfig.getInternet().getOut().getSavePath();
            log.info("\u590d\u5236\u6587\u4ef6\uff0c\u4ece\uff1a{}\uff0c\u590d\u5236\u5230\uff1a{}", (Object)srcPath, (Object)savePath);
            FileUtil.copy((String)srcPath, (String)savePath, (boolean)true);
            pushRecord.setUploadResult(String.format("\u590d\u5236\u6587\u4ef6\uff0c\u4ece\uff1a%s\uff0c\u590d\u5236\u5230\uff1a%s", srcPath, savePath));
        } else {
            log.info("\u6446\u6e21\u5305\u4e0d\u5b58\u5728\u9644\u4ef6\uff0c\u65e0\u9700\u590d\u5236");
            pushRecord.setUploadResult("\u6446\u6e21\u5305\u4e0d\u5b58\u5728\u9644\u4ef6\uff0c\u65e0\u9700\u590d\u5236");
        }
    }

    private void checkFilesSuccess(PushRecord pushRecord) {
        log.info("\u7b49\u5f8510\u5206\u949f\uff0c\u786e\u8ba4\u6587\u4ef6\u662f\u5426\u4e0a\u4f20\u6210\u529f\uff0c\u5e76\u8bb0\u5f55\u65e5\u5fd7");
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("10\u5206\u949f\u5df2\u8fc7\uff0c\u5f00\u59cb\u786e\u8ba4");
        File downloadFile = new File(pushRecord.getDownloadTxtPath());
        if (FileUtil.exist((File)downloadFile)) {
            boolean result;
            String visitFileUrl;
            String checkErrorFile = pushRecord.getExecuteErrorTxtPath();
            ArrayList<String> errorList = new ArrayList<String>();
            errorList.add("\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38\u5217\u8868\u89c1\u4ee5\u4e0b\u5217\u51fa\u7684\u9644\u4ef6\u94fe\u63a5\uff0c\u590d\u5236\u6240\u6709\u9644\u4ef6\u94fe\u63a5\u5230\u65e7\u6446\u6e21\u5de5\u5177\u8fdb\u884c\u9644\u4ef6\u8865\u507f\uff1a");
            List urlList = FileUtil.readUtf8Lines((File)downloadFile);
            for (String fileUrl : urlList) {
                try {
                    visitFileUrl = null;
                    if (fileUrl.contains("/uploads/")) {
                        visitFileUrl = this.pushConfig.getInternet().getServerUrl().concat(fileUrl.substring(fileUrl.indexOf("/uploads/")));
                    } else {
                        String tempUrl = fileUrl.substring(8).replace("/upload/", "/");
                        visitFileUrl = this.pushConfig.getInternet().getServerUrl().concat("/uploads").concat(tempUrl.substring(tempUrl.indexOf("/")));
                    }
                    result = FileUtils.checkFileHutool((String)visitFileUrl);
                    if (result) {
                        this.pushRecordUploadLogService.createLog(pushRecord.getRequestId(), pushRecord.getId(), null, fileUrl, visitFileUrl, result);
                        continue;
                    }
                    errorList.add(fileUrl);
                }
                catch (Exception e) {
                    log.error("\u786e\u8ba4\u6587\u4ef6\u662f\u5426\u4e0a\u4f20\u6210\u529f\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
            }
            log.info("\u7b2c\u4e00\u6b21\u786e\u8ba4\u5b8c\u6210");
            if (errorList.size() > 1) {
                log.info("\u6709\u9a8c\u8bc1\u9519\u8bef\u7684\u6587\u4ef6url\uff0c\u7b49\u5f855\u5206\u949f\u540e\uff0c\u518d\u6b21\u9a8c\u8bc1");
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("5\u5206\u949f\u5df2\u8fc7\uff0c\u5f00\u59cb\u7b2c\u4e8c\u6b21\u786e\u8ba4");
                for (int i = errorList.size() - 1; i > 0; --i) {
                    try {
                        String fileUrl;
                        fileUrl = (String)errorList.get(i);
                        visitFileUrl = null;
                        if (fileUrl.contains("/uploads/")) {
                            visitFileUrl = this.pushConfig.getInternet().getServerUrl().concat(fileUrl.substring(fileUrl.indexOf("/uploads/")));
                        } else {
                            String tempUrl = fileUrl.substring(8).replace("/upload/", "/");
                            visitFileUrl = this.pushConfig.getInternet().getServerUrl().concat("/uploads").concat(tempUrl.substring(tempUrl.indexOf("/")));
                        }
                        result = FileUtils.checkFile((String)visitFileUrl);
                        this.pushRecordUploadLogService.createLog(pushRecord.getRequestId(), pushRecord.getId(), null, fileUrl, visitFileUrl, result);
                        if (!result) continue;
                        errorList.remove(i);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u7b2c\u4e8c\u6b21\u786e\u8ba4\u6587\u4ef6\u662f\u5426\u4e0a\u4f20\u6210\u529f\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                log.info("\u7b2c\u4e8c\u6b21\u786e\u8ba4\u5b8c\u6210");
            }
            FileUtil.appendUtf8Lines(errorList, (String)checkErrorFile);
        }
        log.info("\u786e\u8ba4\u5b8c\u6210");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSqlFiles(PushRecord pushRecord) {
        block22: {
            log.info("\u5f00\u59cb\u6267\u884csql\u6587\u4ef6\u5217\u8868");
            pushRecord.setSqlStartTime(new Date());
            try {
                List fileList = FileUtil.listFileNames((String)pushRecord.geSqlPath());
                if (!CollectionUtils.isNotEmpty((Collection)fileList)) break block22;
                this.moveToFirst(fileList, "__DXZvc8mnEmDqMARhK7Gsync_SENDSMSTOPOLICE___DXZvc8mnEmDqMARhK7G.sql");
                this.moveToFirst(fileList, "__DXZvc8mnEmDqMARhK7Gsync_bg_user_result___DXZvc8mnEmDqMARhK7G.sql");
                this.moveToFirst(fileList, "__Qlqia54jXSOKQxX0rofv_tlk_backgroundreasons___Qlqia54jXSOKQxX0rof.sql");
                this.moveToFirst(fileList, "tenant-appsync_bg_user_view_tenant-app.sql");
                this.moveToFirst(fileList, "tenant-appcompanyinfocollect.employees_tenant-app.sql");
                Connection connection = DatabaseUtil.getConnection((String)this.url.concat("&jdbcCompliantTruncation=false"), (String)this.username, (String)this.password);
                boolean isWindows = "out-dev".equals(this.pushConfig.getEnvir());
                try {
                    int sqlFileCount = 0;
                    int sqlSuccessFileCount = 0;
                    ArrayList<String> sqlResultList = new ArrayList<String>();
                    String sqlErrorFile = pushRecord.getExecuteErrorTxtPath();
                    ArrayList<String> errorList = new ArrayList<String>();
                    errorList.add("");
                    errorList.add("sql\u811a\u672c\u6267\u884c\u5f02\u5e38\u89c1\u4ee5\u4e0b\u5217\u51fa\u7684\u811a\u672c\u6587\u4ef6\uff0c\u6839\u636e\u4ee5\u4e0b\u9519\u8bef\u4fe1\u606f\u53cd\u9988\u7ed9\u5f00\u53d1\u4eba\u5458\uff1a");
                    for (String sqlFile : fileList) {
                        ++sqlFileCount;
                        Closeable lineIterator = null;
                        try {
                            Date startTime = new Date();
                            log.info("\u5f00\u59cb\u6267\u884csql\u6587\u4ef6\uff1a{}", (Object)sqlFile);
                            String sqlResult = DatabaseUtil.execCommand((boolean)isWindows, (String)this.pushConfig.getDbIp(), (String)this.pushConfig.getDbPort(), (String)this.pushConfig.getDbUsername(), (String)this.pushConfig.getDbPassword(), (String)pushRecord.geSqlPath().concat(File.separator).concat(sqlFile));
                            Date endTime = new Date();
                            log.info("\u6267\u884c\u7ed3\u679c\uff1a{}", (Object)sqlResult);
                            String execResult = "success";
                            if (sqlResult.contains("ERROR")) {
                                execResult = sqlResult.substring(sqlResult.indexOf("ERROR"));
                                log.error("fail\uff0c\u6587\u4ef6\uff1a{}\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)sqlFile, (Object)execResult);
                                sqlResultList.add(String.format("fail\uff0c\u6587\u4ef6\uff1a%s\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", sqlFile, execResult));
                                errorList.add(String.format("\u6587\u4ef6\uff1a%s\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", sqlFile, execResult));
                            } else {
                                sqlResultList.add(String.format("success\uff0c\u6587\u4ef6\uff1a%s\uff0c\u6267\u884c\u6210\u529f\uff01", sqlFile));
                                log.info("success\uff0c\u6587\u4ef6\uff1a{}\uff0c\u6267\u884c\u6210\u529f\uff01", (Object)sqlFile);
                                ++sqlSuccessFileCount;
                            }
                            this.pushRecordSqlLogService.createLog(pushRecord.getRequestId(), pushRecord.getId(), sqlFile, 0L, startTime, endTime, execResult);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            String eMessage = e.getMessage();
                            log.error("fail\uff0c\u6587\u4ef6\uff1a{}\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)sqlFile, (Object)eMessage);
                            this.pushRecordSqlLogService.createLog(pushRecord.getRequestId(), pushRecord.getId(), sqlFile, 0L, null, null, eMessage);
                            sqlResultList.add(String.format("fail\uff0c\u6587\u4ef6\uff1a%s\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", sqlFile, eMessage));
                            errorList.add(String.format("\u6587\u4ef6\uff1a%s\uff0c\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", sqlFile, eMessage));
                        }
                        finally {
                            IOUtils.closeQuietly(lineIterator);
                        }
                    }
                    pushRecord.setSqlFileCount(Integer.valueOf(sqlFileCount));
                    pushRecord.setSqlSuccessFileCount(Integer.valueOf(sqlSuccessFileCount));
                    pushRecord.setSqlResult(String.join((CharSequence)"\r\n", sqlResultList));
                    FileUtil.appendUtf8Lines(errorList, (String)sqlErrorFile);
                }
                catch (Exception e) {
                    log.error("\u6267\u884csql\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException e) {
                        log.error("\u6267\u884csql\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884csql\u6587\u4ef6\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            }
        }
        pushRecord.setSqlEndTime(new Date());
        log.info("\u6267\u884csql\u6587\u4ef6\u7ed3\u675f");
    }

    private void moveToFirst(List<String> list, String element) {
        if (list.remove(element)) {
            list.add(0, element);
        }
    }

    public FerryReceiveTaskPushResult queryAutoFerryPushResult(String requestId) {
        log.info("===================================\u67e5\u8be2\u81ea\u52a8\u6446\u6e21\u63a8\u9001\u7ed3\u679c\uff0c\u67e5\u8be2requestId\uff1a{}=======================================", (Object)requestId);
        FerryReceiveTaskPushResult ferryReceiveTaskPushResult = new FerryReceiveTaskPushResult();
        if (StringUtils.isNotBlank((CharSequence)requestId)) {
            ferryReceiveTaskPushResult.setRequestId(requestId);
            PushRecord pushRecord = this.pushRecordService.getByRequestId(requestId);
            if (pushRecord != null && pushRecord.getSqlEndTime() != null) {
                String receiveResult = String.format("\u672c\u6b21\u6446\u6e21\u60c5\u51b5\uff1a\u9700\u8981\u6267\u884c\u7684sql\u6587\u4ef6\u6570\u91cf\uff1a%s\uff0c\u6267\u884c\u6210\u529f\u7684sql\u6587\u4ef6\u6570\u91cf\uff1a%s\uff0c\u9700\u8981\u4e0a\u4f20\u7684\u6587\u4ef6\u6570\u91cf\uff1a%s\uff0c\u4e0a\u4f20\u6210\u529f\u7684\u6587\u4ef6\u6570\u91cf\uff1a%s", pushRecord.getSqlFileCount() != null ? pushRecord.getSqlFileCount() : "\u6ca1\u8bb0\u5f55", pushRecord.getSqlSuccessFileCount() != null ? pushRecord.getSqlSuccessFileCount() : "\u6ca1\u8bb0\u5f55", pushRecord.getUploadFileCount() != null ? pushRecord.getUploadFileCount() : "\u6ca1\u8bb0\u5f55", pushRecord.getUploadSuccessFileCount() != null ? pushRecord.getUploadSuccessFileCount() : "\u6ca1\u8bb0\u5f55");
                ferryReceiveTaskPushResult.setReceiveResult(receiveResult);
                ferryReceiveTaskPushResult.setTaskStatus(Integer.valueOf(10));
            }
        }
        return ferryReceiveTaskPushResult;
    }
}

