package com.bcxin.ferry.strategy.callback.impl;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ferry.dtos.FerryDto;
import com.bcxin.ferry.service.FerryTaskService;
import com.bcxin.ferry.strategy.callback.ReceiveCallbackStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * description：接收摆渡完成回调策略
 * author：linchunpeng
 * date：2024/3/6
 */
@Slf4j
@Service
public class ReceiveFerryCompleteCallbackStrategy implements ReceiveCallbackStrategy {

    @Autowired
    private FerryTaskService ferryTaskService;

    @Async(value = "taskExecutor")
    @Override
    public void handle(String data) {
        //修改摆渡任务状态
        ferryTaskService.updateFerryTaskComplete(JSONObject.parseObject(data, FerryDto.class));
    }
}
