package com.bcxin.tenant.open.jdks.responses.exports;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.jdks.responses.PoliceIncidentOverviewResponse;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;


@Schema(name = "PoliceIncidentOverviewExportResponse",title = "PoliceIncidentOverviewExportResponse 警情上报列表")
@Getter
@ColumnWidth(20)
public class PoliceIncidentOverviewExportResponse extends ResponseAbstract {
    @ExcelProperty("事件编号")
    @Schema(name = "id", title = "id")
    private final String id;

    @ColumnWidth(50)
    @ExcelProperty("事件类别")
    @Schema(name = "name", title = "事件标题")
    private final String name;


    @ExcelProperty("事件类型")
    @Schema(name = "policeEventType", title = "事件类型")
    private final String policeEventType;

    @ExcelProperty("报警人员")
    @Schema(name = "tenantUserName", title = "姓名")
    private final String tenantUserName;

    @ExcelProperty("事件级别")
    @Schema(name = "policeEventLevel", title = "事件级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private final String policeEventLevel;
    @ColumnWidth(70)
    @ExcelProperty("事发地点")
    @Schema(name = "address", title = "事件地址")
    private final String address;

    @ExcelProperty("报警时间")
    @Schema(name = "createdTime", title = "创建（报案）时间")
    private final String createdTime;

    @ColumnWidth(50)
    @ExcelProperty("事件情况")
    @Schema(name = "reason", title = "事件情况")
    private final String reason;

    @ColumnWidth(50)
    @ExcelProperty("已采取措施")
    @Schema(name = "actionTaken", title = "已采取措施")
    private final String actionTaken;

    @ColumnWidth(50)
    @ExcelProperty("处理情况及发展趋势")
    @Schema(name = "actionTendency", title = "处理情况及发展趋势")
    private final String actionTendency;

    @ColumnWidth(50)
    @ExcelProperty("进一步处理意见")
    @Schema(name = "processedSuggestion", title = "公安建议-进一步处理意见")
    private final String processedSuggestion;

    @ColumnWidth(50)
    @ExcelProperty("现场指导意见")
    @Schema(name = "processedLocaleGuidance", title = "现场指导意见")
    private final String processedLocaleGuidance;

    @ExcelProperty("处理人")
    @Schema(name = "processedUserName", title = "处理人(公安)姓名")
    private final String processedUserName;

    @ExcelProperty("处理时间")
    @Schema(name = "processedTime", title = "处理时间")
    private final String processedTime;

    @ExcelProperty("图片")
    @Schema(name = "sceneUrl", title = "现场图片")
    private final String sceneUrl;

    @ExcelProperty("处理状态")
    @Schema(name = "policeEventStatus", title = "处理状态：None 待处理，Pending 处理中，Over 已处理")
    private final String policeEventStatus;

    @ExcelProperty("报警地址")
    @Schema(name = "location", title = "报警地址")
    private final String location;

    public PoliceIncidentOverviewExportResponse(PoliceIncidentOverviewResponse data) {
        this.id = data.getId();
        this.tenantUserName = data.getTenantUserName();
        this.name = data.getName();
        this.sceneUrl = data.getSceneUrl();
        this.policeEventStatus = data.getPoliceEventStatus();
        this.policeEventLevel = data.getPoliceEventLevel();
        this.address = data.getAddress();
        this.reason = data.getReason();
        this.policeEventType = data.getPoliceEventType();
        this.actionTaken = data.getActionTaken();
        this.actionTendency = data.getActionTendency();
        this.processedSuggestion = data.getProcessedSuggestion();
        this.processedLocaleGuidance = data.getProcessedLocaleGuidance();
        this.processedUserName = data.getProcessedUserName();
        this.processedTime = data.getProcessedTime();
        this.location = data.getLocation();

        this.createdTime = data.getCreatedTime();
    }

    public static PoliceIncidentOverviewExportResponse create(
            PoliceIncidentOverviewResponse data) {
        return new PoliceIncidentOverviewExportResponse(data);
    }
}
