package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.util.StringUtils;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name = "SponsorDispatchLogSearchResponse",title = "SponsorDispatchLogSearchResponse 发起者的调度信息")
@Getter
public class SponsorDispatchLogSearchResponse extends ResponseAbstract {
    @ExcelProperty("调度编号")
    @Schema(name = "pkId", title = "调度编号")
    private final String pkId;

    @ExcelIgnore
    @Schema(name = "id", title = "主键")
    private final String id;

    @ExcelProperty("调度开始时间")
    @Schema(name = "BeginTime", title = "调度开始时间")
    private String beginTime;
    @ExcelProperty("调度结束时间")
    @Schema(name = "endTime", title = "调度结束时间")
    private final String endTime;

    @ExcelProperty("调度方式")
    @Schema(name = "communicatedType", title = "调度方式")
    private final String communicatedType;

    @ColumnWidth(50)
    @ExcelProperty("调度方")
    @Schema(name = "callerCompanyName", title = "调度方")
    private final String callerCompanyName;

    @ExcelProperty("调度人")
    @Schema(name = "callerUserName", title = "调度人")
    private final String callerUserName;

    @Schema(name = "dispatchTime", title = "调度时长(分钟)")
    private final int dispatchTime;

    public SponsorDispatchLogSearchResponse(String pkId, String id,
                                            Date beginTime,
                                            Date endTime, CommunicatedType communicatedType,
                                            String callerCompanyName,
                                            String callerUserName) {
        this.pkId = pkId;
        this.id = id;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.beginTime = dateFormat.format(beginTime);
        this.endTime = dateFormat.format(endTime);
        this.communicatedType = communicatedType.getTypeName();
        this.callerCompanyName = callerCompanyName;
        this.callerUserName = callerUserName;
        if (endTime != null && beginTime != null) {
            this.dispatchTime = (int) Math.ceil(((endTime.getTime() - beginTime.getTime()) * 1.0 / 1000) / 60);
        } else {
            this.dispatchTime = -1;
        }
    }

    public static SponsorDispatchLogSearchResponse create(String pkId, String id,
                                                          Date beginTime,
                                                          Date endTime,
                                                          String communicatedType,
                                                          String callerCompanyName,
                                                          String callerUserName) {
        CommunicatedType ct = CommunicatedType.Audio;
        if(!StringUtils.isEmpty(communicatedType))
        {
           if(communicatedType.equalsIgnoreCase(String.valueOf(CommunicatedType.Video.ordinal())))
           {
               ct = CommunicatedType.Video;
           }
        }
        return new SponsorDispatchLogSearchResponse(pkId, id, beginTime, endTime, ct, callerCompanyName, callerUserName);
    }
}
