package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "SearchNearByCompanyResponse",title = "人员轨迹信息")
@Getter
public class SearchNearByCompanyResponse extends ResponseAbstract {
    @Schema(name = "id", title = "企业id")
    private final String id;
    @Schema(name = "id", title = "企业名称")
    private final String name;

    @Schema(name = "filteredLatitude", title = "进行过滤的y轴坐标")
    private final double filteredLatitude;

    @Schema(name = "filteredLongitude", title = "进行过滤的x轴坐标")
    private final double filteredLongitude;

    @Schema(name = "distance", title = "过滤的坐标与此的距离;单位m")
    private final double distance;

    public SearchNearByCompanyResponse(String id, String name, double filteredLatitude,double filteredLongitude,double distance) {
        this.id = id;
        this.name = name;
        this.filteredLatitude = filteredLatitude;
        this.filteredLongitude = filteredLongitude;
        this.distance = distance;
    }

    public static SearchNearByCompanyResponse create(String id, String name, double filteredLatitude,double filteredLongitude,double distance) {
        return new SearchNearByCompanyResponse(id, name, filteredLatitude, filteredLongitude,distance);
    }
}