package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.KeyValueConstants;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Data;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

@Data
public class RdDeviceDeskPermissionResponse extends ResponseAbstract {

    private Collection<RdDeviceDeskServiceScopeResponse> serviceScopes;

    public boolean isSuperviseDesk() {
        if (this.getServiceScopes() == null || this.getServiceScopes().size() == 0) {
            return false;
        }

        return this.getServiceScopes().stream()
                .anyMatch(ii ->
                        ii.getAssignedSuperviseDepartId() != null &&
                                !ii.getAssignedSuperviseDepartId().isEmpty()
                );
    }


    public Collection<RdDeviceDeskServiceScopeResponse> getAllowedServiceScopes(String ipAddress) {
        /**
         * 不限制IP地址 XQ20240111902 at 2024-01-12
         */
        if(true) {
            return this.getServiceScopes();
        }

        if (KeyValueConstants.IGNORE_IP_ADDRESS_VALUE.equalsIgnoreCase(ipAddress)) {
            return this.getServiceScopes();
        }

        return this.getServiceScopes().stream()
                .filter(ii -> {
                            //getAssignedSuperviseDepartId为空的表示企业调度
                            if (StringUtil.isEmpty(ii.getAssignedSuperviseDepartId()) ||
                                    //针对监管端-IP地址是必填的
                                    (KeyValueConstants.IGNORE_IP_ADDRESS_VALUE.equalsIgnoreCase(ii.getIpAddress()))) {
                                return true;
                            }
                            //针对监管调度, IP必须不为空
                            if (!StringUtil.isEmpty(ii.getAssignedSuperviseDepartId()) && StringUtil.isEmpty(ii.getIpAddress())) {
                                return false;
                            }

                            //针对监管调度, IP必须不为空; 企业调度已经再第一步返回了.
                            if (StringUtil.isEmpty(ii.getIpAddress())) {
                                return false;
                            }

                            return
                                    Arrays.stream(ii.getIpAddress().split(";")).anyMatch(ix ->
                                            ix.equalsIgnoreCase(ipAddress) ||
                                                    KeyValueConstants.IGNORE_IP_ADDRESS_VALUE.equalsIgnoreCase(ix)
                                    );
                        }
                ).collect(Collectors.toList());
    }

    public RdDeviceDeskPermissionResponse() {
    }

    public RdDeviceDeskPermissionResponse(Collection<RdDeviceDeskServiceScopeResponse> serviceScopes) {
        this.serviceScopes = serviceScopes;
    }

    public static RdDeviceDeskPermissionResponse create(Collection<RdDeviceDeskServiceScopeResponse> serviceScopes) {
        return new RdDeviceDeskPermissionResponse(serviceScopes);
    }

    @Data
    public static class RdDeviceDeskServiceScopeResponse extends ResponseAbstract {
        private String id;

        /**
         * 调度台名称
         */
        private String name;

        /**
         * 腾讯的资源号
         */
        private String number;
        /**
         * 有效期开始时间
         */
        private Timestamp beginDate;
        /**
         * 有效期结束时间
         */
        private Timestamp endDate;
        /**
         * 被绑定的人
         */
        private String boundEmployeeId;

        /**
         * 被授权的监管归属的部门Id
         */
        private String assignedSuperviseDepartId;

        private String ipAddress;

        /**
         * 所属企业Id
         */
        private String organizationId;

        private String desc;

        private byte ir;


        public boolean isActive() {
            if (this.getBeginDate() == null || this.getEndDate() == null) {
                return false;
            }

            Date currentDate = Calendar.getInstance().getTime();

            /**
             * todo 暂时永不过期
             */
            //return true;
            return currentDate.after(this.getBeginDate()) && currentDate.before(this.getEndDate());
        }


        public RdDeviceDeskServiceScopeResponse() {
        }

        public RdDeviceDeskServiceScopeResponse(String id,
                                                String name,
                                                String number,
                                                Timestamp beginDate, Timestamp endDate,
                                                String boundEmployeeId,
                                                String assignedSuperviseDepartId,
                                                String ipAddress,
                                                String organizationId,
                                                String desc,
                                                byte ir) {
            this.id = id;
            this.name = name;
            this.number = number;
            this.beginDate = beginDate;
            this.endDate = endDate;
            this.boundEmployeeId = boundEmployeeId;
            this.assignedSuperviseDepartId = assignedSuperviseDepartId;
            this.ipAddress = ipAddress;
            this.organizationId = organizationId;
            this.desc = desc;
            this.ir = ir;
        }

        public static RdDeviceDeskServiceScopeResponse create(String id,
                                                              String name,
                                                              String number,
                                                              Timestamp beginDate, Timestamp endDate,
                                                              String boundEmployeeId,
                                                              String assignedSuperviseDepartId,
                                                              String ipAddress,
                                                              String organizationId,
                                                              String desc,
                                                              byte ir) {
            return new RdDeviceDeskServiceScopeResponse(id,
                    name,
                    number, beginDate, endDate,
                    boundEmployeeId, assignedSuperviseDepartId, ipAddress,
                    organizationId,desc, ir);
        }
    }
}


