package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.DutySignInType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "EmployeeDutyStatusResponse", title = "保安员在离岗状态信息")
@Data
public class EmployeeDutyStatusResponse extends ResponseAbstract {
    @Schema(name = "tenantEmployeeId", title = "职员id")
    private String tenantEmployeeId;
    @Schema(name = "tenantUserId", title = "user id")
    private String tenantUserId;
    @Schema(name = "idCardNo", title = "证件号码")
    private String idCardNo;
    @Schema(name = "organizationId", title = "公司id")
    private String organizationId;
    @Schema(name = "name", title = "保安员姓名")
    private String name;
    @Schema(name = "contact", title = "保安员联系电话")
    private String contact;

    public EmployeeDutyStatusResponse(String tenantEmployeeId, String tenantUserId, String idCardNo,
                                      String organizationId, String name, String contact) {
        this.tenantEmployeeId = tenantEmployeeId;
        this.tenantUserId = tenantUserId;
        this.idCardNo = idCardNo;
        this.organizationId = organizationId;
        this.name = name;
        this.contact = contact;
    }

    public static EmployeeDutyStatusResponse create(String tenantEmployeeId,
                                                    String tenantUserId,
                                                    String idCardNo,
                                                    String organizationId,
                                                    String name,
                                                    String contact){
        return new EmployeeDutyStatusResponse(
                tenantEmployeeId,
                tenantUserId,
                idCardNo,
                organizationId,
                name,
                contact);
    }
}
