package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "EmployeeCountResponse", title = "驻勤点在离岗人员数量信息")
@Data
public class EmployeeCountResponse extends ResponseAbstract {
    @Schema(name = "totalNumber", title = "驻勤点总人员数量")
    private Integer totalNumber;
    @Schema(name = "onDutyNumber", title = "在岗人员数量")
    private Integer onDutyNumber;
    @Schema(name = "offDutyNumber",title = "离岗人员数量")
    private Integer offDutyNumber;

    public EmployeeCountResponse(Integer totalNumber, Integer onDutyNumber, Integer offDutyNumber){
        this.totalNumber = totalNumber;
        this.onDutyNumber = onDutyNumber;
        this.offDutyNumber = offDutyNumber;
    }

    public static EmployeeCountResponse create(Integer totalNumber, Integer onDutyNumber, Integer offDutyNumber){
        return new EmployeeCountResponse(totalNumber, onDutyNumber, offDutyNumber);
    }
}
