package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.valueTypes.GeoLocationValueType;
import com.bcxin.tenant.open.jdks.requests.CompanySearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Set;

@Schema(name = "CompanySearchResponse",title = "CompanySearchResponse 公司信息搜索结果")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CompanySearchResponse extends ResponseAbstract {
    @Schema(name = "id",title = "企业id")
    private final String id;

    @Schema(name = "name",title = "企业名称")
    private final String name;

    @Schema(name = "legal", title = "法人姓名")
    private final String legal;

    @Schema(name = "legalContact", title = "法人联系方式")
    private final String legalContact;

    @Schema(name = "registerAddress", title = "注册地")
    private final String registerAddress;

    @Schema(name = "businessAddress", title = "经营地")
    private final String businessAddress;

    @Schema(name = "latitude", title = "企业所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "企业所在x轴坐标")
    private final Double longitude;

    @Schema(name = "countOfTemporaryProject", title = "临保项目数量")
    private final long countOfTemporaryProject;

    private final Set<String> followedDeviceNos;

    @Schema(name = "isFollowed", title = "是否关注")
    private final Boolean followed;

    public CompanySearchResponse(
            CompanySearchRequest.SearchModel searchModel,
            String id, String name, String legal,
                                 String legalContact, String registerAddress,
                                 String businessAddress,
                                 Double latitude, Double longitude,
                                 Set<String> followedDeviceNos,
                                 Boolean followed,
            long countOfTemporaryProject
                                 ) {
        this.id = id;

        if (GeoLocationValueType.isValidLocation(latitude, longitude)) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = null;
            this.longitude = null;
        }

        if (searchModel == CompanySearchRequest.SearchModel.SecurityResource) {
            this.name = null;
            this.legal = null;
            this.legalContact = null;
            this.registerAddress = null;
            this.businessAddress = null;
        } else {
            this.name = name;
            this.legal = legal;
            this.legalContact = legalContact;
            this.registerAddress = registerAddress;
            this.businessAddress = businessAddress;
        }

        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.countOfTemporaryProject = countOfTemporaryProject;
    }

    public static CompanySearchResponse create(
            CompanySearchRequest.SearchModel searchModel,
            String id, String name, String legal,
                                               String legalContact, String registerAddress,
                                               String businessAddress,
                                               Double latitude, Double longitude,
            Set<String> followedDeviceNos,
            Boolean followed,
            long countOfTemporaryProject) {
        return new CompanySearchResponse(
                searchModel,
                id, name, legal, legalContact, registerAddress,
                businessAddress, latitude, longitude, followedDeviceNos, followed,countOfTemporaryProject
        );
    }
}
