package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "AttendanceGroupSearchResponse",title = "AttendanceGroupSearchResponse 签到签退统计信息")
@Getter
@ColumnWidth(20)
public class AttendanceGroupSearchResponse  extends ResponseAbstract {
    @ExcelIgnore
    @Schema(name = "employeeId", title = "职员Id")
    private final String employeeId;
    @ExcelProperty("姓名")
    @Schema(name = "name", title = "姓名")
    private final String name;
    @ExcelProperty("身份证")
    @Schema(name = "idCard", title = "身份证")
    private final String idCard;
    @ExcelProperty("持证状态")
    @Schema(name = "securityCertificateNoStatus", title = "持证状态")
    private final String securityCertificateNoStatus;
    @ExcelProperty("公司名称")
    @Schema(name = "companyName", title = "公司名称")
    private final String companyName;

    @ExcelIgnore
    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;

    @ExcelProperty("操作类型")
    @Schema(name = "dutyStatusText", title = "操作类型(多值)")
    private final String dutyStatusText;

    @ExcelProperty("操作次数")
    @Schema(name = "countOfDutyStatus", title = "操作次数")
    private final int countOfDutyStatus;

    @ColumnWidth(50)
    @ExcelProperty("项目名称")
    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @ColumnWidth(50)
    @ExcelProperty("项目所属公司名称")
    @Schema(name = "projectCompanyName", title = "项目所属公司名称")
    private String projectCompanyName;

    public AttendanceGroupSearchResponse(String employeeId, String name, String idCard,
                                         String securityCertificateNo,
                                         String organizationId,
                                         String companyName,
                                         String dutyStatusText,
                                         int countOfDutyStatus,
                                         String projectName,
                                         String projectCompanyName) {
        this.employeeId = employeeId;
        this.name = name;
        this.idCard = idCard;
        this.securityCertificateNoStatus = StringUtil.isEmpty(securityCertificateNo) || securityCertificateNo.length() < 3 ? "未持证" : "已持证";
        this.companyName = companyName;
        this.organizationId = organizationId;
        StringBuilder dutySb = new StringBuilder();
        if (!StringUtil.isEmpty(dutyStatusText)) {
            if (dutyStatusText.contains(String.valueOf(RecordStatus.SignIn.ordinal()))) {
                dutySb.append(RecordStatus.SignIn.getTypeName());
            }


            if (dutyStatusText.contains(String.valueOf(RecordStatus.SignOut.ordinal()))) {
                if (dutySb.length() > 0) {
                    dutySb.append("/");
                }

                dutySb.append(RecordStatus.SignOut.getTypeName());
            }
        }

        this.dutyStatusText = dutySb.toString();
        this.countOfDutyStatus = countOfDutyStatus;
        this.projectName = projectName;
        this.projectCompanyName = projectCompanyName;
    }

    public static AttendanceGroupSearchResponse create(String employeeId, String name, String idCard,
                                                       String securityCertificateNo,
                                                       String organizationId,
                                                       String companyName,
                                                       String dutyStatusText,
                                                       int countOfDutyStatus,
                                                       String projectName,
                                                       String projectCompanyName) {
        return new AttendanceGroupSearchResponse(employeeId, name, idCard,
                securityCertificateNo,organizationId, companyName, dutyStatusText,
                countOfDutyStatus,projectName,projectCompanyName);
    }
}
