package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;

@Schema(name = "AttendanceGroupDetailSearchResponse",title = "签到签退分组详情列表")
@Getter
@ColumnWidth(20)
public class AttendanceGroupDetailSearchResponse extends ResponseAbstract {
    @ExcelProperty("姓名")
    @Schema(name = "name", title = "姓名")
    private final String name;
    @ExcelProperty("身份证")
    @Schema(name = "idCard", title = "身份证")
    private final String idCard;

    @ExcelProperty("持证状态")
    @Schema(name = "securityCertificateNoStatus", title = "持证状态")
    private final String securityCertificateNoStatus;
    @ExcelProperty("公司名称")
    @Schema(name = "companyName", title = "公司名称")
    private final String companyName;

    @ExcelIgnore
    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;

    @ExcelProperty("操作类型")
    @Schema(name = "status", title = "操作类型")
    private final String status;

    @ExcelProperty("操作时间")
    @Schema(name = "createdTime", title = "操作时间")
    private final String createdTime;

    @ExcelProperty("操作地址")
    @Schema(name = "address", title = "操作地址")
    private final String address;

    @ExcelIgnore
    @Schema(name = "securityStationId", title = "驻勤点Id")
    private final String securityStationId;

    @ExcelProperty("驻勤点名称")
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @ExcelIgnore
    @Schema(name = "projectId", title = "项目Id")
    private final String projectId;

    @ExcelProperty("驻勤点名称")
    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @ColumnWidth(50)
    @ExcelProperty("项目所属公司名称")
    @Schema(name = "projectCompanyName", title = "项目所属公司名称")
    private final String projectCompanyName;

    @ExcelIgnore
    @Schema(name = "securityDepartId", title = "驻勤点监管Id")
    private final String securityDepartId;

    @ExcelProperty("驻勤点监管机构")
    @Schema(name = "securityDepartName", title = "驻勤点监管机构")
    private final String securityDepartName;

    @ExcelProperty("驻勤点地址")
    @Schema(name = "securityStationAddress", title = "驻勤点地址")
    private final String securityStationAddress;

    @Schema(name = "items", title = "扩展字段: items.regionName表示所属区域; ")
    private final Map<String, Object> items;


    public AttendanceGroupDetailSearchResponse(String name, String idCard,
                                               String securityCertificateNo,
                                               String organizationId,
                                               String companyName,
                                               RecordStatus status, Timestamp createdTime, String address,
                                               String securityStationId,String securityDepartId,
                                               String securityStationName, String securityDepartName,
                                               String securityStationAddress,
                                               String projectId,
                                               String projectName,
                                               Map<String, Object> items,
                                               String projectCompanyName) {
        this.name = name;
        this.idCard = idCard;
        this.securityCertificateNoStatus =
                StringUtil.isEmpty(securityCertificateNo) || securityCertificateNo.length() < 3 ? "未持证" : "已持证";
        this.companyName = companyName;
        this.status = status.getTypeName();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.createdTime = dateFormat.format(createdTime);
        this.address = address;
        this.securityStationName = securityStationName;
        this.securityDepartName = securityDepartName;
        this.securityStationAddress = securityStationAddress;
        this.organizationId = organizationId;
        this.securityDepartId = securityDepartId;
        this.securityStationId = securityStationId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.items = items;
        this.projectCompanyName = projectCompanyName;
    }

    public static AttendanceGroupDetailSearchResponse create(String name, String idCard,
                                                             String securityCertificateNo,
                                                             String organizationId,
                                                             String companyName,
                                                             RecordStatus status, Timestamp createdTime, String address,
                                                             String securityStationId,String securityDepartId,
                                                             String securityStationName, String securityDepartName,
                                                             String securityStationAddress,
                                                             String projectId,
                                                             String projectName,
                                                             Map<String, Object> items,
                                                             String projectCompanyName)
    {
        return new AttendanceGroupDetailSearchResponse(name,idCard,securityCertificateNo,
                organizationId,
                companyName,status,
                createdTime,address,
                securityStationId,securityDepartId,
                securityStationName,securityDepartName,securityStationAddress,
                projectId,projectName,items,projectCompanyName);
    }
}
