package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "UpdatePoliceIncidentsRequest",title = "UpdatePoliceIncidentsRequest 处理警情")
@Data
public class UpdatePoliceIncidentsRequest extends RequestAbstract {
    @Schema(name = "id", title = "ID")
    private Long id;
    @Schema(name = "policeEventStatus", title = "处理状态：None 待处理，Pending 处理中，Over 已处理")
    private PoliceEventStatus policeEventStatus;
    @Schema(name = "actionTaken", title = "已采取措施/sos的处理说明")
    private String actionTaken;
    @Schema(name = "actionTendency", title = "发展趋势; 针对Sos的时候放空")
    private String actionTendency;
    @Schema(name = "processedSuggestion", title = "公安建议; 针对Sos的时候放空")
    private String processedSuggestion;
    @Schema(name = "processedLocaleGuidance", title = "现场指导意见; 针对Sos的时候放空")
    private String processedLocaleGuidance;

    @Schema(name = "points", title = "积分数")
    private int points;
}