package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Schema(name = "RollCallEmployeeSearchRequest",title = "点名记录的详情以及我被点名的记录")
@Data
public class RollCallEmployeeSearchRequest extends SearchRequestAbstract {

    @Schema(name = "beginDate", title = "开始日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;

    @Schema(name = "endDate", title = "结束日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @Schema(name = "superviseDepartIds", title = "辖区信息")
    private Collection<String> superviseDepartIds;

    @Schema(name = "rollCallId", title = "在Web端通过点名列表进入的界面")
    private String rollCallId;

    @Schema(name = "callTypes", title = "点名类型: RollCall 点名轮换; Dispatch 督导点名")
    private Collection<RollCallType> callTypes;

    @Schema(name = "callStatuses", title = "点名状态: RollCallInit 点名中; RollCallSuccess 点名成功; RollCallFailed 点名失败; DispatchInit 督导中; DispatchSuccess 督导成功; DispatchFailed 督导失败")
    private Collection<RollCallStatus> callStatuses;

    @Schema(name = "securityStationId", title = "指定驻勤点的点名记录")
    private String securityStationId;

    @Schema(name = "onlyForBeingCalledRecord", title = "仅搜索我的点名记录--当来自APP搜索我的记录的时候; 该值设置为true")
    private boolean onlyForBeingCalledRecord;

}
