package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import lombok.Data;

@Data
public class RollCallAutoCancelEmployeeRequest extends RequestAbstract {

    private final RollCallStatus callStatus;

    public RollCallAutoCancelEmployeeRequest(RollCallStatus callStatuses) {
        this.callStatus = callStatuses;
    }

    public static RollCallAutoCancelEmployeeRequest create(RollCallStatus callStatuses) {

        if (callStatuses != RollCallStatus.RollCallInit && callStatuses != RollCallStatus.DispatchInit) {
            throw new NoAllowedTenantException(String.format("%s is not allowed to be cancelled", callStatuses));
        }

        return new RollCallAutoCancelEmployeeRequest(callStatuses);
    }
}
