package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Timestamp;

@Schema(name = "RdSecurityStationRailRequest",title = "RdSecurityStationRailRequest 电子围栏对象")
@Data
public class RdSecurityStationRailRequest extends RequestAbstract {
    @Schema(name = "name", title = "电子围栏名称")
    private String name;

    @Schema(name = "shapeType", title = "电子围栏形状: Circle=圆形, Crib=框形状, Polygon=多边形")
    private RailShapeType shapeType;

    private RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation;

    @Schema(name = "stationId", title = "所在驻勤点")
    private String stationId;

    @Schema(name = "organizationId", title = "所在驻勤点的组织id")
    private String organizationId;

    @Schema(name = "fromStationManagement", title = "是否来自驻勤管理的请求")
    private boolean fromStationManagement;

    @Schema(name = "stationName", title = "所属驻勤点名称（仅驻勤管理这边新增的电子围栏才用到此属性）")
    private String stationName;
    @Schema(name = "superviseDepartId", title = "所属驻勤点监管归属Id（仅驻勤管理这边新增的电子围栏才用到此属性）")
    private String superviseDepartId;
    @Schema(name = "superviseDepartName", title = "所属驻勤点监管归属名称（仅驻勤管理这边新增的电子围栏才用到此属性）")
    private String superviseDepartName;

    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @Schema(name = "beginTime", title = "电子围栏开始生效时间: yyyy-MM-dd HH:mm:ss")
    private Timestamp beginTime;

    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @Schema(name = "endTime", title = "电子围栏生效结束时间: yyyy-MM-dd HH:mm:ss")
    private Timestamp endTime;

    @Schema(name = "ruleType", title = "围栏类型: Exit=离开告警, Enter=进入告警, Access 进出告警")
    private RailRuleType ruleType;

    @Schema(name = "note", title = "备注")
    private String note;
}
