package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "ProjectRoadmapRequest", title = "项目路线信息请求")
@Data
public class ProjectRoadmapSearchRequest extends SearchRequestAbstract{
    @Schema(name = "name", title = "路线名称-左模糊搜索")
    private final String name;
    @Schema(name = "organizationName", title = "企业名称-左模糊搜索")
    private final String organizationName;
    @Schema(name = "projectIds", title = "要展示的路线的项目列表Id")
    private final Collection<String> projectIds;
}
