package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collection;
import java.util.Collections;

@Schema(name = "OrgPursePointRequest",title = "OrgPursePointRequest 调度前的企业组织验证")
@Data
public class OrgPursePointRequest extends RequestAbstract {
    @Schema(name = "organizationIds", title = "被调度人所在的企业id集合")
    private Collection<String> organizationIds;

    public static OrgPursePointRequest create(Collection<String> organizationIds) {
        OrgPursePointRequest request = new OrgPursePointRequest();
        request.setOrganizationIds(organizationIds);

        return request;
    }

    public static OrgPursePointRequest create(String organizationId) {
        return create(Collections.singleton(organizationId));
    }

    public boolean matched(String organizationId) {
        if (StringUtil.isEmpty(organizationId)) {
            return false;
        }

        if (CollectionUtils.isEmpty(this.getOrganizationIds())) {
            return false;
        }

        return this.getOrganizationIds().contains(organizationId);
    }
}
