package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "ExamSiteRoomSearchRequest",title = "ExamSiteRoomSearchRequest 考场搜索")
@Data
public class ExamSiteRoomSearchRequest  extends SearchRequestAbstract {
    @Schema(name = "keyword", title = "关键字搜索")
    private String keyword;

    @Schema(name = "searchModel", title = "搜索模式: keyword 则表示搜索考场; SecurityResource 则安保资源")
    private ExamSiteRoomSearchRequest.SearchModel searchModel;

    @Schema(name = "superviseDepartIds", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;

    @Schema(name = "followed", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 根据是否关注进行过滤(null=全部; false=未关注; true=关注)")
    private Boolean followed;

    @Schema(name = "status", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 是否启用进行过滤(null=全部; false=禁用; true=启用)")
    private Boolean status;

    @Schema(name = "examTaking", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 考试状态(null=全部; false=无考试; true=考试中)")
    private Boolean examTaking;

    public static enum SearchModel {
        Keyword,
        @Schema(name = "SecurityResource", title = "安保资源")
        SecurityResource
    }
}