package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.DeviceStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "DeviceSearchRequest",title = "DeviceSearchRequest 智能设备搜索")
@Data
public class DeviceSearchRequest extends SearchRequestAbstract {
    @Schema(name = "keyword", title = "当searchModel=keyword 的时候有效; 搜索姓名/身份证信息;其中如果keyword如果只包含数字;则系统只搜索身份证")
    private String keyword;
    @Schema(name = "latitude", title = "当searchModel=geo 的时候有效; 周边搜索的x轴的坐标")
    private Double latitude;
    @Schema(name = "longitude", title = "当searchModel=geo 的时候有效; 周边搜索的y轴的坐标")
    private Double longitude;
    @Schema(name = "distance", title = "当searchModel=geo 的时候有效; 周边搜索的半径长度定义,单位为米")
    private Double distance;
    @Schema(name = "searchModel", title = "搜索模式: keyword 则表示搜索姓名/身份证; geo 则表示进行周边搜索; Other 则表示按照驻勤类型进行搜索; DispatchBookAddress 调度通讯录-支持根据驻勤点Id和关键字进行搜索并分页")
    private SearchModel searchModel;
    @Schema(name = "superviseDepartIds", title = "安保资源: 当searchModel=SecurityResource 的时候有效; 选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;
    @Schema(name = "ids", title = "当searchModel=Selected的时候有效; 根据选中的Ids返回信息; 用于派出所或者安保资源中的圈选调度;")
    private Collection<String> ids;

    @Schema(name = "statuses", title = "搜索在岗离岗状态")
    private Collection<DeviceStatus> statuses;

    @Schema(name = "skipPageLimit", title = "skipPageLimit 是否跳过分页选项")
    private boolean skipPageLimit;

    public static enum SearchModel {
        @Schema(name = "Keyword", title = "关键字搜索")
        Keyword,
        @Schema(name = "Geo", title = "周边搜索")
        Geo,
        @Schema(name = "SecurityResource", title = "安保资源")
        SecurityResource,
        @Schema(name = "Selected", title = "返回选中设备的信息")
        Selected,
    }
}
