package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RecordStatus;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Schema(name = "AttendanceAdvanceSearchRequest",title = "高级高级筛选条件")
@Data
public class AttendanceGroupSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "name", title = "人员姓名")
    private String name;
    @Schema(name = "companyName", title = "公司名称")
    private String companyName;
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private String securityStationName;
    @Schema(name = "superviseDepartIds", title = "监管机构ID")
    private Collection<String> superviseDepartIds;
    @Schema(name = "createdStarDate", title = "签到日期 yyyy-MM-dd hh:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdStarDate;
    @Schema(name = "createdEndDate", title = "签到日期 yyyy-MM-dd hh:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createdEndDate;
    @Schema(name = "idCardNo", title = "身份证号")
    private String idCardNo;
    @Schema(name = "hasSecurityCertificateNo", title = "null=未选中; true=持证; false=未持证")
    private Boolean hasSecurityCertificateNo;

    @Schema(name = "recordStatuses", title = "签到状态; 多选; SignIn=签到;SignOut=签退; ")
    private Collection<RecordStatus> recordStatuses;
    @Schema(name = "projectName", title = "项目名称")
    private String projectName;

    @Schema(name = "projectCompanyName", title = "项目所属公司名称")
    private String projectCompanyName;
}
