// import Cookies from 'js-cookie';

export const Session = {
  set(key: string, val: any) {
    // if (key === 'token') return Cookies.set(key, val);
    sessionStorage.setItem(key, JSON.stringify(val))
  },
  get(key: string) {
    // if(key==='token') return Cookies.get(key);
    let json = <string>window.sessionStorage.getItem(key);
    return JSON.parse(json)
  },
  remove(key: string) {
    // if(key==='token') return Cookies.remove(key)
    sessionStorage.removeItem(key)
  },
  clear() {
    // Cookies.remove('token')
    window.sessionStorage.clear()
  }
}

export const Local = {
  set(key: string, val: any) {
    localStorage.setItem(key, JSON.stringify(val))
  },
  get(key: string) {
    let json = <string>window.localStorage.getItem(key);
    return JSON.parse(json)
  },
  remove(key: string) {
    localStorage.removeItem(key)
  },
  clear() {
    localStorage.clear()
  }
}