/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.zbkj.common.config.CrmebConfig;
import com.zbkj.common.constants.CouponConstants;
import com.zbkj.common.constants.ExperienceRecordConstants;
import com.zbkj.common.constants.OrderConstants;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.constants.UserConstants;
import com.zbkj.common.constants.VisitRecordConstants;
import com.zbkj.common.enums.BizEnum;
import com.zbkj.common.model.bcx.BcxPayOffline;
import com.zbkj.common.model.bcx.BcxPayOfflineFile;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.coupon.Coupon;
import com.zbkj.common.model.coupon.CouponUser;
import com.zbkj.common.model.order.MerchantOrder;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.order.RechargeOrder;
import com.zbkj.common.model.record.BrowseRecord;
import com.zbkj.common.model.record.UserVisitRecord;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.system.SystemUserLevel;
import com.zbkj.common.model.user.User;
import com.zbkj.common.model.user.UserExperienceRecord;
import com.zbkj.common.model.user.UserLevel;
import com.zbkj.common.model.user.UserToken;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.service.service.AsyncService;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BrowseRecordService;
import com.zbkj.service.service.CommunityNotesService;
import com.zbkj.service.service.CommunityReplyService;
import com.zbkj.service.service.CouponService;
import com.zbkj.service.service.CouponUserService;
import com.zbkj.service.service.MerchantOrderService;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.OrderStatusService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.SystemUserLevelService;
import com.zbkj.service.service.TemplateMessageService;
import com.zbkj.service.service.UserExperienceRecordService;
import com.zbkj.service.service.UserLevelService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTokenService;
import com.zbkj.service.service.UserVisitRecordService;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import com.zbkj.service.service.bcx.BcxPayOfflineFileService;
import com.zbkj.service.service.bcx.BcxPayOfflineService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class AsyncServiceImpl
implements AsyncService {
    private final Logger logger = LoggerFactory.getLogger(AsyncServiceImpl.class);
    @Autowired
    private ProductService storeProductService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserVisitRecordService userVisitRecordService;
    @Autowired
    private BrowseRecordService browseRecordService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private MerchantOrderService merchantOrderService;
    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private OrderStatusService orderStatusService;
    @Autowired
    private UserService userService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private CrmebConfig crmebConfig;
    @Autowired
    private SystemNotificationService systemNotificationService;
    @Autowired
    private UserTokenService userTokenService;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private UserExperienceRecordService userExperienceRecordService;
    @Autowired
    private SystemUserLevelService systemUserLevelService;
    @Autowired
    private UserLevelService userLevelService;
    @Lazy
    @Autowired
    private CommunityNotesService communityNotesService;
    @Lazy
    @Autowired
    private CommunityReplyService communityReplyService;
    @Lazy
    @Autowired
    private CouponService couponService;
    @Lazy
    @Autowired
    private CouponUserService couponUserService;
    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Resource
    private BcxPlatformFeeService bcxPlatformFeeService;
    @Resource
    private BcxFapiaoSourceService bcxFapiaoSourceService;
    @Resource
    private BcxPayOfflineService bcxPayOfflineService;
    @Resource
    private BcxPayOfflineFileService bcxPayOfflineFileService;

    @Override
    @Async
    public void productDetailStatistics(Integer proId, Integer uid) {
        this.storeProductService.addBrowse(proId);
        String dateStr = DateUtil.date().toString("yyyy-MM-dd");
        this.redisUtil.incrAndCreate("statistics:product:page_view:" + dateStr);
        this.redisUtil.incrAndCreate(StrUtil.format((CharSequence)"statistics:product:pro_page_view:{}:{}", (Object[])new Object[]{dateStr, proId}));
        if (uid.equals(0)) {
            return;
        }
        if (uid > 0) {
            UserVisitRecord visitRecord = new UserVisitRecord();
            visitRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
            visitRecord.setUid(uid);
            visitRecord.setVisitType(VisitRecordConstants.VISIT_TYPE_DETAIL);
            this.userVisitRecordService.save(visitRecord);
            BrowseRecord browseRecord = this.browseRecordService.getByUidAndProId(uid, proId);
            if (ObjectUtil.isNull((Object)browseRecord)) {
                browseRecord = new BrowseRecord();
                browseRecord.setUid(uid);
                browseRecord.setProductId(proId);
                browseRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
                browseRecord.setCreateTime((Date)DateUtil.date());
                this.browseRecordService.save(browseRecord);
            } else {
                browseRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
                this.browseRecordService.myUpdate(browseRecord);
            }
        }
    }

    @Override
    @Async
    public void saveUserVisit(Integer userId, Integer visitType) {
        UserVisitRecord visitRecord = new UserVisitRecord();
        visitRecord.setDate(DateUtil.date().toDateStr());
        visitRecord.setUid(userId);
        visitRecord.setVisitType(visitType);
        this.userVisitRecordService.save(visitRecord);
    }

    @Override
    @Async
    public void orderPaySuccessSplit(String orderNo) {
        Boolean execute;
        Order order = this.orderService.getByOrderNo(orderNo);
        if (ObjectUtil.isNull((Object)order)) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u8ba2\u5355\u4e0d\u5b58\u5728\uff0corderNo: {}", (Object)orderNo);
            return;
        }
        List<MerchantOrder> merchantOrderList = this.merchantOrderService.getByOrderNo(orderNo);
        if (CollUtil.isEmpty(merchantOrderList)) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u5546\u6237\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728,orderNo: {}", (Object)orderNo);
            return;
        }
        if (merchantOrderList.size() == 1) {
            execute = this.oneMerchantOrderProcessing(order, merchantOrderList.get(0));
        } else {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u591a\u5546\u6237\u8ba2\u5355\uff0c\u8d2d\u7269\u8f66\u573a\u666f\uff0c\u672a\u9a8c\u8bc1\uff0corderNo: {}", (Object)orderNo);
            execute = this.manyMerchantOrderProcessing(order, merchantOrderList);
        }
        if (!execute.booleanValue()) {
            this.logger.error("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u62c6\u5355\u5904\u7406\u5931\u8d25\uff0corderNo: {}", (Object)orderNo);
            return;
        }
        this.logger.info("\u5f02\u6b65\u2014\u2014\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u62c6\u5355\u5904\u7406 | \u62c6\u5355\u6210\u529f\uff0c\u52a0\u5165\u540e\u7f6e\u5904\u7406\u961f\u5217");
        this.redisUtil.lPush("orderPaySuccessTask", (Object)order.getOrderNo());
    }

    @Override
    @Async
    public void visitUserCenter(Integer uid) {
        UserVisitRecord visitRecord = new UserVisitRecord();
        visitRecord.setDate(DateUtil.date().toString("yyyy-MM-dd"));
        visitRecord.setUid(uid);
        visitRecord.setVisitType(VisitRecordConstants.VISIT_TYPE_CENTER);
        this.userVisitRecordService.save(visitRecord);
    }

    @Override
    @Async
    public void installStatistics() {
        String isInstall = this.systemConfigService.getValueByKey("is_install");
        if (StrUtil.isNotBlank((CharSequence)isInstall) && isInstall.equals("1")) {
            return;
        }
        String version = this.crmebConfig.getVersion();
        if (StrUtil.isBlank((CharSequence)version) || !StrUtil.startWithIgnoreCase((CharSequence)version, (CharSequence)"CRMEB")) {
            return;
        }
        String apiUrl = this.systemConfigService.getValueByKey("api_url");
        if (StrUtil.isBlank((CharSequence)apiUrl) || !StrUtil.startWithIgnoreCase((CharSequence)apiUrl, (CharSequence)"http")) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("host", apiUrl);
        map.put("version", version);
        map.put("https", "https");
        String result = HttpUtil.post((String)"https://shop.bcxin.net/index.php/admin/server.upgrade_api/updatewebinfo", (String)JSONObject.toJSONString(map));
        JSONObject jsonObject = JSONObject.parseObject((String)result);
        if (jsonObject.getInteger("status").equals(200)) {
            this.systemConfigService.updateOrSaveValueByName("is_install", "1");
        }
    }

    @Override
    @Async
    public void sendRechargeSuccessNotification(RechargeOrder rechargeOrder, User user) {
        if (!rechargeOrder.getPayType().equals("weixin")) {
            return;
        }
        SystemNotification payNotification = this.systemNotificationService.getByMark("rechargeSuccess");
        HashMap<String, String> temMap = new HashMap<String, String>();
        if (rechargeOrder.getPayChannel().equals("public") && user.getIsWechatPublic().booleanValue() && payNotification.getIsWechat().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_WECHAT);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("first", "\u5145\u503c\u6210\u529f\u901a\u77e5\uff01");
            temMap.put("keyword1", user.getNickname());
            temMap.put("keyword2", rechargeOrder.getOrderNo());
            temMap.put("keyword3", rechargeOrder.getPrice().toString());
            temMap.put("remark", "\u6b22\u8fce\u4e0b\u6b21\u518d\u6765\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getWechatId(), temMap, userToken.getToken());
            return;
        }
        if (rechargeOrder.getPayChannel().equals("mini") && user.getIsWechatPublic().booleanValue() && payNotification.getIsRoutine().equals(1)) {
            UserToken userToken = this.userTokenService.getTokenByUserId(user.getId(), UserConstants.USER_TOKEN_TYPE_ROUTINE);
            if (ObjectUtil.isNull((Object)userToken)) {
                return;
            }
            temMap.put("character_string1", rechargeOrder.getOrderNo());
            temMap.put("amount3", rechargeOrder.getPrice().toString());
            temMap.put("date5", rechargeOrder.getPayTime().toString());
            temMap.put("amount6", rechargeOrder.getGivePrice().toString());
            temMap.put("thing7", "\u60a8\u7684\u5145\u503c\u5df2\u6210\u529f\uff01");
            this.templateMessageService.pushTemplateMessage(payNotification.getRoutineId(), temMap, userToken.getToken());
            return;
        }
    }

    @Override
    @Async
    public void noteUpExp(Integer userId, Integer noteId) {
        String levelSwitch = this.systemConfigService.getValueByKey("userLevelSwitch");
        if (!"1".equals(levelSwitch)) {
            return;
        }
        String noteExpStr = this.systemConfigService.getValueByKeyException("userLevelCommunityNotesExp");
        if (noteExpStr.equals("0")) {
            return;
        }
        String noteNum = this.systemConfigService.getValueByKeyException("userLevelCommunityNotesNum");
        if (noteNum.equals("0")) {
            return;
        }
        if (this.userExperienceRecordService.isExistNote(userId, noteId).booleanValue()) {
            return;
        }
        Integer noteCountToday = this.userExperienceRecordService.getCountByNoteToday(userId);
        if (noteCountToday >= Integer.parseInt(noteNum)) {
            return;
        }
        User user = (User)this.userService.getById(userId);
        int noteExp = Integer.parseInt(noteExpStr);
        UserExperienceRecord record = new UserExperienceRecord();
        record.setUid(userId);
        record.setLinkId(noteId.toString());
        record.setLinkType("note");
        record.setType(ExperienceRecordConstants.EXPERIENCE_RECORD_TYPE_ADD);
        record.setTitle("\u793e\u533a\u53d1\u5e03\u7b14\u8bb0\u5956\u52b1");
        record.setExperience(Integer.valueOf(noteExp));
        record.setBalance(Integer.valueOf(user.getExperience() + noteExp));
        record.setMark(StrUtil.format((CharSequence)"\u793e\u533a\u53d1\u5e03\u79cd\u8349\u5956\u52b1{}\u7ecf\u9a8c", (Object[])new Object[]{noteExp}));
        record.setCreateTime((Date)DateUtil.date());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.userService.updateExperience(userId, noteExp, "add");
            this.userExperienceRecordService.save(record);
            this.userLevelUp(userId, user.getLevel(), user.getExperience() + noteExp);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error("\u7528\u6237\u793e\u533a\u53d1\u5e03\u7b14\u8bb0\u6dfb\u52a0\u7ecf\u9a8c\u5931\u8d25\uff0cuserId={},noteId={}", (Object)userId, (Object)noteId);
        }
    }

    @Override
    @Async
    public void communityNoteLikeOrClean(Integer noteId, String operationType) {
        this.communityNotesService.operationLike(noteId, operationType);
    }

    @Override
    @Async
    public void communityReplyLikeOrClean(Integer replyId, String operationType) {
        this.communityReplyService.operationLike(replyId, operationType);
    }

    @Override
    @Async
    public void noteAddReplyAfter(Integer noteId, Integer parentId, Integer replyId) {
        this.communityNotesService.operationReplyNum(noteId, 1, "add");
        if (parentId > 0) {
            this.communityReplyService.operationReplyNum(parentId, 1, "add");
        }
    }

    @Override
    @Async
    public void communityReplyDeleteAfter(Integer noteId, Integer firstReplyId, Integer replyId, Integer countReply) {
        if (firstReplyId > 0) {
            this.communityNotesService.operationReplyNum(noteId, 1, "sub");
            this.communityReplyService.operationReplyNum(firstReplyId, 1, "sub");
        } else {
            this.communityNotesService.operationReplyNum(noteId, 1 + countReply, "sub");
        }
    }

    @Override
    @Async
    public void userLevelUp(Integer userId, Integer userLevelId, Integer exp) {
        String levelSwitch = this.systemConfigService.getValueByKey("userLevelSwitch");
        if (levelSwitch.equals("0")) {
            return;
        }
        SystemUserLevel userLevel = this.systemUserLevelService.getByLevelId(userLevelId);
        SystemUserLevel systemLevel = this.systemUserLevelService.getByExp(exp);
        if (userLevel.getGrade() >= systemLevel.getGrade()) {
            return;
        }
        if (systemLevel.getExperience() > exp) {
            systemLevel = this.systemUserLevelService.getPreviousGrade(systemLevel.getGrade());
        }
        UserLevel level = new UserLevel();
        level.setUid(userId);
        level.setLevelId(systemLevel.getId());
        level.setGrade(systemLevel.getGrade());
        this.userService.updateUserLevel(userId, level.getLevelId());
        this.userLevelService.deleteByUserId(userId);
        this.userLevelService.save(level);
    }

    @Override
    @Async
    public void sendNewPeopleGift(Integer userId) {
        String newPeopleSwitch = this.systemConfigService.getValueByKey("new_people_present_switch");
        if (StrUtil.isBlank((CharSequence)newPeopleSwitch) || newPeopleSwitch.equals("0")) {
            return;
        }
        String newPeopleSwitchCouponStr = this.systemConfigService.getValueByKey("new_people_present_coupon");
        if (StrUtil.isBlank((CharSequence)newPeopleSwitchCouponStr)) {
            return;
        }
        List couponIdList = CrmebUtil.stringToArray((String)newPeopleSwitchCouponStr);
        if (CollUtil.isEmpty((Collection)couponIdList)) {
            return;
        }
        List<Coupon> couponList = this.couponService.findByIds(couponIdList);
        DateTime nowDate = DateUtil.date();
        List canSendCouponList = couponList.stream().filter(coupon -> {
            if (coupon.getIsDel().booleanValue()) {
                return false;
            }
            if (!coupon.getStatus().booleanValue()) {
                return false;
            }
            if (!coupon.getReceiveType().equals(CouponConstants.COUPON_RECEIVE_TYPE_PLAT_SEND)) {
                return false;
            }
            if (coupon.getIsLimited().booleanValue() && coupon.getLastTotal() <= 0) {
                return false;
            }
            if (coupon.getIsTimeReceive().booleanValue()) {
                if (nowDate.compareTo(coupon.getReceiveStartTime()) < 0) {
                    return false;
                }
                if (nowDate.compareTo(coupon.getReceiveEndTime()) > 0) {
                    return false;
                }
            }
            return coupon.getIsFixedTime() == false || nowDate.compareTo(coupon.getUseEndTime()) <= 0;
        }).collect(Collectors.toList());
        if (CollUtil.isEmpty(canSendCouponList)) {
            return;
        }
        List couponUserList = canSendCouponList.stream().map(coupon -> {
            CouponUser couponUser = new CouponUser();
            couponUser.setCouponId(coupon.getId());
            couponUser.setUid(userId);
            couponUser.setMerId(coupon.getMerId());
            couponUser.setName(coupon.getName());
            couponUser.setPublisher(coupon.getPublisher());
            couponUser.setCategory(coupon.getCategory());
            couponUser.setReceiveType(coupon.getReceiveType());
            couponUser.setCouponType(coupon.getCouponType());
            couponUser.setMoney(coupon.getMoney());
            couponUser.setDiscount(coupon.getDiscount());
            couponUser.setMinPrice(coupon.getMinPrice());
            couponUser.setStartTime(coupon.getUseStartTime());
            couponUser.setEndTime(coupon.getUseEndTime());
            couponUser.setStatus(CouponConstants.STORE_COUPON_USER_STATUS_USABLE);
            return couponUser;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            Coupon coupon;
            Boolean deduction = Boolean.TRUE;
            Iterator iterator = canSendCouponList.iterator();
            while (iterator.hasNext() && (deduction = this.couponService.deduction((coupon = (Coupon)iterator.next()).getId(), 1, coupon.getIsLimited())).booleanValue()) {
            }
            if (!deduction.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            deduction = this.couponUserService.saveBatch(couponUserList, 100);
            if (!deduction.booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            this.logger.error("\u53d1\u9001\u65b0\u4eba\u793c,\u64cd\u4f5c\u6570\u636e\u5e93\u5931\u8d25\uff0c\u7528\u6237ID = {}, \u65b0\u4eba\u793c\u4f18\u60e0\u5238\u914d\u7f6e = {}", (Object)userId, (Object)newPeopleSwitchCouponStr);
        }
    }

    private Boolean oneMerchantOrderProcessing(Order order, MerchantOrder merchantOrder) {
        Boolean success;
        List<BcxPayOfflineFile> files;
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        this.presentIntegral(merchantOrder, orderDetailList, order);
        Order newOrder = new Order();
        BeanUtils.copyProperties((Object)order, (Object)newOrder);
        MerchantOrder newMerOrder = new MerchantOrder();
        BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerOrder);
        newOrder.setId(null);
        newOrder.setOrderNo(order.getOrderNo() + BizEnum.lastRule((Integer)1));
        newOrder.setMerId(merchantOrder.getMerId());
        newOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
        newOrder.setPlatOrderNo(order.getOrderNo());
        newOrder.setPaid(Boolean.valueOf(true));
        newOrder.setPayTime((Date)DateUtil.date());
        newMerOrder.setId(null);
        newOrder.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
        newOrder.setMerCouponPrice(merchantOrder.getMerCouponPrice());
        newMerOrder.setOrderNo(newOrder.getOrderNo());
        this.decideOrderStatusByBizType(newOrder);
        if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
        }
        List<OrderDetail> newOrderDetailList = orderDetailList.stream().map(e -> {
            OrderDetail orderDetail = new OrderDetail();
            BeanUtils.copyProperties((Object)e, (Object)orderDetail);
            orderDetail.setId(null);
            orderDetail.setOrderNo(newOrder.getOrderNo());
            return orderDetail;
        }).collect(Collectors.toList());
        BcxPlatformFee oldFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        BcxPlatformFee newFee = new BcxPlatformFee();
        BeanUtils.copyProperties((Object)oldFee, (Object)newFee);
        newFee.setId(null);
        newFee.setOrderNo(newOrder.getOrderNo());
        BcxPayOffline offline = this.bcxPayOfflineService.queryByOrderNo(order.getOrderNo());
        if (offline != null) {
            BcxPayOffline newOffline = new BcxPayOffline();
            BeanUtils.copyProperties((Object)offline, (Object)newOffline);
            newOffline.setId(null);
            newOffline.setOrderNo(newOrder.getOrderNo());
            this.bcxPayOfflineService.save(newOffline);
        }
        if (CollUtil.isNotEmpty(files = this.bcxPayOfflineFileService.queryByOrderNo(order.getOrderNo()))) {
            List newFiles = files.stream().map(e -> {
                BcxPayOfflineFile file = new BcxPayOfflineFile();
                BeanUtils.copyProperties((Object)e, (Object)file);
                file.setId(null);
                file.setOrderNo(newOrder.getOrderNo());
                return file;
            }).collect(Collectors.toList());
            this.bcxPayOfflineFileService.saveBatch(newFiles);
        }
        order.setIsDel(Boolean.valueOf(true));
        if (order.getBizType().equals(ProductConstants.BIZ_TYPE_SPACIAL)) {
            success = this.spacialProductSplitOrder(order, newOrder, merchantOrder, newMerOrder, newOrderDetailList);
            return success;
        }
        success = (Boolean)this.transactionTemplate.execute(e -> {
            Boolean delete = this.orderService.paySplitDelete(order.getOrderNo());
            if (!delete.booleanValue()) {
                this.logger.error("\u652f\u4ed8\u62c6\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.merchantOrderService.updateById(merchantOrder);
            if (order.getGainIntegral() > 0) {
                this.orderDetailService.updateBatchById(orderDetailList);
            }
            this.orderService.save(newOrder);
            this.merchantOrderService.save(newMerOrder);
            this.orderDetailService.saveBatch(newOrderDetailList);
            this.bcxPlatformFeeService.save(newFee);
            if (OrderConstants.ORDER_STATUS_COMPLETE.equals(newOrder.getStatus())) {
                this.bcxFapiaoSourceService.saveSourceFromOrder(newOrder.getOrderNo());
            }
            this.orderStatusService.createLog(order.getOrderNo(), "pay_split", StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u6309\u5546\u6237\u62c6\u5355\uff0c\u5386\u53f2\u5355\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{order.getOrderNo()}));
            return Boolean.TRUE;
        });
        return success;
    }

    private Boolean spacialProductSplitOrder(Order order, Order newOrder, MerchantOrder merchantOrder, MerchantOrder newMerOrder, List<OrderDetail> newOrderDetailList) {
        ArrayList splitOrders = CollUtil.newArrayList((Object[])new Order[0]);
        ArrayList splitMerOrders = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList splitOrderDetails = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        ArrayList platFees = CollUtil.newArrayList((Object[])new BcxPlatformFee[0]);
        BcxPlatformFee oldFee = this.bcxPlatformFeeService.queryByOrderNo(order.getOrderNo(), 0);
        for (OrderDetail detail : newOrderDetailList) {
            Integer orderCount = detail.getPayNum();
            int splitCount = orderCount;
            while (splitCount-- > 0) {
                Order splitOrder = new Order();
                BeanUtils.copyProperties((Object)newOrder, (Object)splitOrder);
                splitOrder.setId(null);
                splitOrder.setOrderNo(order.getOrderNo() + BizEnum.lastRule((Integer)splitCount));
                splitOrder.setMerId(newMerOrder.getMerId());
                splitOrder.setTotalNum(Integer.valueOf(1));
                splitOrder.setProTotalPrice(newMerOrder.getProTotalPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setTotalPostage(newMerOrder.getTotalPostage().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setTotalPrice(newMerOrder.getTotalPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setCouponPrice(newMerOrder.getCouponPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setUseIntegral(Integer.valueOf(newMerOrder.getUseIntegral() / orderCount));
                splitOrder.setIntegralPrice(newMerOrder.getIntegralPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setPayPrice(newMerOrder.getPayPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setPayPostage(newMerOrder.getPayPostage().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrder.setGainIntegral(Integer.valueOf(newMerOrder.getGainIntegral() / orderCount));
                splitOrder.setPlatFee(newOrder.getPlatFee().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.UP));
                splitOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
                splitOrder.setPlatOrderNo(order.getOrderNo());
                splitOrder.setIsDel(Boolean.valueOf(false));
                MerchantOrder splitMerOrder = new MerchantOrder();
                BeanUtils.copyProperties((Object)newMerOrder, (Object)splitMerOrder);
                BeanUtils.copyProperties((Object)splitOrder, (Object)splitMerOrder);
                splitMerOrder.setId(null);
                splitMerOrder.setOrderNo(splitOrder.getOrderNo());
                splitMerOrder.setGainIntegral(Integer.valueOf(splitMerOrder.getGainIntegral() / orderCount));
                OrderDetail splitOrderDetail = new OrderDetail();
                BeanUtils.copyProperties((Object)detail, (Object)splitOrderDetail);
                splitOrderDetail.setId(null);
                splitOrderDetail.setOrderNo(splitOrder.getOrderNo());
                splitOrderDetail.setPayNum(Integer.valueOf(1));
                splitOrderDetail.setPayPrice(splitOrderDetail.getPayPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrderDetail.setUseIntegral(Integer.valueOf(splitOrderDetail.getUseIntegral() / orderCount));
                splitOrderDetail.setUseIntegral(Integer.valueOf(splitOrderDetail.getUseIntegral() / orderCount));
                splitOrderDetail.setIntegralPrice(splitOrderDetail.getIntegralPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrderDetail.setCouponPrice(splitOrderDetail.getCouponPrice().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrderDetail.setFreightFee(splitOrderDetail.getFreightFee().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.DOWN));
                splitOrderDetail.setGainIntegral(Integer.valueOf(splitOrderDetail.getGainIntegral() / orderCount));
                splitOrderDetail.setPlatFee(Optional.ofNullable(splitOrderDetail.getPlatFee()).orElse(BigDecimal.ZERO).divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.UP));
                splitOrders.add(splitOrder);
                splitMerOrders.add(splitMerOrder);
                splitOrderDetails.add(splitOrderDetail);
                BcxPlatformFee newFee = new BcxPlatformFee();
                BeanUtils.copyProperties((Object)oldFee, (Object)newFee);
                newFee.setId(null);
                newFee.setPlatFee(oldFee.getPlatFee().divide(BigDecimal.valueOf(orderCount.intValue()), 2, RoundingMode.UP));
                newFee.setOrderNo(splitOrder.getOrderNo());
                platFees.add(newFee);
            }
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean delete = this.orderService.paySplitDelete(order.getOrderNo());
            if (!delete.booleanValue()) {
                this.logger.error("\u652f\u4ed8\u62c6\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.orderService.saveBatch(splitOrders);
            this.merchantOrderService.saveBatch(splitMerOrders);
            this.orderDetailService.saveBatch(splitOrderDetails);
            this.bcxPlatformFeeService.saveBatch(platFees);
            this.orderStatusService.createLog(order.getOrderNo(), "pay_split", StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u6309\u5546\u6237\u62c6\u5355\uff0c\u5386\u53f2\u5355\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{order.getOrderNo()}));
            return Boolean.TRUE;
        });
    }

    private Boolean manyMerchantOrderProcessing(Order order, List<MerchantOrder> merchantOrderList) {
        List<OrderDetail> orderDetailList = this.orderDetailService.getByOrderNo(order.getOrderNo());
        this.presentIntegral(merchantOrderList, orderDetailList, order);
        ArrayList newOrderList = CollUtil.newArrayList((Object[])new Order[0]);
        ArrayList newMerchantOrderList = CollUtil.newArrayList((Object[])new MerchantOrder[0]);
        ArrayList newOrderDetailList = CollUtil.newArrayList((Object[])new OrderDetail[0]);
        order.setIsDel(Boolean.valueOf(true));
        for (MerchantOrder merchantOrder : merchantOrderList) {
            Order newOrder = AsyncServiceImpl.copyNewOrder(order, merchantOrder);
            this.decideOrderStatusByBizType(newOrder);
            newOrder.setPlatOrderNo(order.getOrderNo());
            newOrder.setIsDel(Boolean.valueOf(false));
            if (merchantOrder.getShippingType().equals(OrderConstants.ORDER_SHIPPING_TYPE_PICK_UP)) {
                newOrder.setStatus(OrderConstants.ORDER_STATUS_AWAIT_VERIFICATION);
            }
            MerchantOrder newMerchantOrder = new MerchantOrder();
            BeanUtils.copyProperties((Object)merchantOrder, (Object)newMerchantOrder);
            newMerchantOrder.setId(null);
            AsyncServiceImpl.constructNewOrders(orderDetailList, newOrderList, newMerchantOrderList, newOrderDetailList, merchantOrder, newOrder, newMerchantOrder);
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean delete = this.orderService.paySplitDelete(order.getOrderNo());
            if (!delete.booleanValue()) {
                this.logger.error("\u652f\u4ed8\u62c6\u5355\u5931\u8d25\uff0c\u8ba2\u5355\u53f7:{}", (Object)order.getOrderNo());
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            this.merchantOrderService.updateBatchById(merchantOrderList);
            this.orderService.saveBatch(newOrderList);
            this.merchantOrderService.saveBatch(newMerchantOrderList);
            this.orderDetailService.saveBatch(newOrderDetailList);
            this.orderStatusService.createLog(order.getOrderNo(), "pay_split", StrUtil.format((CharSequence)"\u652f\u4ed8\u6210\u529f\u6309\u5546\u6237\u62c6\u5355\uff0c\u5386\u53f2\u5355\u53f7\u4e3a\uff1a{}", (Object[])new Object[]{order.getOrderNo()}));
            newOrderList.forEach(o -> {
                if (o.getStatus().equals(OrderConstants.ORDER_STATUS_COMPLETE)) {
                    this.orderStatusService.createLog(o.getOrderNo(), "complete", "\u8ba2\u5355\u5df2\u5b8c\u6210");
                }
            });
            return Boolean.TRUE;
        });
    }

    static void constructNewOrders(List<OrderDetail> orderDetailList, List<Order> newOrderList, List<MerchantOrder> newMerchantOrderList, List<OrderDetail> newOrderDetailList, MerchantOrder merchantOrder, Order newOrder, MerchantOrder newMerchantOrder) {
        newMerchantOrder.setOrderNo(newOrder.getOrderNo());
        List<OrderDetail> tempDetailList = orderDetailList.stream().filter(e -> e.getMerId().equals(merchantOrder.getMerId())).collect(Collectors.toList());
        tempDetailList.forEach(d -> {
            d.setId(null);
            d.setOrderNo(newOrder.getOrderNo());
        });
        newOrderList.add(newOrder);
        newMerchantOrderList.add(newMerchantOrder);
        newOrderDetailList.addAll(tempDetailList);
    }

    private Integer decideOrderStatusByBizType(Order newOrder) {
        Integer bizType = newOrder.getBizType();
        if (bizType.equals(ProductConstants.BIZ_TYPE_VIRTUAL)) {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_COMPLETE);
        } else if (bizType.equals(ProductConstants.BIZ_TYPE_SPACIAL)) {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_RECEIPT);
        } else {
            newOrder.setStatus(OrderConstants.ORDER_STATUS_WAIT_SHIPPING);
        }
        return bizType;
    }

    static Order copyNewOrder(Order order, MerchantOrder merchantOrder) {
        Order newOrder = new Order();
        BeanUtils.copyProperties((Object)order, (Object)newOrder);
        newOrder.setId(null);
        newOrder.setOrderNo(order.getOrderNo() + BizEnum.lastRule((Integer)1));
        newOrder.setMerId(merchantOrder.getMerId());
        newOrder.setTotalNum(merchantOrder.getTotalNum());
        newOrder.setProTotalPrice(merchantOrder.getProTotalPrice());
        newOrder.setTotalPostage(merchantOrder.getTotalPostage());
        newOrder.setTotalPrice(merchantOrder.getTotalPrice());
        newOrder.setCouponPrice(merchantOrder.getCouponPrice());
        newOrder.setMerCouponPrice(merchantOrder.getMerCouponPrice());
        newOrder.setPlatCouponPrice(merchantOrder.getPlatCouponPrice());
        newOrder.setUseIntegral(merchantOrder.getUseIntegral());
        newOrder.setIntegralPrice(merchantOrder.getIntegralPrice());
        newOrder.setPayPrice(merchantOrder.getPayPrice());
        newOrder.setPayPostage(merchantOrder.getPayPostage());
        newOrder.setGainIntegral(merchantOrder.getGainIntegral());
        newOrder.setLevel(OrderConstants.ORDER_LEVEL_MERCHANT);
        return newOrder;
    }

    private void presentIntegral(MerchantOrder merchantOrder, List<OrderDetail> orderDetailList, Order order) {
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0 && new BigDecimal(integralRatioStr).compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal integralBig = new BigDecimal(integralRatioStr);
            int giveIntegral = merchantOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
            merchantOrder.setGainIntegral(Integer.valueOf(giveIntegral));
            order.setGainIntegral(Integer.valueOf(giveIntegral));
            if (giveIntegral > 0) {
                for (int i = 0; i < orderDetailList.size(); ++i) {
                    OrderDetail orderDetail = orderDetailList.get(i);
                    if (orderDetailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                        break;
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merchantOrder.getPayPrice(), 10, 4);
                    int integral = new BigDecimal(Integer.toString(giveIntegral)).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(integral));
                    giveIntegral -= integral;
                }
            }
        }
    }

    private void presentIntegral(List<MerchantOrder> merchantOrderList, List<OrderDetail> orderDetailList, Order order) {
        int integral = 0;
        String integralRatioStr = this.systemConfigService.getValueByKey("order_give_integral");
        if (StrUtil.isNotBlank((CharSequence)integralRatioStr) && order.getPayPrice().compareTo(BigDecimal.ZERO) > 0) {
            block0: for (MerchantOrder merOrder : merchantOrderList) {
                BigDecimal integralBig = new BigDecimal(integralRatioStr);
                int giveIntegral = merOrder.getPayPrice().divide(integralBig, 0, 1).intValue();
                integral += giveIntegral;
                merOrder.setGainIntegral(Integer.valueOf(giveIntegral));
                if (giveIntegral <= 0) continue;
                List detailList = orderDetailList.stream().filter(e -> e.getMerId().equals(merOrder.getMerId())).collect(Collectors.toList());
                for (int i = 0; i < detailList.size(); ++i) {
                    OrderDetail orderDetail = (OrderDetail)detailList.get(i);
                    if (detailList.size() == i + 1) {
                        orderDetail.setGainIntegral(Integer.valueOf(giveIntegral));
                        continue block0;
                    }
                    BigDecimal ratio = orderDetail.getPayPrice().divide(merOrder.getPayPrice(), 10, 4);
                    int detailIntegral = new BigDecimal(Integer.toString(giveIntegral)).multiply(ratio).setScale(0, 1).intValue();
                    orderDetail.setGainIntegral(Integer.valueOf(detailIntegral));
                    giveIntegral -= detailIntegral;
                }
            }
            if (integral > 0) {
                order.setGainIntegral(Integer.valueOf(integral));
            }
        }
    }
}

