/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.wangshang.notify.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.util.StringUtil;
import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletTrade;
import com.zbkj.common.model.huifu.HuifuWalletTranslog;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.dao.HuifuWalletAccountDetailDao;
import com.zbkj.service.dao.HuifuWalletTradeDao;
import com.zbkj.service.dao.HuifuWalletTranslogDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.BkcloudfundsWithdrawNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.BkcloudfundsWithdrawNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bkcloudfundsWithdrawNotifyService")
public class BkcloudfundsWithdrawNotifyServiceImpl
implements MybankNotifyService {
    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsWithdrawNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;
    @Resource
    private HuifuWalletTradeDao huifuWalletTradeDao;
    @Resource
    private HuifuWalletAccountDetailDao huifuWalletAccountDetailDao;
    @Resource
    private HuifuWalletTranslogDao huifuWalletTranslogDao;
    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > \u63d0\u73b0\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1aant.mybank.bkcloudfunds.withdraw.notify");
        logger.info("========= > \u8bf7\u6c42\u62a5\u6587\uff1a" + context);
        BkcloudfundsWithdrawNotifyRequest withdrawNotifyRequest = XmlConverter.getInstance().toResponse(context, BkcloudfundsWithdrawNotifyRequest.class);
        RequestHead head = withdrawNotifyRequest.getBkcloudfundsWithdrawNotify().getRequestHead();
        boolean flag = false;
        try {
            flag = this.saveNotify(withdrawNotifyRequest.getBkcloudfundsWithdrawNotify().getBkcloudfundsWithdrawNotifyModel());
        }
        catch (Exception e) {
            logger.error("========= > \u63d0\u73b0\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1aant.mybank.bkcloudfunds.withdraw.notify:" + e.getMessage());
        }
        String response = this.commomRequstHandle.getSignResult(flag, head);
        this.transactionLogService.save("\u63d0\u73b0\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1aant.mybank.bkcloudfunds.withdraw.notify", "1", context, response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(BkcloudfundsWithdrawNotifyModel model) {
        HuifuWalletTrade tradeFee;
        System.out.println("====== > \u63d0\u73b0\u7ed3\u679c\u901a\u77e5\u63a5\u53e3\uff08\u5f02\u6b65\u63a5\u53e3\uff09\uff1a" + JSONObject.toJSONString((Object)model));
        HuifuWalletTrade trade = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOrderNo());
        if (!"P".equals(trade.getTradeStatus())) {
            return true;
        }
        if (trade != null) {
            this.saveAccountDetail(trade, model);
        }
        if ((tradeFee = this.huifuWalletTradeDao.getHuifuWalletTradeByHfSeqId(model.getOrderNo() + "FEE")) != null) {
            this.saveAccountDetail(tradeFee, model);
        }
        HuifuWalletTranslog translog = new HuifuWalletTranslog();
        translog.setUniId(trade.getUniId());
        translog.setCreateTime(new Date());
        translog.setTransId(trade.getHfSeqId());
        translog.setTransDate(model.getWithdrawFinishDate().substring(0, 8));
        translog.setTransAmt(trade.getAmount().toString());
        String transStat = model.getStatus().equals("SUCCESS") ? "\u6210\u529f" : (model.getStatus().equals("FAIL") ? "\u5931\u8d25" : "\u5904\u7406\u4e2d");
        translog.setTransStat(transStat);
        translog.setCardNo(model.getBankCardNo());
        translog.setCardName(model.getBankCertName());
        HuifuWalletAccountDto account = this.huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(trade.getExpendAccountNo());
        translog.setBankCode(account.getBankCode());
        translog.setFeeAmt(tradeFee.getAmount().toString());
        translog.setTransDesc(model.getErrorDesc());
        translog.setTransType("\u53d6\u73b0");
        translog.setPayChannel(PaymentChannel.WANGSHANG.toString());
        this.huifuWalletTranslogDao.insert(translog);
        return true;
    }

    private void saveAccountDetail(HuifuWalletTrade trade, BkcloudfundsWithdrawNotifyModel model) {
        if ("SUCCESS".equals(model.getStatus())) {
            trade.setUpdateTime(new Date());
            if (StringUtil.isNotEmpty((String)model.getWithdrawFinishDate())) {
                trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getWithdrawFinishDate(), (String)"yyyyMMddHHmmss")));
            }
            trade.setTradeStatus(Constants.tradeStatus((String)"S"));
        } else if ("FAIL".equals(model.getStatus())) {
            if (StringUtil.isNotEmpty((String)model.getWithdrawFinishDate())) {
                trade.setTransFinishTime(DateUtil.formatDateTime((Date)DateUtil.parse((String)model.getWithdrawFinishDate(), (String)"yyyyMMddHHmmss")));
            }
            trade.setErrorMsg(model.getErrorDesc());
            trade.setUpdateTime(new Date());
            trade.setTradeStatus(Constants.tradeStatus((String)"F"));
        }
        this.huifuWalletTradeDao.updateById(trade);
    }
}

