/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.seckill.SeckillActivityTime;
import com.zbkj.common.model.seckill.SeckillProduct;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SeckillProductSearchRequest;
import com.zbkj.common.response.SeckillProductPageResponse;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.SeckillProductDao;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.ProductDescriptionService;
import com.zbkj.service.service.SeckillActivityService;
import com.zbkj.service.service.SeckillActivityTimeService;
import com.zbkj.service.service.SeckillProductService;
import com.zbkj.service.service.SeckillTimeIntervalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SeckillProductServiceImpl
extends ServiceImpl<SeckillProductDao, SeckillProduct>
implements SeckillProductService {
    @Resource
    private SeckillProductDao dao;
    @Autowired
    private SeckillActivityService seckillActivityService;
    @Autowired
    private SeckillTimeIntervalService seckillTimeIntervalService;
    @Autowired
    private SeckillActivityTimeService seckillActivityTimeService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private ProductDescriptionService productDescriptionService;

    @Override
    public Integer getCountByActivityId(Integer activityId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId});
        lqw.eq(SeckillProduct::getActivityId, (Object)activityId);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        return this.dao.selectCount((Wrapper)lqw);
    }

    @Override
    public List<SeckillProduct> findByActivityId(Integer activityId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillProduct::getActivityId, (Object)activityId);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.orderByDesc(SeckillProduct::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<SeckillProductPageResponse> getSeckillProductPage(SeckillProductSearchRequest request, PageParamRequest pageRequest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isNotBlank((CharSequence)request.getProName())) {
            map.put("proName", URLUtil.decode((String)request.getProName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getProStatus())) {
            map.put("proStatus", request.getProStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getActivityStatus())) {
            String activityIdStr;
            List<SeckillActivityTime> activityTimeList;
            String hmStr;
            String dateStr;
            DateTime dateTime;
            if (request.getActivityStatus().equals(1)) {
                dateTime = DateUtil.date();
                dateStr = dateTime.toString("yyyyMMdd");
                hmStr = dateTime.toString("HHmm");
                activityTimeList = this.seckillActivityTimeService.findByActivityStatus(request.getActivityStatus(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
                if (CollUtil.isEmpty(activityTimeList)) {
                    return null;
                }
                activityIdStr = activityTimeList.stream().map(e -> String.valueOf(e.getSeckillId())).distinct().collect(Collectors.joining(","));
                map.put("activityIdStr", activityIdStr);
            }
            if (request.getActivityStatus().equals(2)) {
                dateTime = DateUtil.date();
                dateStr = dateTime.toString("yyyyMMdd");
                hmStr = dateTime.toString("HHmm");
                activityTimeList = this.seckillActivityTimeService.findByActivityStatus(request.getActivityStatus(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
                if (CollUtil.isEmpty(activityTimeList)) {
                    return null;
                }
                activityIdStr = activityTimeList.stream().map(e -> String.valueOf(e.getSeckillId())).distinct().collect(Collectors.joining(","));
                map.put("activityIdStr", activityIdStr);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)request.getActivityName())) {
            map.put("activityName", URLUtil.decode((String)request.getActivityName()));
        }
        if (ObjectUtil.isNotNull((Object)request.getMerStars()) && request.getMerStars() > 0) {
            map.put("merStars", request.getMerStars());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getMerIds())) {
            map.put("merIds", request.getMerIds());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            map.put("auditStatus", request.getAuditStatus());
        }
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        List<SeckillProductPageResponse> productList = this.dao.getSeckillProductPage(map);
        if (CollUtil.isNotEmpty(productList)) {
            this.setActivityStatus(productList);
            productList.forEach(p -> p.setAttrValue(this.productAttrValueService.getListByProductIdAndType(p.getId(), ProductConstants.PRODUCT_TYPE_SECKILL)));
        }
        return CommonPage.copyPageInfo((Page)page, productList);
    }

    @Override
    public Boolean forceDown(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.set(SeckillProduct::getAuditStatus, (Object)3);
        wrapper.set(SeckillProduct::getReason, (Object)"\u5e73\u53f0\u5f3a\u5236\u4e0b\u67b6");
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean delete(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsDel, (Object)1);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean up(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)1);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public Boolean down(String ids) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        wrapper.set(SeckillProduct::getIsShow, (Object)0);
        wrapper.in(SeckillProduct::getId, (Collection)CrmebUtil.stringToArray((String)ids));
        return this.update((Wrapper)wrapper);
    }

    @Override
    public List<SeckillProduct> getIndexList(List<Integer> aidList) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId, SeckillProduct::getName, SeckillProduct::getSeckillPrice, SeckillProduct::getImage});
        lqw.in(SeckillProduct::getActivityId, aidList);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.orderByDesc(SeckillProduct::getSort);
        lqw.last(" limit 5");
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<SeckillProduct> getFrontPage(List<Integer> seckillIdList, PageParamRequest pageRequest) {
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SeckillProduct::getId, SeckillProduct::getName, SeckillProduct::getPrice, SeckillProduct::getImage, SeckillProduct::getSeckillPrice, SeckillProduct::getQuota, SeckillProduct::getQuotaShow, SeckillProduct::getMerId});
        lqw.in(SeckillProduct::getActivityId, seckillIdList);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.last(" order by sort desc, (quota_show - quota) desc");
        List productList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)productList);
    }

    @Override
    public SeckillProduct getFrontDetail(Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SeckillProduct::getId, (Object)id);
        lqw.eq(SeckillProduct::getIsShow, (Object)1);
        lqw.eq(SeckillProduct::getIsDel, (Object)0);
        lqw.eq(SeckillProduct::getAuditStatus, (Object)2);
        lqw.last(" limit 1");
        SeckillProduct seckillProduct = (SeckillProduct)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)seckillProduct)) {
            throw new CrmebException(StrUtil.format((CharSequence)"\u6ca1\u6709\u627e\u5230ID\uff1a {} \u7684\u79d2\u6740\u5546\u54c1", (Object[])new Object[]{id}));
        }
        ProductDescription sd = this.productDescriptionService.getByProductIdAndType(seckillProduct.getId(), ProductConstants.PRODUCT_TYPE_SECKILL);
        if (ObjectUtil.isNotNull((Object)sd)) {
            seckillProduct.setContent(StrUtil.isBlank((CharSequence)sd.getDescription()) ? "" : sd.getDescription());
        }
        return seckillProduct;
    }

    @Override
    public Boolean operationStock(Integer id, Integer num, String type) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        if (type.equals("add")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota + {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = IF(sales<{}, 0, sales-{})", (Object[])new Object[]{num, num}));
        }
        if (type.equals("sub")) {
            updateWrapper.setSql(StrUtil.format((CharSequence)"quota = quota - {}", (Object[])new Object[]{num}));
            updateWrapper.setSql(StrUtil.format((CharSequence)"sales = sales + {}", (Object[])new Object[]{num}));
            updateWrapper.last(StrUtil.format((CharSequence)" and (quota - {} >= 0)", (Object[])new Object[]{num}));
        }
        updateWrapper.eq((Object)"id", (Object)id);
        boolean update = this.update((Wrapper)updateWrapper);
        if (!update) {
            throw new CrmebException("\u66f4\u65b0\u79d2\u6740\u5546\u54c1\u5e93\u5b58\u5931\u8d25,\u5546\u54c1id = " + id);
        }
        return update;
    }

    private void setActivityStatus(List<SeckillProductPageResponse> productList) {
        DateTime dateTime = DateUtil.date();
        String dateStr = dateTime.toString("yyyyMMdd");
        String hmStr = dateTime.toString("HHmm");
        for (SeckillProductPageResponse product : productList) {
            if (product.getActivityStatus().equals(2)) continue;
            Integer activityStatus = this.seckillActivityTimeService.getActivityStatus(product.getActivityId(), Integer.valueOf(dateStr), Integer.valueOf(hmStr));
            product.setActivityStatus(activityStatus);
        }
    }
}

