/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.entity.product_core.ProClauses;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.util.BASE64Util;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.weixin.product.service.ProClausesService1;
import com.bcxin.ins.weixin.product.service.impl.WeiXinProductServiceImpl;
import com.bcxin.ins.weixin.util.CTLUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.net.URLEncoder;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${weixin}/product"})
public class WeiXinProductController
extends BaseController {
    private static final String PRODUCT_LIST = WeiXinProductController.getViewPath((String)"weixin/product/product_list");
    private static final String PRODUCT_DETAIL = WeiXinProductController.getViewPath((String)"weixin/product/product_detail");
    private static final String PRODUCT_SEARCH = WeiXinProductController.getViewPath((String)"weixin/product/product_search");
    private static final String PRODUCT_SEARCH_RESULT = WeiXinProductController.getViewPath((String)"weixin/product/product_search_result");
    private static final String PAY_FINISH = WeiXinProductController.getViewPath((String)"weixin/order/zzx/zzx_pay_finish");
    @Autowired
    private WeiXinProductServiceImpl weiXinProductService;
    @Autowired
    private ProClausesService1 proClausesService;

    @RequestMapping(value={"/win/list"})
    public String winList(Model model, @RequestParam Map<Object, Object> params) throws Exception {
        model.addAttribute("p", params);
        model.addAttribute("notOpen", (Object)"1");
        if (params.get("recommendCode") != null) {
            String recommendCode = BASE64Util.decryptBASE64((String)((String)params.get("recommendCode")));
            this.getRequest().getSession().setAttribute("recommendCode", (Object)recommendCode);
        }
        return PRODUCT_LIST;
    }

    @RequestMapping(value={"/win/search"})
    public String winSearch(Model model, @RequestParam Map<Object, Object> params) {
        return PRODUCT_SEARCH;
    }

    @RequestMapping(value={"/pay/finish/{oid}"})
    public String payFinish(Model model, @RequestParam Map<Object, Object> params, @PathVariable String oid) {
        params.put("ins_insurance_slip_id", oid);
        this.logger.info("\u8c03\u7528\u652f\u4ed8\u5b8c\u6210\u9875\u9762>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        model.addAttribute("p", params);
        return PAY_FINISH;
    }

    @RequestMapping(value={"/win/search/result"})
    public String winSearchResult(Model model, @RequestParam Map<Object, Object> params) {
        model.addAttribute("keyword", params.get("keyword"));
        return PRODUCT_SEARCH_RESULT;
    }

    @OperationLog(source=OperationLog.SOURCETYPE.FRONT_PRODUCT, title="\u3010\u8bf7\u6c42\u3011\u5fae\u4fe1-\u4ea7\u54c1\u8be6\u60c5")
    @RequestMapping(value={"/win/detail/{oid}"})
    public String winDetail(Model model, @RequestParam Map<Object, Object> params, @PathVariable String oid) {
        params.put("pro_primary_id", oid);
        model.addAttribute("p", params);
        return PRODUCT_DETAIL;
    }

    @RequestMapping(value={"/win/prolist/{oid}"})
    public String winProlist(Model model, @RequestParam Map<Object, Object> params, @PathVariable String oid) {
        params.put("activity_id", oid);
        model.addAttribute("p", params);
        model.addAttribute("type", this.getRequest().getSession().getAttribute("type"));
        this.getRequest().getSession().removeAttribute("type");
        this.logger.info("\u83b7\u5f97\u7684type\u53c2\u6570\u662f\uff1a" + this.getRequest().getSession().getAttribute("type"));
        String result = HttpUtil.get((String)(String.valueOf(GlobalResources.map.get("YWZC_URL")) + "/weixin/no/getActivity?id=" + oid));
        Map localParam = (Map)JSON.parseObject((String)result, Map.class);
        this.logger.info("\u83b7\u5f97\u7684\u53c2\u6570" + JSON.toJSONString((Object)localParam));
        if (localParam.get("recommendCode") != null) {
            this.getRequest().getSession().setAttribute("recommendCode", localParam.get("recommendCode"));
        }
        localParam.put("activity_id", oid);
        this.getRequest().getSession().setAttribute("ywzc_activity_info", (Object)localParam);
        this.getRequest().getSession().setAttribute("ywzc_pro_primary_ids", localParam.get("product_codes"));
        this.logger.info(JSON.toJSONString((Object)this.getRequest().getSession().getAttributeNames()));
        return PRODUCT_LIST;
    }

    @RequestMapping(value={"/win/prolist/mid/{oid}"})
    public String winProListMid(Model model, @RequestParam Map<Object, Object> params, @PathVariable String oid) {
        params.put("activity_id", oid);
        this.getRequest().getSession().setAttribute("type", (Object)0);
        return this.redirectTo("/weixin/product/win/prolist/" + oid);
    }

    @RequestMapping(value={"/detail"})
    @ResponseBody
    public Object detail(Model model, @RequestParam Map<Object, Object> params) {
        CTLUtil.out(this.weiXinProductService.queryByProductID(params), this.getResponse());
        return null;
    }

    @RequestMapping(value={"/query"})
    @ResponseBody
    public Object proListData(Model model, @RequestParam Map<Object, Object> params) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        this.logger.info("session\u4e2d\u7684\u53c2\u6570\uff1a" + this.getRequest().getSession().getAttribute("ywzc_pro_primary_ids"));
        if (this.getRequest().getSession().getAttribute("ywzc_pro_primary_ids") != null) {
            p.put("ywzc_pro_primary_ids", this.getRequest().getSession().getAttribute("ywzc_pro_primary_ids"));
        }
        p.put("product_code", "ZZX");
        this.logger.info("\u5206\u9875\u67e5\u8be2\u7684\u53c2\u6570\u662f\uff1a" + JSON.toJSONString(p));
        return this.weiXinProductService.query(p);
    }

    @RequestMapping(value={"/clause/{pro_clauses_id}"})
    @ResponseBody
    public Object detail(Model model, @PathVariable(value="pro_clauses_id") String pro_clauses_id) throws Exception {
        ProClauses pc = (ProClauses)this.proClausesService.selectOne(new EntityWrapper().addFilter("pro_clauses_id = {0}", new Object[]{pro_clauses_id}));
        if (pc == null) {
            return null;
        }
        String filenameEncode = URLEncoder.encode(String.valueOf(pc.getFile_name()), "utf-8");
        this.getResponse().setContentType("application/pdf");
        this.getResponse().setCharacterEncoding("UTF-8");
        CTLUtil.outBlob(this.getResponse(), pc.getClauses_file());
        return null;
    }

    @RequestMapping(value={"/getProDetailByProCodes"})
    @ResponseBody
    public Object getProDetailByProCodes(Model model, @RequestParam Map<Object, Object> params) {
        Map<Object, Object> p = CTLUtil.initWX(this.getRequest(), params);
        this.logger.info("\u4ea7\u54c1\u7f16\u7801\u6570\u7ec4\uff1a" + JSON.toJSONString(p));
        return this.weiXinProductService.queryByProductCodes(p);
    }
}

