/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.order.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.core.entity.PageResult;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.util.DOM;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsRoleInpolicy;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsInsuranceSlipAPIService;
import com.bcxin.ins.service.order.InsRoleInpolicyAPIService;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.weixin.order.dao.WeiXinOrderMapper;
import com.bcxin.ins.weixin.order.service.SpecialExhibitionService1;
import com.bcxin.ins.weixin.order.service.WeiXinOrderService;
import com.bcxin.ins.weixin.product.service.InsMailPolicyService1;
import com.bcxin.ins.weixin.product.service.impl.WeiXinProductServiceImpl;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class WeiXinOrderServiceImpl
implements WeiXinOrderService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeiXinOrderMapper weiXinOrderMapper;
    @Autowired
    private InsRoleInpolicyAPIService insRoleInpolicyService;
    @Autowired
    private InsMailPolicyService1 insMailPolicyService;
    @Autowired
    private InsInsuranceSlipAPIService insInsuranceSlipService;
    @Autowired
    private SpecialExhibitionService1 specialExhibitionService1;
    @Autowired
    private WeiXinProductServiceImpl weiXinProductService;
    @Autowired
    private InsTransactionAPIService insTransactionAPIService;
    @Autowired
    private PolicyService policyService;

    @Override
    public PageResult query(Map<Object, Object> p) {
        return new PageResult(Integer.valueOf(this.weiXinOrderMapper.queryCnt(p)), this.weiXinOrderMapper.query(p));
    }

    @Override
    public Map<Object, Object> queryDZBDBySlipID(Map<Object, Object> p) {
        this.logger.info(JSON.toJSONString(p));
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        String ret = "300";
        String msg = "";
        if (p.get("ins_insurance_slip_id") == null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")))) {
            msg = "\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5";
        } else {
            String path = this.policyService.HTTP_PAC_ZZX_DZBD(Long.valueOf(Long.parseLong(String.valueOf(p.get("ins_insurance_slip_id")))));
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                m.put("path", path);
                ret = "200";
                msg = "\u83b7\u53d6\u6210\u529f";
            } else {
                msg = "\u7535\u5b50\u4fdd\u5355\u83b7\u53d6\u5931\u8d25";
            }
        }
        m.put("ret", ret);
        m.put("msg", msg);
        return m;
    }

    @Override
    public Map<Object, Object> queryDetailVoBySlipID(Map<Object, Object> p, HttpServletRequest req) {
        this.logger.info(JSON.toJSONString(p));
        if (p.get("ins_insurance_slip_id") == null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")))) {
            return null;
        }
        Map<Object, Object> m = this.weiXinOrderMapper.queryDetailVoBySlipID(p);
        if (m == null) {
            return null;
        }
        Map a = (Map)m.get("applicant");
        Map i = (Map)m.get("special");
        Map imp = (Map)m.get("ins_mail_policy");
        if (a != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(a.get("reg_district")))) {
            m.put("area", RegionUtils.getRegionNameByALLCode((String)String.valueOf(a.get("reg_province")), (String)String.valueOf(a.get("reg_city")), (String)String.valueOf(a.get("reg_district"))));
        }
        if (i != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(i.get("ex_county")))) {
            m.put("ex_area", RegionUtils.getRegionNameByALLCode((String)String.valueOf(i.get("ex_province")), (String)String.valueOf(i.get("ex_city")), (String)String.valueOf(i.get("ex_county"))));
        }
        if (imp != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(imp.get("bank_city")))) {
            imp.put("bank_area", RegionUtils.getRegionNameByALLCode((String)String.valueOf(imp.get("bank_province")), (String)String.valueOf(imp.get("bank_city")), null));
        }
        m.put("transactionList", this.insTransactionAPIService.selectList(new EntityWrapper().addFilter(" insurance_slip_id = {0} ", new Object[]{p.get("ins_insurance_slip_id")})));
        return m;
    }

    @Override
    public R applicant(Map<Object, Object> p, HttpServletRequest req) {
        try {
            InsInsuranceSlip iis = null;
            Map<Object, Object> pp = this.weiXinProductService.queryByProductID(p);
            String pCode = String.valueOf(pp.get("product_code"));
            if (p.get("ins_insurance_slip_id") == null || "".equals(String.valueOf(p.get("ins_insurance_slip_id")).trim())) {
                IdWorker idWorker = new IdWorker(31L, 0L);
                InsMailPolicy insMailPolicy = new InsMailPolicy();
                insMailPolicy.setIns_mail_policy_id(Long.valueOf(idWorker.nextId()));
                SpecialExhibition specialExhibition = new SpecialExhibition();
                specialExhibition.setSpecial_exhibition_id(Long.valueOf(idWorker.nextId()));
                iis = new InsInsuranceSlip();
                iis.setIns_insurance_slip_id(Long.valueOf(idWorker.nextId()));
                iis.setMailPolicy(insMailPolicy);
                iis.setSpecial_id(specialExhibition.getSpecial_exhibition_id());
                iis.setStart_time(new Date());
                iis.setSigned_date(new Date());
                iis.setTrade_serial_number(String.valueOf(idWorker.nextId()));
                iis.setOrder_status("1");
                ProPrimary prom = (ProPrimary)DOM.mtd(p, (Object)new ProPrimary());
                iis.setPro_primary(prom);
                if (req.getSession().getAttribute("recommendCode") != null) {
                    iis.setRecommend_code(String.valueOf(req.getSession().getAttribute("recommendCode")));
                }
                iis.setRegister_user_id(Long.valueOf(String.valueOf(p.get("system_params_user_id"))));
                iis.setPremium(new BigDecimal(String.valueOf(pp.get("fixed_premium"))));
                if (!StringUtils.isEmpty((CharSequence)pCode) && pCode.indexOf("ZZX-PAC") > -1) {
                    iis.setInsured_amount(this.policyService.setInsuredAmountByProductId(prom.getPro_primary_id()));
                }
                InsRoleInpolicy insRoleInpolicy1 = new InsRoleInpolicy();
                insRoleInpolicy1.setInsurance_slip(iis);
                insRoleInpolicy1.setKind("1");
                InsRoleInpolicy insRoleInpolicy2 = new InsRoleInpolicy();
                insRoleInpolicy2.setInsurance_slip(iis);
                insRoleInpolicy2.setKind("2");
                this.insInsuranceSlipService.insert((Object)iis);
                this.insRoleInpolicyService.insert((Object)insRoleInpolicy1);
                this.insRoleInpolicyService.insert((Object)insRoleInpolicy2);
                this.insMailPolicyService.insert(insMailPolicy);
                this.specialExhibitionService1.insert(specialExhibition);
            } else {
                iis = (InsInsuranceSlip)DOM.mtd(p, (Object)new InsInsuranceSlip());
            }
            InsRoleInpolicy iri = (InsRoleInpolicy)DOM.mtd(p, (Object)new InsRoleInpolicy());
            iri.setInsurance_slip(iis);
            iri.setKind("1");
            List l = this.insRoleInpolicyService.selectList(new EntityWrapper().addFilter(" kind=1 and insurance_slip_id={0}", new Object[]{iis.getIns_insurance_slip_id()}));
            if (l.size() == 0) {
                throw new Exception("\u6570\u636e\u5f02\u5e38\uff0c\u8ba2\u5355\u672a\u6b63\u786e\u521d\u59cb\u5316");
            }
            if (l.size() != 1) {
                throw new Exception("\u5b58\u5728\u591a\u4e2a\u6295\u4fdd\u4eba");
            }
            iri.setIns_role_inpolicy_id(((InsRoleInpolicy)l.get(0)).getIns_role_inpolicy_id());
            if (!this.insRoleInpolicyService.updateById((Object)iri)) {
                throw new Exception("\u4fdd\u5b58\u5931\u8d25");
            }
            if ("2".equals(iri.getId_type()) || "6".equals(iri.getId_type())) {
                req.getSession().setAttribute("zj_code", (Object)iri.getOrganization_code());
            }
            return new R(Boolean.valueOf(true), String.valueOf(iis.getIns_insurance_slip_id()));
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    @Override
    public R saveInsurant(Map<Object, Object> p, HttpServletRequest req) {
        try {
            if (this.weiXinOrderMapper.queryDetailVoBySlipID(p) == null) {
                throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            InsInsuranceSlip iis = (InsInsuranceSlip)DOM.mtd(p, (Object)new InsInsuranceSlip());
            InsRoleInpolicy iri = (InsRoleInpolicy)DOM.mtd(p, (Object)new InsRoleInpolicy());
            iri.setInsurance_slip(iis);
            iri.setKind("2");
            List l = this.insRoleInpolicyService.selectList(new EntityWrapper().addFilter(" kind=2 and insurance_slip_id={0}", new Object[]{iis.getIns_insurance_slip_id()}));
            if (l.size() == 0) {
                throw new Exception("\u6570\u636e\u5f02\u5e38\uff0c\u8ba2\u5355\u672a\u6b63\u786e\u521d\u59cb\u5316");
            }
            if (l.size() != 1) {
                throw new Exception("\u5b58\u5728\u591a\u4e2a\u88ab\u4fdd\u9669\u4eba");
            }
            iri.setIns_role_inpolicy_id(((InsRoleInpolicy)l.get(0)).getIns_role_inpolicy_id());
            if (!this.insRoleInpolicyService.updateById((Object)iri)) {
                throw new Exception("\u4fdd\u5b58\u5931\u8d25");
            }
            return new R(Boolean.valueOf(true), String.valueOf(iis.getIns_insurance_slip_id()));
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    @Override
    public R saveSpecial(Map<Object, Object> p, HttpServletRequest req) {
        try {
            if (this.weiXinOrderMapper.queryDetailVoBySlipID(p) == null) {
                throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            SpecialExhibition se = (SpecialExhibition)DOM.mtd(p, (Object)new SpecialExhibition());
            if ("0".equals(se.getContains())) {
                se.setBuild_com_name(" ");
                se.setSubcontracting_units(" ");
            }
            se.setExhibitor_name(StringUtils.isEmpty((CharSequence)se.getExhibitor_name()) ? " " : se.getExhibitor_name());
            se.setExhibitor_type(StringUtils.isEmpty((CharSequence)se.getExhibitor_type()) ? " " : se.getExhibitor_type());
            se.setExhibitor_code(StringUtils.isEmpty((CharSequence)se.getExhibitor_code()) ? " " : se.getExhibitor_code());
            if (!this.specialExhibitionService1.updateById(se)) {
                throw new Exception("\u4fdd\u5b58\u5931\u8d25");
            }
            InsInsuranceSlip iis = (InsInsuranceSlip)DOM.mtd(p, (Object)new InsInsuranceSlip());
            iis.setMailPolicy(null);
            iis.setInception_date(se.getStar_time());
            iis.setPlanned_end_date(se.getEnd_time());
            String result = this.policyService.zzx_amount_count(String.valueOf(p.get("product_code")), se.getEx_acreage());
            if ("200".equals(result.split("#")[0])) {
                iis.setPremium(new BigDecimal(result.split("#")[1]));
            }
            if (!this.insInsuranceSlipService.updateById((Object)iis)) {
                throw new Exception("\u4fdd\u5b58\u5931\u8d25");
            }
            return new R(Boolean.valueOf(true), String.valueOf(iis.getIns_insurance_slip_id()));
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    @Override
    public R insMailPolicy(Map<Object, Object> p, HttpServletRequest req) {
        try {
            if (this.weiXinOrderMapper.queryDetailVoBySlipID(p) == null) {
                throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            InsMailPolicy imp = (InsMailPolicy)DOM.mtd(p, (Object)new InsMailPolicy());
            if (!this.insMailPolicyService.updateById(imp)) {
                throw new Exception("\u4fdd\u5b58\u5931\u8d25");
            }
            InsInsuranceSlip iis = (InsInsuranceSlip)DOM.mtd(p, (Object)new InsInsuranceSlip());
            return new R(Boolean.valueOf(true), String.valueOf(iis.getIns_insurance_slip_id()));
        }
        catch (Exception e) {
            this.logger.error("\u56e2\u610f\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c" + e.getMessage());
        }
    }

    @Override
    public R pendingLOTEPolicyVoPolicy(LOTEPolicyVo vo, String recommendCode) {
        try {
            Map map;
            ClientUserVo userdetail = UserSupportUtil.getSessionUser();
            if (userdetail == null) {
                return new R(Boolean.valueOf(false), "\u8d26\u6237\u5df2\u8fc7\u671f\uff0c\u8bf7\u767b\u5f55\u540e\u64cd\u4f5c");
            }
            if (StringUtils.isEmpty((CharSequence)vo.getOid())) {
                String orderID = "";
                if (StringUtils.isNotEmpty((CharSequence)vo.getProduct_id())) {
                    orderID = this.policyService.createOrderAndGetOrderIDByProductID(Long.valueOf(Long.parseLong(vo.getProduct_id())), Long.valueOf(Long.parseLong(userdetail.getOid())), recommendCode, "");
                }
                if (StringUtils.isNotEmpty((CharSequence)orderID)) {
                    vo.setOid(orderID);
                } else {
                    return new R(Boolean.valueOf(false), "\u8ba2\u5355\u521d\u59cb\u5316\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01");
                }
            }
            if ((map = this.policyService.obtainLOTEPolicyVoSetUp(vo)) != null) {
                return new R(Boolean.valueOf(true), String.valueOf(map.get("order_id")));
            }
            return new R(Boolean.valueOf(false), "\u6570\u636e\u4e22\u5931\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u5c55\u8d23\u9669\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new R(Boolean.valueOf(false), "\u8ba2\u5355\u66f4\u65b0\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\uff01");
        }
    }

    @Override
    public LOTEPolicyVo accordingToOrderIDToGetLOTEPolicyVo(Long order_id) {
        return this.policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
    }
}

