/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.order.service.impl;

import com.bcxin.ins.entity.common.ComRegion;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.weixin.order.dao.ComRegionWeChatDao;
import com.bcxin.ins.weixin.order.service.ComRegionAPIService1;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComRegionAPIServiceImpl1
extends ServiceImpl<ComRegionWeChatDao, ComRegion>
implements ComRegionAPIService1 {
    @Autowired
    private ComRegionWeChatDao dao;

    @Override
    public Map<String, String> findDistrict(String codeLevel, String parentCode) {
        LinkedHashMap<String, String> map = null;
        List<ComRegion> list = this.dao.findRegionList("", "", "", codeLevel, parentCode);
        if (list != null && list.size() > 0) {
            map = new LinkedHashMap<String, String>();
            for (ComRegion Region : list) {
                map.put(Region.getCodes(), Region.getNamed());
            }
        }
        return map;
    }

    @Override
    public List<ComRegion> findRegionList(String name) {
        List<ComRegion> list = null;
        if (StrUtil.isNotBlank((CharSequence)name)) {
            list = this.dao.findRegionList(name, "", "", "", "");
        }
        return list;
    }

    @Override
    public List<ComRegion> findRegionListByLevel(String level, String name) {
        return this.dao.findRegionList(name, "", "", level, "");
    }

    @Override
    public List<ComRegion> findDistrictByParentCode(String codeLevel, String parentCode) {
        return this.dao.findRegionList("", "", "", codeLevel, parentCode);
    }

    @Override
    public String getRegionName(String pro, String cit, String are) {
        String result = "";
        ComRegion region = null;
        if (StringUtils.isNotEmpty((CharSequence)pro) && (region = this.findDistrictByCode("", pro)) != null) {
            result = result + region.getNamed();
        }
        if (StringUtils.isNotEmpty((CharSequence)cit) && (region = this.findDistrictByCode("", cit)) != null) {
            result = result + region.getNamed();
        }
        if (StringUtils.isNotEmpty((CharSequence)are) && (region = this.findDistrictByCode("", are)) != null) {
            result = result + region.getNamed();
        }
        return result;
    }

    @Override
    public ComRegion findDistrictByCode(String kind, String code) {
        List<ComRegion> list = null;
        if (StrUtil.isNotBlank((CharSequence)code)) {
            try {
                list = this.dao.findRegionList("", code, kind, "", "");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public void initSystemDDL(String fileUrl) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileUrl), "UTF-8"));){
            String line;
            int i = 0;
            while ((line = br.readLine()) != null) {
                int j = 0;
                ComRegion ddl = new ComRegion();
                String[] data = new String[8];
                System.out.println("\u7b2c" + i + "\u884c\t\uff1a");
                StringTokenizer sk = new StringTokenizer(line, ",", false);
                while (sk.hasMoreTokens()) {
                    String value;
                    data[j] = value = (String)sk.nextElement();
                    ++j;
                }
                ++i;
                ComRegion cs = this.findDistrictByCode("", data[0]);
                if (cs != null) {
                    return;
                }
                ddl.setCodes(data[0]);
                ddl.setCode_level(data[1]);
                ddl.setKind(data[2]);
                ddl.setParent_id(data[3]);
                ddl.setNamed(data[4]);
                this.dao.updateById(ddl);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

