/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.weixin.login.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.entity.user.SysClientUser;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.util.MathUtil;
import com.bcxin.ins.util.Sha1Util;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.weixin.login.service.WeiXinLoginService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WeiXinLoginServiceImpl
implements WeiXinLoginService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ClientUserService userService;

    @Override
    public JSONObject login(Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        String userName = String.valueOf(params.get("j_username"));
        String password = String.valueOf(params.get("j_password"));
        String status = "300";
        String redirectUrl = "";
        String role = "";
        String msg = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff01";
        SysClientUser clientUser = this.userService.getClientUser(userName, MathUtil.getType((String)userName));
        if (clientUser == null) {
            status = "302";
            msg = "\u8d26\u53f7\u4e0d\u5b58\u5728\uff01";
            return this.returnJsonMsg(status, redirectUrl, role, msg);
        }
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)password) && !Sha1Util.validatePassword((String)password, (String)clientUser.getPassword())) {
            status = "303";
            msg = "\u5bc6\u7801\u9519\u8bef\uff01";
            return this.returnJsonMsg(status, redirectUrl, role, msg);
        }
        if ("0".equals(clientUser.getStatus() + "")) {
            status = "301";
            msg = "\u8d26\u53f7\u88ab\u51bb\u7ed3\uff01";
        } else {
            status = "200";
            msg = "\u767b\u5f55\u6210\u529f\uff01";
            try {
                String callbackUri;
                ClientUserVo userVo = this.userService.getClientUserVo(userName, MathUtil.getType((String)userName));
                req.getSession().setAttribute("wxUserVo", (Object)userVo);
                this.userService.setLastTime(userVo);
                String string = callbackUri = req.getSession().getAttribute("callback_uri") == null ? null : req.getSession().getAttribute("callback_uri").toString();
                if (StringUtils.isNotBlank(callbackUri) && !"/weixin/login".equals(callbackUri)) {
                    status = "201";
                    msg = "\u767b\u5f55\u6210\u529f\uff01";
                    redirectUrl = callbackUri;
                }
            }
            catch (Exception ex) {
                status = "304";
                msg = "\u767b\u5f55\u62a5\u9519\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                this.logger.error("\u767b\u5f55\u62a5\u9519" + ex);
            }
        }
        return this.returnJsonMsg(status, redirectUrl, role, msg);
    }

    @Override
    public JSONObject checkUserExist(String email, HttpServletRequest request) {
        boolean flag = this.userService.checkUserExist(email, false);
        if (flag) {
            JedisUtils.set((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)email, (int)300);
            JedisUtils.set((String)("resetType:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)MathUtil.getType((String)email), (int)300);
            return this.existSuccess();
        }
        return this.existFail();
    }

    @Override
    public JSONObject sendEmailCode(String email, HttpServletRequest request) {
        if (StringUtils.isNotEmpty((String)email)) {
            String code = MathUtil.getRandomCode();
            EmailModel em = new EmailModel(code, EmailMsgType.TYYZM);
            em.addTo(email);
            try {
                SendEmailAndMsgUtil.sendEmail((EmailModel)em);
                request.getSession().setAttribute("checkCodekeyword", (Object)code);
                request.getSession().setAttribute("email", (Object)email);
                return this.returnSuccess();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.returnFail();
    }

    @Override
    public JSONObject sendTelPhoneCode(String email, HttpServletRequest request) {
        String code;
        if (StringUtils.isNotEmpty((String)email) && (code = this.userService.sendUserCode(email, EmailMsgType.AUTHCODE)) != null) {
            request.getSession().setAttribute("checkCodekeyword", (Object)code);
            request.getSession().setAttribute("email", (Object)email);
            return this.returnSuccess();
        }
        return this.returnFail();
    }

    @Override
    public JSONObject ckeckEmail(String email, HttpServletRequest request) {
        boolean flag = this.userService.getUserEmailForRegister(email, "BLB");
        if (!flag) {
            JedisUtils.set((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)email, (int)300);
            JedisUtils.set((String)("resetType:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)"2", (int)300);
            return this.existSuccess();
        }
        return this.existFail();
    }

    @Override
    public JSONObject checkMobile(String tel, HttpServletRequest request) {
        boolean flag = this.userService.getUserMobileForRegister(tel, "BLB");
        if (!flag) {
            JedisUtils.set((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)tel, (int)300);
            JedisUtils.set((String)("resetType:" + IpAddress.getIpAddress((HttpServletRequest)request)), (String)"1", (int)300);
            return this.existSuccess();
        }
        return this.existFail();
    }

    @Override
    public JSONObject sendCode(String email, HttpServletRequest request) {
        if ("1".equals(MathUtil.getType((String)email))) {
            return this.sendTelPhoneCode(email, request);
        }
        if ("2".equals(MathUtil.getType((String)email))) {
            return this.sendEmailCode(email, request);
        }
        return this.returnFail();
    }

    @Override
    public JSONObject checkCodeExist(String code, HttpServletRequest request) {
        String sessionyanz = (String)request.getSession(true).getAttribute("checkCodekeyword");
        if (code.equals(sessionyanz)) {
            request.getSession(true).removeAttribute("checkCodekeyword");
            return this.returnSuccess();
        }
        return this.returnFail();
    }

    @Override
    public JSONObject register(Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        String emailAgain;
        String email = params.get("email") == null ? null : params.get("email").toString();
        String code = params.get("code") == null ? null : params.get("code").toString();
        boolean flag = false;
        String string = emailAgain = req.getSession().getAttribute("email") == null ? null : req.getSession().getAttribute("email").toString();
        if (!email.equals(emailAgain)) {
            return this.returnFail();
        }
        if ("1".equals(code)) {
            flag = this.userService.getUserMobileForRegister(email, "BLB");
        } else if ("2".equals(code)) {
            flag = this.userService.getUserEmailForRegister(email, "BLB");
        }
        if (flag) {
            ClientUserVo vo = null;
            vo = this.userService.getClientUserVo(email, MathUtil.getType((String)email));
            if (vo == null) {
                vo = new ClientUserVo();
            }
            String password = req.getParameter("password");
            vo.setPassword(Sha1Util.entryptPassword((String)password));
            vo.setTerminal_type(code);
            if ("1".equals(code)) {
                vo.setRole_id("3");
                vo.setRole_name("COMMON-ZERO-HEAD");
                vo.setTelephone(email);
            } else if ("2".equals(code)) {
                vo.setRole_id("1");
                vo.setRole_name("COMMON-ONE-HEAD");
                vo.setEmail(email);
            }
            boolean userflag = this.userService.saveClientUserVo(vo);
            if (userflag) {
                return this.returnSuccess();
            }
        }
        return this.returnFail();
    }

    @Override
    public JSONObject resetPassword(HttpServletRequest request, Map<Object, Object> params) {
        String password;
        String email = JedisUtils.get((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)request)));
        String string = password = params.get("pwd") == null ? null : params.get("pwd").toString();
        if (email == null || password == null) {
            return this.returnFail();
        }
        ClientUserVo weixinVo = this.userService.getClientUserVo(email, MathUtil.getType((String)email));
        if (weixinVo == null) {
            return this.returnFail();
        }
        if (this.userService.updClientUserVoPwd(weixinVo, password)) {
            JedisUtils.del((String)("resetPwdEmail:" + IpAddress.getIpAddress((HttpServletRequest)request)));
            JedisUtils.del((String)("resetType:" + IpAddress.getIpAddress((HttpServletRequest)request)));
            return this.returnSuccess();
        }
        return this.returnFail();
    }

    private JSONObject returnJsonMsg(String status, String redirectUrl, String role, String msg) {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)status);
        obj.put("role", (Object)role);
        obj.put("redirectUrl", (Object)redirectUrl);
        obj.put("msg", (Object)msg);
        this.logger.debug("retrun,\u8fd4\u56de\u7ed9\u9875\u9762\u7684\u503c\uff1a" + JSON.toJSONString((Object)obj));
        return obj;
    }

    private JSONObject returnSuccess() {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"200");
        obj.put("msg", (Object)"\u64cd\u4f5c\u6210\u529f");
        return obj;
    }

    private JSONObject existSuccess() {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"200");
        obj.put("msg", (Object)"\u5b58\u5728\u8be5\u6570\u636e");
        return obj;
    }

    private JSONObject returnFail() {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"300");
        obj.put("msg", (Object)"\u64cd\u4f5c\u5931\u8d25");
        return obj;
    }

    private JSONObject existFail() {
        JSONObject obj = new JSONObject();
        obj.put("status", (Object)"300");
        obj.put("msg", (Object)"\u8be5\u6570\u636e\u4e0d\u5b58\u5728");
        return obj;
    }
}

