/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.utils;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtil {
    private static Logger logger = LoggerFactory.getLogger(FreemarkerUtil.class);
    private static FreemarkerUtil fk;
    private static Configuration cfg;

    private FreemarkerUtil() {
    }

    public static FreemarkerUtil getInstance() throws Exception {
        String fileDir = Thread.currentThread().getContextClassLoader().getResource("").getPath().replace("classes", "views") + "/template";
        logger.info("----------\u670d\u52a1\u5668\u6a21\u677f\u5730\u5740\uff1a" + fileDir);
        return FreemarkerUtil.getInstance(Configuration.VERSION_2_3_28.toString(), fileDir);
    }

    public static FreemarkerUtil getInstance(String freemarkerVersionNo) throws Exception {
        return FreemarkerUtil.getInstance(freemarkerVersionNo, null);
    }

    public static FreemarkerUtil getInstance(String freemarkerVersionNo, String templatePath) throws Exception {
        if (null == fk) {
            cfg = new Configuration(new Version(freemarkerVersionNo));
            cfg.setDirectoryForTemplateLoading(new File(templatePath));
            cfg.setEncoding(Locale.getDefault(), "UTF-8");
            fk = new FreemarkerUtil();
        }
        return fk;
    }

    private freemarker.template.Template getTemplate(String templateName) {
        try {
            freemarker.template.Template template = cfg.getTemplate(templateName, "UTF-8");
            return template;
        }
        catch (TemplateNotFoundException e) {
            e.printStackTrace();
        }
        catch (MalformedTemplateNameException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String generator(String template, Map<String, Object> map) {
        String fileDir = Thread.currentThread().getContextClassLoader().getResource("").toString().replace("classes", "views") + "/template";
        Properties prop = new Properties();
        VelocityEngine ve = new VelocityEngine();
        prop.setProperty("file.resource.loader.path", fileDir);
        Velocity.init((Properties)prop);
        VelocityContext context = new VelocityContext(map);
        StringWriter sw = new StringWriter();
        Template tpl = ve.getTemplate(template, "UTF-8");
        tpl.merge((Context)context, (Writer)sw);
        return sw.toString();
    }

    public static void main(String[] args) {
        String a = "F:\\D_pan\\Program Files (x86)\\JetBrains\\workspase\\blbtest\\trunk\\bcxin-ins-web\\target\\bcxin-ins-web\\WEB-INF\\views\\template";
        System.out.println(a);
    }

    public void printOut(Map<String, Object> dataModel, String templateName) {
        try {
            this.getTemplate(templateName).process(dataModel, (Writer)new PrintWriter(System.out));
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public String transferMapToString(String name, Map<String, Object> data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String transferXml(String templateName, String xml) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void transferMapToFile(Map<String, Object> dataModel, String templateName, String filePath) {
        try (BufferedWriter bufWrite = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "UTF-8"));){
            this.getTemplate(templateName).process(dataModel, (Writer)bufWrite);
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String format(String result) {
        if (null != result && !"".equals(result) && result.indexOf(60) != -1 && result.lastIndexOf(62) != -1 && result.lastIndexOf(62) > result.indexOf(60)) {
            int i = result.indexOf(60);
            int ii = result.lastIndexOf(62) + 1;
            result = result.substring(result.indexOf(60), result.lastIndexOf(62) + 1);
        }
        return result;
    }
}

