/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.supply.owner;

import com.bcxin.ins.supply.SupplyType;
import com.bcxin.ins.supply.owner.SupplyStrategy;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class SupplyStragegyFactory {
    private static final String SCAN_STRAGEGY_PACKAGE = "com.bcxin.ins.supply.owner.impl";
    private List<Class<? extends SupplyStrategy>> supplyStrategyList;
    private ClassLoader classLoader = this.getClass().getClassLoader();

    private SupplyStragegyFactory() {
        this.init();
    }

    public static SupplyStragegyFactory getInstance() {
        return SupplyFactoryInstance.instance;
    }

    private void init() {
        this.supplyStrategyList = new ArrayList<Class<? extends SupplyStrategy>>();
        List<File> resources = this.getResources();
        Class<?> supplyStrategyClazz = null;
        try {
            supplyStrategyClazz = this.classLoader.loadClass(SupplyStrategy.class.getName());
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("\u672a\u627e\u5230\u7b56\u7565\u63a5\u53e3");
        }
        for (int i = 0; i < resources.size(); ++i) {
            try {
                Class<?> clazz = this.classLoader.loadClass("com.bcxin.ins.supply.owner.impl." + resources.get(i).getName().replace(".class", ""));
                if (!SupplyStrategy.class.isAssignableFrom(clazz) || clazz == supplyStrategyClazz) continue;
                this.supplyStrategyList.add(clazz);
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private List<File> getResources() {
        try {
            File file = new File(this.classLoader.getResource(SCAN_STRAGEGY_PACKAGE.replace(".", "/")).toURI());
            File[] fileList = file.listFiles();
            ArrayList<File> resultList = new ArrayList<File>();
            for (int i = 0; i < fileList.length; ++i) {
                File[] subFile;
                File f = fileList[i];
                if (f.isFile()) {
                    resultList.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                for (File subF : subFile = f.listFiles()) {
                    resultList.add(subF);
                }
            }
            return resultList;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u7b56\u7565\u8d44\u6e90");
        }
    }

    public SupplyStrategy createSupplyStrategy(String supplyType) {
        for (Class<? extends SupplyStrategy> clazz : this.supplyStrategyList) {
            SupplyType supplyTypeAnno = this.handleAnnotation(clazz);
            if (!supplyType.equalsIgnoreCase(supplyTypeAnno.type().getKey())) continue;
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u7b56\u7565\u83b7\u5f97\u5931\u8d25");
            }
        }
        throw new RuntimeException("\u7b56\u7565\u83b7\u5f97\u5931\u8d25");
    }

    private SupplyType handleAnnotation(Class<? extends SupplyStrategy> clazz) {
        Annotation[] annotations = clazz.getDeclaredAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof SupplyType)) continue;
            return (SupplyType)annotations[i];
        }
        return null;
    }

    private static class SupplyFactoryInstance {
        private static SupplyStragegyFactory instance = new SupplyStragegyFactory();

        private SupplyFactoryInstance() {
        }
    }
}

