/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.MySysUser;
import com.bcxin.ins.core.entity.QueryUser;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.entity.SysUserRole;
import com.bcxin.ins.core.service.MySysUserService;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.core.service.SysUserLoginLogService;
import com.bcxin.ins.core.service.SysUserRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.service.SystemService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.util.UploadFileUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.util.toolbox.WebUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"${systemPath}/sysuser"})
public class SysUserController
extends BaseController {
    private static final String SYSTEM_USER_LIST = SysUserController.getViewPath((String)"admin/system/system_user_list");
    private static final String SYSTEM_USER_MESSAGE = SysUserController.getViewPath((String)"admin/system/system_user_message");
    private static final String USER_LOGIN_LOG = SysUserController.getViewPath((String)"admin/system/system_user_login_log");
    private static final String SYSTEM_USER_ROLE = SysUserController.getViewPath((String)"admin/system/system_user_role");
    private static final String SYSTEM_USER_ADDUSER = SysUserController.getViewPath((String)"admin/system/system_user_add");
    private static final String SYSTEM_USER_INFO = SysUserController.getViewPath((String)"admin/system/system_user_info");
    private static final String SYSTEM_USER_AVATAR = SysUserController.getViewPath((String)"admin/system/system_user_avatar");
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private MySysUserService mySysUserService;
    @Autowired
    private SysUserLoginLogService sysUserLoginLogService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SystemService systemService;

    @RequiresPermissions(value={"sysuser:list:view"})
    @RequestMapping(value={"/list"})
    public String list(Model model, @ModelAttribute(value="queryUser") QueryUser queryUser, HttpServletRequest request, Map<String, Object> params) {
        return SYSTEM_USER_LIST;
    }

    @RequiresPermissions(value={"sysuser:list:view"})
    @RequestMapping(value={"/list/{userId}/detail"})
    public String detail(Model model, @PathVariable Long userId) {
        SysUser user = (SysUser)this.sysUserService.selectById((Serializable)userId);
        model.addAttribute("user", (Object)user);
        List sysUserRoles = this.sysUserRoleService.selectRoleListByAccountId(userId);
        StringBuffer userRole = new StringBuffer();
        for (SysUserRole sysUserRole : sysUserRoles) {
            userRole.append(sysUserRole.getRoleName());
            userRole.append("&nbsp");
        }
        model.addAttribute("userRole", (Object)userRole);
        return SYSTEM_USER_MESSAGE;
    }

    @RequiresPermissions(value={"sysuser:list:view"})
    @RequestMapping(value={"/list/{accountId}/log"})
    public String userLog(Model model, @PathVariable Long accountId) {
        List sysUserLoginLogList = this.sysUserLoginLogService.selectUserLoginLog(accountId);
        model.addAttribute("userLoginLogList", (Object)sysUserLoginLogList);
        return USER_LOGIN_LOG;
    }

    @RequestMapping(value={"/list/user/add"})
    @ResponseBody
    public AjaxResult userAdd(MySysUser sysUser, HttpServletRequest req, HttpServletResponse resp) {
        if (!this.mySysUserService.insert((Object)sysUser)) {
            return new AjaxResult(false, "\u4fdd\u5b58\u5931\u8d25");
        }
        return new AjaxResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @RequiresPermissions(value={"sysuser:list:edit"})
    @RequestMapping(value={"/list/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult audit() {
        Long accountId = Long.parseLong(this.getParameter("accountId"));
        Integer status = Integer.valueOf(this.getParameter("status"));
        this.sysUserService.updateUserStatus(accountId, status);
        return this.success(true);
    }

    @RequiresPermissions(value={"sysuser:list:delete"})
    @RequestMapping(value={"/list/{accountId}/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public AjaxResult delete(@PathVariable Long accountId) {
        this.sysUserService.deleteSysUser(accountId);
        return this.success(true);
    }

    @RequiresPermissions(value={"sysuser:list:view"})
    @RequestMapping(value={"/list/{roleId}/role"}, method={RequestMethod.GET})
    public String listrole(Model model, @PathVariable Long roleId) {
        List sysUsers = this.sysUserService.selectSysUserByRoleId(roleId);
        model.addAttribute("sysUsers", (Object)sysUsers);
        return SYSTEM_USER_ROLE;
    }

    @RequiresPermissions(value={"sysuser:list:edit"})
    @RequestMapping(value={"/list/{accountId}/edit"})
    public String edit(Model model, @PathVariable Long accountId) {
        Map m = this.sysUserService.selectByUserID(accountId);
        model.addAttribute("sysUser", (Object)m);
        List sysRoles = this.sysRoleService.selectRoleList();
        model.addAttribute("sysRoles", (Object)sysRoles);
        List sysRoleList = this.sysUserRoleService.selectRoleListByAccountId(accountId);
        model.addAttribute("sysRoleList", (Object)sysRoleList);
        model.addAttribute("showPower", (Object)"showPower");
        model.addAttribute("mark", (Object)"edit");
        return SYSTEM_USER_ADDUSER;
    }

    @RequiresPermissions(value={"sysuser:list:add"})
    @RequestMapping(value={"/list/add"})
    public String add(Model model) {
        String companyId = this.getParameter("companyId");
        List sysRoles = this.sysRoleService.selectRoleList();
        model.addAttribute("sysRoles", (Object)sysRoles);
        if (StrUtil.isNotBlank((CharSequence)companyId)) {
            model.addAttribute("sysUser", (Object)new SysUser(new SysCompany(Long.valueOf(Long.parseLong(companyId)))));
        } else {
            model.addAttribute("sysUser", (Object)new SysUser(new SysCompany(Long.valueOf(0L))));
        }
        model.addAttribute("showPower", (Object)"showPower");
        model.addAttribute("mark", (Object)"add");
        return SYSTEM_USER_ADDUSER;
    }

    @RequiresPermissions(value={"sysuser:list:add", "sysuser:list:edit"})
    @RequestMapping(value={"/list/save"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult update(@ModelAttribute(value="sysUser") SysUser sysUser) {
        String[] roleIds = this.getParameterValues("roleId");
        if (!WebUtil.isEmail((String)sysUser.getEmail())) {
            return this.fail(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7535\u5b50\u90ae\u7bb1");
        }
        if (!WebUtil.isTelephone((String)sysUser.getTelephone())) {
            return this.fail(false, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801");
        }
        if (sysUser.getId() == null) {
            return this.insertUserByIdIsNull(sysUser, roleIds);
        }
        return this.updateUserByIdIsNotNull(sysUser, roleIds);
    }

    private AjaxResult updateUserByIdIsNotNull(@ModelAttribute(value="sysUser") SysUser sysUser, String[] roleIds) {
        String newEmail = sysUser.getEmail();
        if (StringUtils.isNotBlank((CharSequence)newEmail) && this.checkEmailIsSet(sysUser, newEmail)) {
            return this.fail(false, "\u8be5\u90ae\u7bb1\u5df2\u88ab\u4f7f\u7528");
        }
        this.sysUserService.updateUserInfoBySystem(sysUser, roleIds);
        return this.success(true, "\u7528\u6237\u4fe1\u606f\u4fee\u6539\u6210\u529f!");
    }

    private boolean checkEmailIsSet(SysUser sysUser, String newEmail) {
        HashMap map = Maps.newHashMap();
        map.put("id", sysUser.getId());
        List li = this.sysUserService.selectByMap((Map)map);
        if (li == null || li.size() != 1) {
            return false;
        }
        String oldEmail = ((SysUser)li.get(0)).getEmail();
        if (oldEmail == null || oldEmail.equals(newEmail)) {
            return false;
        }
        HashMap map2 = Maps.newHashMap();
        map2.put("email", newEmail);
        List li2 = this.sysUserService.selectByMap((Map)map2);
        return li2 != null && li2.size() > 0;
    }

    private AjaxResult insertUserByIdIsNull(@ModelAttribute(value="sysUser") SysUser sysUser, String[] roleIds) {
        if (this.sysUserService.checkLoginName(sysUser.getLoginName())) {
            return this.fail(false, "\u8be5\u7528\u6237\u540d\u5df2\u88ab\u4f7f\u7528");
        }
        if (StringUtils.isNotBlank((CharSequence)sysUser.getEmail())) {
            HashMap map = Maps.newHashMap();
            map.put("email", sysUser.getEmail());
            List li = this.sysUserService.selectByMap((Map)map);
            if (li != null && li.size() > 0) {
                return this.fail(false, "\u8be5\u90ae\u7bb1\u5df2\u88ab\u4f7f\u7528");
            }
        }
        this.sysUserService.insertSysUser(sysUser, roleIds);
        return this.success(true, "\u7528\u6237\u521b\u5efa\u6210\u529f!");
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String view(Model model) {
        SysUser sysUser = SysUserUtils.getUser();
        if (sysUser != null) {
            model.addAttribute("sysUser", (Object)sysUser);
            List sysUserLoginLogList = this.sysUserLoginLogService.selectUserLoginLog(sysUser.getId());
            model.addAttribute("sysUserLoginLogList", (Object)sysUserLoginLogList);
            List sysUserRoles = this.sysUserRoleService.selectRoleListByAccountId(sysUser.getId());
            StringBuffer userRole = new StringBuffer();
            for (SysUserRole sysUserRole : sysUserRoles) {
                userRole.append(sysUserRole.getRoleName());
                userRole.append("&nbsp");
            }
            model.addAttribute("userRole", (Object)userRole);
        }
        return SYSTEM_USER_INFO;
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"/info/edit"})
    @ResponseBody
    public AjaxResult edit(@ModelAttribute(value="sysUser") SysUser sysUser) {
        if (sysUser != null) {
            this.sysUserService.updateUserInfo(sysUser);
            return this.success(true, "\u4fee\u6539\u6210\u529f");
        }
        return this.fail(false, "\u7cfb\u7edf\u9519\u8bef");
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"/info/edit/psw"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult editPwd(HttpServletRequest request) {
        SysUser sysUser = SysUserUtils.getUser();
        if (sysUser != null) {
            String confirmPwd;
            String nowPassword = request.getParameter("nowPassword") == null ? "" : request.getParameter("nowPassword");
            String newPassword = request.getParameter("newPassword") == null ? "" : request.getParameter("newPassword");
            String string = confirmPwd = request.getParameter("confirmPwd") == null ? "" : request.getParameter("confirmPwd");
            if (!this.systemService.validatePassword(nowPassword, sysUser.getLoginPassword())) {
                return this.fail(false, "\u539f\u5bc6\u7801\u4e0d\u6b63\u786e!");
            }
            if (!WebUtil.isPassword((String)newPassword)) {
                return this.fail(false, "\u5bc6\u7801\u957f\u5ea68~16\u4f4d\uff0c\u5176\u4e2d\u6570\u5b57\uff0c\u5b57\u6bcd\u548c\u7b26\u53f7\u81f3\u5c11\u5305\u542b\u4e24\u79cd!");
            }
            if (!newPassword.equals(confirmPwd)) {
                return this.fail(false, "\u4e24\u6b21\u8f93\u5165\u7684\u65b0\u5bc6\u7801\u4e0d\u4e00\u81f4!");
            }
            this.sysUserService.updateUserPws(sysUser.getId(), newPassword);
            return this.success(true, "\u4fee\u6539\u6210\u529f!");
        }
        return this.fail(false, "\u60a8\u672a\u767b\u5f55\u6216\u8005\u767b\u5f55\u5df2\u8d85\u65f6,\u8bf7\u5148\u767b\u5f55!");
    }

    @RequiresPermissions(value={"sysuser:list:repwd"})
    @RequestMapping(value={"/list/{accountId}/repwd"})
    @ResponseBody
    public AjaxResult rePwd(@PathVariable Long accountId) {
        if (accountId != null) {
            this.sysUserService.updateUserPws(accountId, GlobalConstants.getConfig((String)"defaultPassWord"));
            return this.success(true, "\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!");
        }
        return this.fail(false, "\u4fee\u6539\u5931\u8d25");
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.GET})
    public String setAvatar() {
        return SYSTEM_USER_AVATAR;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public Map<String, Object> uploadHeadPortrait(MultipartFile avatar_file, String avatar_src, String avatar_data, HttpServletRequest request) {
        HashMap<String, Object> json = new HashMap();
        if (avatar_file.isEmpty()) {
            json = this.setJson(false, "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301\u56fe\u7247!", null);
            return json;
        }
        try {
            String type = avatar_file.getContentType();
            if (type == null || !type.toLowerCase().startsWith("image/")) {
                json = this.setJson(false, "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301\u56fe\u7247!", null);
                return json;
            }
            String dir = "icon";
            Map returnMap = UploadFileUtils.Upload((HttpServletRequest)request, (MultipartFile)avatar_file, (String)avatar_data, (String)dir);
            if (Boolean.parseBoolean(returnMap.get("flag").toString())) {
                SysUser sysUser = SysUserUtils.getUser();
                if (sysUser == null) {
                    return this.setJson(false, "\u4e0a\u4f20\u5931\u8d25!\u4f60\u6ca1\u6709\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                }
                sysUser.setPicImg(returnMap.get("savaPath").toString());
                this.sysUserService.insertOrUpdate((Object)sysUser);
                json = this.setJson(true, "\u4e0a\u4f20\u6210\u529f!", returnMap.get("savaPath").toString());
                return json;
            }
        }
        catch (Exception e) {
            this.logger.error("ImageUploadController.uploadHeadPortrait", (Throwable)e);
            json = this.setJson(false, "\u4e0a\u4f20\u5931\u8d25\uff0c\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), null);
            return json;
        }
        json = this.setJson(false, "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff0c\u4ec5\u652f\u6301\u56fe\u7247!", null);
        return json;
    }
}

