/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.R;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.SysMenuService;
import com.bcxin.ins.core.service.SysUserRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.spring.security.Principal;
import com.bcxin.ins.spring.security.shiro.session.SessionDAO;
import com.bcxin.ins.util.CookieUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.google.common.collect.Lists;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}"})
public class SysMainController
extends BaseController {
    private static final String MAIN = SysMainController.getViewPath((String)"admin/main/main");
    private static final String MAIN_INDEX = SysMainController.getViewPath((String)"admin/main/index");
    private static final String ADMIN_LOGIN = SysMainController.getViewPath((String)"admin/login/admin_login");
    @Autowired
    private SessionDAO sessionDAOSt;
    @Autowired
    private SysMenuService sysMenuService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private PreseverApplyService preseverApplyService;

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"/index"})
    public String main(HttpServletRequest request, HttpServletResponse response, Model model) {
        Principal principal = SysUserUtils.getPrincipal();
        this.sysUserService.isValidateCodeLogin(principal.getLoginName(), false, true);
        if ("true".equals(GlobalConstants.getConfig((String)"notAllowRefreshIndex"))) {
            String logined = CookieUtils.getCookie((HttpServletRequest)request, (String)"LOGINED");
            if (StrUtil.isBlank((String)logined) || "false".equals(logined)) {
                CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"true");
            } else if (StrUtil.equals((String)logined, (String)"true")) {
                SysUserUtils.getSubject().logout();
                return "redirect:" + MAIN;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("show index, active session size: {}", (Object)this.sessionDAOSt.getActiveSessions(false).size());
        }
        List sysMenus = Lists.newArrayList();
        if (principal.getLoginName().equals(GlobalConstants.getAdminName())) {
            sysMenus = this.sysMenuService.selectSysMenu();
        } else {
            List roleIdList = this.sysUserRoleService.selectRoleIdByAccountId(principal.getId());
            if (roleIdList != null && roleIdList.size() > 0) {
                sysMenus = this.sysMenuService.selectSysMenuByRole(roleIdList);
            }
        }
        SysUser user = SysUserUtils.getUser();
        model.addAttribute("sysMenus", (Object)sysMenus);
        model.addAttribute("sysUser", (Object)user);
        return MAIN;
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"/main/index"}, method={RequestMethod.GET})
    public String mainIndex(HttpServletRequest request) {
        return MAIN_INDEX;
    }

    @RequestMapping(value={"/findCheckPendingPreservationRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public R findCheckPendingPreservationRecord() {
        return this.preseverApplyService.findCheckPendingPreservationRecord();
    }
}

