/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.common.constants.GlobalConstants;
import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.SysCompany;
import com.bcxin.ins.core.entity.SysCompanyContacts;
import com.bcxin.ins.core.entity.SysCompanyTerminalContacts;
import com.bcxin.ins.core.entity.SysUser;
import com.bcxin.ins.core.service.SysCompanyChannelContactsService;
import com.bcxin.ins.core.service.SysCompanyContactsService;
import com.bcxin.ins.core.service.SysCompanyService;
import com.bcxin.ins.core.service.SysCompanyTerminalContactsService;
import com.bcxin.ins.core.service.SysRoleService;
import com.bcxin.ins.core.service.SysUserRoleService;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.core.util.SysUserUtils;
import com.bcxin.ins.spring.util.UploadFileUtils;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@Transactional
@RequestMapping(value={"${systemPath}/syscompany"})
public class SysCompanyController
extends BaseController {
    @Autowired
    private SysCompanyService sysCompanyService;
    @Autowired
    private SysCompanyContactsService sysCompanyContactsService;
    @Autowired
    private SysCompanyTerminalContactsService sysCompanyTerminalContactsService;
    @Autowired
    private SysCompanyChannelContactsService sysCompanyChannelContactsService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysUserRoleService sysUserRoleService;
    private static final String SYSTEM_COMPANY_SUPPLIER_LIST = SysCompanyController.getViewPath((String)"admin/system/system_company_supplier_list");
    private static final String SYSTEM_COMPANY_SUPPLIER_ADD = SysCompanyController.getViewPath((String)"admin/system/system_company_supplier_add");
    private static final String SYSTEM_COMPANY_CHANNEL_ADD = SysCompanyController.getViewPath((String)"admin/system/system_company_channel_add");
    private static final String SYSTEM_COMPANY_SUPPLIER_VIEW = SysCompanyController.getViewPath((String)"admin/system/system_company_supplier_view");
    private static final String SYSTEM_COMPANY_TERMINAL_LIST = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_list");
    private static final String SYSTEM_COMPANY_CHANNEL_LIST = SysCompanyController.getViewPath((String)"admin/system/system_company_channel_list");
    private static final String SYSTEM_COMPANY_CHANNEL_VIEW = SysCompanyController.getViewPath((String)"admin/system/system_company_channel_view");
    private static final String SYSTEM_COMPANY_TERMINAL_BUSINESS_ADD = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_business_add");
    private static final String SYSTEM_COMPANY_TERMINAL_PERSONAL_ADD = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_personal_add");
    private static final String SYSTEM_COMPANY_TERMINAL_BUSINESS_VIEW = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_business_view");
    private static final String SYSTEM_COMPANY_TERMINAL_PERSONAL_VIEW = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_personal_view");
    private static final String SYSTEM_COMPANY_TERMINAL_TO_DISTRIBUTOR = SysCompanyController.getViewPath((String)"admin/system/system_company_terminal_to_distributor");
    private static final String SYSTEM_COMPANY_DISTRIBUTOR_LIST = SysCompanyController.getViewPath((String)"admin/system/system_company_distributor_list");
    private static final String SYSTEM_COMPANY_DISTRIBUTOR_ADD = SysCompanyController.getViewPath((String)"admin/system/system_company_distributor_add");
    private static final String SYSTEM_COMPANY_DISTRIBUTOR_VIEW = SysCompanyController.getViewPath((String)"admin/system/system_company_distributor_view");
    private static final String SYSTEM_USER_ADDUSER = SysCompanyController.getViewPath((String)"admin/system/system_user_add");
    private static final String SYSTEM_USER_LISTUSER = SysCompanyController.getViewPath((String)"admin/system/system_companyuser_list");

    @RequiresPermissions(value={"syscompany:list:view:supplier", "syscompany:list:view:terminal", "syscompany:list:view:distributor", "syscompany:list:view:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list"})
    public String list(Model model) {
        String type = this.getParameter("type");
        if (StrUtil.isNotBlank((CharSequence)type)) {
            List companyList = Lists.newArrayList();
            if (type.equals("1")) {
                companyList = this.sysCompanyService.getCompanyList(new SysCompany(Integer.valueOf(Integer.parseInt(type))));
            }
            model.addAttribute("companyList", (Object)companyList);
            return this.getUrl(Integer.parseInt(type), "list");
        }
        this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
        return "common/500";
    }

    @RequiresPermissions(value={"syscompany:list:view:distributor"})
    @RequestMapping(value={"/distributorList"})
    public String distributorList(Model model) {
        String type = this.getParameter("type");
        if (StrUtil.isNotBlank((CharSequence)type)) {
            List companyList = this.sysCompanyService.findDistributorList(type, null);
            model.addAttribute("companyList", (Object)companyList);
            return this.getUrl(Integer.parseInt(type), "list");
        }
        this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
        return "common/500";
    }

    @ResponseBody
    @RequiresPermissions(value={"syscompany:list:view:distributor"})
    @RequestMapping(value={"/getDistributorListByLevel"})
    public List<SysCompany> getDistributorListByLevel(Model model) {
        String level = this.getParameter("level");
        if (StrUtil.isNotBlank((CharSequence)level)) {
            List lis = this.sysCompanyService.getDistributorListByLevel(level);
            if (lis != null) {
                return lis;
            }
            return null;
        }
        return null;
    }

    @ResponseBody
    @RequiresPermissions(value={"syscompany:list:view:distributor"})
    @RequestMapping(value={"/getDistributorListByLevelExcludeSelf"})
    public List<SysCompany> getDistributorListByLevelExcludeSelf(Model model) {
        String level = this.getParameter("level");
        String userId = this.getParameter("userId");
        if (StrUtil.isNotBlank((CharSequence)level) && StringUtils.isNotBlank((CharSequence)userId)) {
            List lis = this.sysCompanyService.getDistributorListByLevelExcludeSelf(level, userId);
            if (lis != null) {
                return lis;
            }
            return null;
        }
        return null;
    }

    @RequiresPermissions(value={"syscompany:list:view:distributor"})
    @RequestMapping(value={"/viewDistributorByChoise"})
    public String viewDistributorByChoise(Model model) {
        String choiseId = this.getParameter("choiseId");
        String modify = this.getParameter("modify");
        if (StrUtil.isBlank((String)choiseId)) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        SysCompany company = null;
        List companyList = this.sysCompanyService.getDistributorByChoise(choiseId);
        if (companyList == null) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        company = (SysCompany)companyList.get(0);
        List childList = this.sysCompanyService.findDistributorList("2", choiseId);
        if (childList != null) {
            company.setChildSysCompanyList(childList);
        }
        model.addAttribute("company", (Object)company);
        if (StringUtils.isNotBlank((CharSequence)modify) && "modify".equals(modify)) {
            model.addAttribute("modify", (Object)modify);
        }
        return SYSTEM_COMPANY_DISTRIBUTOR_VIEW;
    }

    @RequiresPermissions(value={"syscompany:list:view:terminal"})
    @RequestMapping(value={"/viewTerminalByChoise"})
    public String viewTerminalByChoise(Model model) {
        String terminalType;
        String choiseId = this.getParameter("choiseId");
        String modify = this.getParameter("modify");
        if (StrUtil.isBlank((String)choiseId)) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        SysCompany company = null;
        List companyList = this.sysCompanyService.getTerminalByChoise(choiseId);
        if (companyList == null) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        company = (SysCompany)companyList.get(0);
        model.addAttribute("company", (Object)company);
        if (StringUtils.isNotBlank((CharSequence)modify) && "modify".equals(modify)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("relate_to_terminal", choiseId);
            List lis = this.sysCompanyService.selectByMap(map);
            if (lis.size() <= 0) {
                model.addAttribute("modify", (Object)modify);
            }
        }
        if (StringUtils.isBlank((CharSequence)(terminalType = String.valueOf(company.getTerminalType())))) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        if (terminalType.equals("1")) {
            return SYSTEM_COMPANY_TERMINAL_BUSINESS_VIEW;
        }
        if (terminalType.equals("2")) {
            return SYSTEM_COMPANY_TERMINAL_PERSONAL_VIEW;
        }
        this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
        return "common/500";
    }

    @RequiresPermissions(value={"syscompany:list:view:resource"})
    @RequestMapping(value={"/viewChannelByChoise"})
    public String viewChannelByChoise(Model model) {
        String choiseId = this.getParameter("choiseId");
        String modify = this.getParameter("modify");
        if (StrUtil.isBlank((String)choiseId)) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        SysCompany company = null;
        List companyList = this.sysCompanyService.getChannelByChoise(choiseId);
        if (companyList == null) {
            this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
            return "common/500";
        }
        company = (SysCompany)companyList.get(0);
        model.addAttribute("company", (Object)company);
        if (StringUtils.isNotBlank((CharSequence)modify) && "modify".equals(modify)) {
            model.addAttribute("modify", (Object)modify);
        }
        return SYSTEM_COMPANY_CHANNEL_VIEW;
    }

    @RequiresPermissions(value={"syscompany:list:view:terminal"})
    @RequestMapping(value={"/terminalList"})
    public String terminalList(Model model) {
        String type = this.getParameter("type");
        if (StrUtil.isNotBlank((CharSequence)type)) {
            List companyList = this.sysCompanyService.findDistributorList(type, null);
            model.addAttribute("companyList", (Object)companyList);
            return this.getUrl(Integer.parseInt(type), "list");
        }
        this.getRequest().setAttribute("ex", (Object)"\u53c2\u6570\u9519\u8bef\uff01\uff01\uff01");
        return "common/500";
    }

    @RequiresPermissions(value={"syscompany:list:audit:supplier", "syscompany:list:audit:terminal", "syscompany:list:audit:distributor", "syscompany:list:audit:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list/audit"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxResult audit() {
        SysUserUtils.removeCache((String)"officeList");
        Long accountId = Long.parseLong(this.getParameter("accountId"));
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("relate_to_terminal", accountId);
        List lis = this.sysCompanyService.selectByMap(map);
        if (lis.size() > 0) {
            return this.fail(false, "\u8be5\u7ec8\u7aef\u7528\u6237\u5df2\u5347\u7ea7\u4e3a\u5206\u9500\u5546\uff0c\u4e0d\u518d\u63d0\u4f9b\u6fc0\u6d3b\u670d\u52a1");
        }
        Integer status = Integer.valueOf(this.getParameter("status"));
        this.sysCompanyService.updateById((Object)new SysCompany(accountId, status));
        return this.success(true);
    }

    @RequiresPermissions(value={"syscompany:list:delete:supplier", "syscompany:list:delete:terminal", "syscompany:list:delete:distributor", "syscompany:list:delete:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list/{accountId}/delete"}, method={RequestMethod.DELETE})
    @ResponseBody
    public AjaxResult delete(@PathVariable Long accountId) {
        SysUserUtils.removeCache((String)"officeList");
        this.sysCompanyService.deleteById((Serializable)accountId);
        return this.success(true);
    }

    @RequiresPermissions(value={"syscompany:list:edit:supplier", "syscompany:list:edit:terminal", "syscompany:list:edit:resource", "syscompany:list:edit:distributor"}, logical=Logical.OR)
    @RequestMapping(value={"/list/{companyId}/edit/{type}"})
    public String edit(Model model, @PathVariable Long companyId, @PathVariable Integer type) {
        model.addAttribute("isAdd", (Object)true);
        SysCompany sysCompany = this.sysCompanyService.get(companyId);
        model.addAttribute("company", (Object)sysCompany);
        HashMap map = Maps.newHashMap();
        map.put("companyId", sysCompany.getId());
        List insProlist = this.sysCompanyService.getInsProductMap((Map)map);
        model.addAttribute("insProlist", (Object)insProlist);
        map.clear();
        map.put("company_id", sysCompany.getId());
        List contactsList = this.sysCompanyContactsService.selectByMap((Map)map);
        model.addAttribute("contactsList", (Object)contactsList);
        return this.getUrl(type, "add");
    }

    @RequiresPermissions(value={"syscompany:list:add:supplier", "syscompany:list:add:terminal", "syscompany:list:add:resource", "syscompany:list:add:distributor"}, logical=Logical.OR)
    @RequestMapping(value={"/list/add"})
    public String add(Model model) {
        model.addAttribute("isAdd", (Object)true);
        String type = this.getParameter("type");
        String terminalType = this.getParameter("terminalType");
        if (StringUtils.isNotBlank((CharSequence)terminalType)) {
            if (terminalType.equals("1") && type.equals(String.valueOf(SysCompany.COMPANY_TYPE_TERMINAL))) {
                return SYSTEM_COMPANY_TERMINAL_BUSINESS_ADD;
            }
            if (terminalType.equals("2") && type.equals(String.valueOf(SysCompany.COMPANY_TYPE_TERMINAL))) {
                return SYSTEM_COMPANY_TERMINAL_PERSONAL_ADD;
            }
        }
        return this.getUrl(Integer.parseInt(type), "add");
    }

    @RequiresPermissions(value={"syscompany:list:view:supplier", "syscompany:list:view:terminal", "syscompany:list:view:distributor", "syscompany:list:view:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list/{companyId}/view/{type}"})
    public String view(Model model, @PathVariable Long companyId, @PathVariable Integer type) {
        model.addAttribute("isAdd", (Object)false);
        SysCompany sysCompany = this.sysCompanyService.get(companyId);
        model.addAttribute("company", (Object)sysCompany);
        HashMap map = Maps.newHashMap();
        map.put("companyId", sysCompany.getId());
        List insProlist = this.sysCompanyService.getInsProductMap((Map)map);
        model.addAttribute("insProlist", (Object)insProlist);
        map.clear();
        map.put("company_id", sysCompany.getId());
        List contactsList = this.sysCompanyContactsService.selectByMap((Map)map);
        model.addAttribute("contactsList", (Object)contactsList);
        return this.getUrl(type, "add");
    }

    @RequiresPermissions(value={"syscompany:list:add:supplier", "syscompany:list:add:terminal", "syscompany:list:add:distributor", "syscompany:list:add:resource", "syscompany:list:edit:resource", "syscompany:list:edit:supplier", "syscompany:list:edit:terminal", "syscompany:list:edit:distributor"}, logical=Logical.OR)
    @RequestMapping(value={"/list/save"})
    @ResponseBody
    public AjaxResult update(@ModelAttribute(value="syscompany") SysCompany sysCompany) {
        if (sysCompany.getId() == null) {
            return this.saveSysCompanyByIdIsNull(sysCompany);
        }
        return this.updateSysCompanyByIdIsNotNull(sysCompany);
    }

    private AjaxResult updateSysCompanyByIdIsNotNull(@ModelAttribute(value="syscompany") SysCompany sysCompany) {
        SysCompanyTerminalContacts s;
        this.sysCompanyService.save((Object)sysCompany);
        if (null != sysCompany.getContactsList() && sysCompany.getContactsList().size() > 0) {
            ArrayList list = Lists.newArrayList();
            for (SysCompanyContacts s2 : sysCompany.getContactsList()) {
                s2.setSysCompany(sysCompany);
                this.sysCompanyContactsService.save((Object)s2);
            }
        }
        if (null != sysCompany.getSysCompanyTerminalContacts()) {
            s = sysCompany.getSysCompanyTerminalContacts();
            s.setSysCompany(sysCompany);
            this.sysCompanyTerminalContactsService.save((Object)s);
        }
        if (null != sysCompany.getSysCompanyChannelContacts()) {
            s = sysCompany.getSysCompanyChannelContacts();
            s.setSysCompany(sysCompany);
            this.sysCompanyChannelContactsService.save((Object)s);
        }
        SysUserUtils.removeCache((String)(sysCompany.getParentIds() + "officeParentList"));
        return this.success(true, "\u4fee\u6539\u6210\u529f!");
    }

    private AjaxResult saveSysCompanyByIdIsNull(@ModelAttribute(value="syscompany") SysCompany sysCompany) {
        SysCompanyTerminalContacts s;
        this.sysCompanyService.save((Object)sysCompany);
        if (null != sysCompany.getContactsList() && sysCompany.getContactsList().size() > 0) {
            ArrayList list = Lists.newArrayList();
            for (SysCompanyContacts s2 : sysCompany.getContactsList()) {
                s2.setSysCompany(sysCompany);
                list.add(s2);
            }
            this.sysCompanyContactsService.insertBatch((List)list);
        }
        if (null != sysCompany.getSysCompanyTerminalContacts()) {
            s = sysCompany.getSysCompanyTerminalContacts();
            s.setSysCompany(sysCompany);
            this.sysCompanyTerminalContactsService.save((Object)s);
        }
        if (null != sysCompany.getSysCompanyChannelContacts()) {
            s = sysCompany.getSysCompanyChannelContacts();
            s.setSysCompany(sysCompany);
            this.sysCompanyChannelContactsService.save((Object)s);
        }
        return this.success(true, "\u521b\u5efa\u6210\u529f!");
    }

    @RequiresPermissions(value={"syscompany:list:promote:terminal"})
    @RequestMapping(value={"/upToDistributorPage"})
    public String upToDistributorPage(Model model) {
        String terminalId = this.getParameter("terminalId");
        String companyName = this.getParameter("companyName");
        model.addAttribute("terminalId", (Object)terminalId);
        model.addAttribute("companyName", (Object)companyName);
        return SYSTEM_COMPANY_TERMINAL_TO_DISTRIBUTOR;
    }

    @RequiresPermissions(value={"syscompany:list:promote:terminal"})
    @ResponseBody
    @RequestMapping(value={"/upToDistributor"})
    public AjaxResult upToDistributor(@ModelAttribute(value="syscompany") SysCompany sysCompany) {
        String terminalId = sysCompany.getRelateToTerminal();
        String level = sysCompany.getDistributionLevel();
        if (StringUtils.isNotEmpty((CharSequence)level) && "1".equals(level)) {
            sysCompany.setParent(new SysCompany(Long.valueOf(Long.parseLong("0"))));
        }
        this.sysCompanyService.save((Object)sysCompany);
        if (null != sysCompany.getContactsList() && sysCompany.getContactsList().size() > ConstProp.INT_NUMBER_ZERO) {
            ArrayList list = Lists.newArrayList();
            for (SysCompanyContacts s : sysCompany.getContactsList()) {
                s.setSysCompany(sysCompany);
                list.add(s);
            }
            this.sysCompanyContactsService.insertBatch((List)list);
        }
        SysUserUtils.removeCache((String)"officeList");
        Long accountId = Long.parseLong(terminalId);
        Integer status = Integer.valueOf("0");
        this.sysCompanyService.updateById((Object)new SysCompany(accountId, status));
        return this.success(true, "\u63d0\u5347\u4e3a\u5206\u9500\u5546\u6210\u529f!");
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, @RequestParam(required=false) String type, @RequestParam(required=false) Long grade, @RequestParam(required=false) Boolean isAll, @RequestParam(required=false) Long parentId, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        List list = this.sysCompanyService.findList(isAll, parentId);
        for (SysCompany e : list) {
            if (!StrUtil.isBlank((String)extId) && (extId == null || extId.equals(e.getId()) || e.getParentIds().indexOf("," + extId + ",") != -1) || grade != null && (grade == null || Integer.parseInt(e.getGrade()) > grade.intValue()) || !"1".equals(e.getStatus())) continue;
            HashMap map = Maps.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentId());
            map.put("pIds", e.getParentIds());
            map.put("name", e.getCompanyName());
            if (type != null && "3".equals(type)) {
                map.put("isParent", true);
            }
            mapList.add(map);
        }
        return mapList;
    }

    @RequestMapping(value={"/upload"})
    @ResponseBody
    public AjaxResult uploadHeadPortrait(MultipartFile file) {
        SysUser user = SysUserUtils.getUser();
        String fileName = UploadFileUtils.rename((MultipartFile)file);
        String path = GlobalConstants.getUserFlie() + File.separator + user.getId().toString() + File.separator + "logo";
        File targetFile = new File(path, fileName);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        try {
            file.transferTo(targetFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.json(true, user.getId().toString() + "/logo/" + fileName);
    }

    @RequiresPermissions(value={"syscompany:list:addUser:supplier", "syscompany:list:addUser:terminal", "syscompany:list:addUser:distributor", "syscompany:list:addUser:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list/addUser"})
    public String addUser(Model model) {
        List sysRoles = this.sysRoleService.selectRoleList();
        String companyId = this.getParameter("companyId");
        SysUser user = (SysUser)this.sysUserService.selectOne(new EntityWrapper().addFilter("company_id={0}", new Object[]{companyId}));
        if (null != user) {
            List sysRoleList = this.sysUserRoleService.selectRoleListByAccountId(user.getId());
            model.addAttribute("sysRoleList", (Object)sysRoleList);
        } else if (StrUtil.isNotBlank((CharSequence)companyId)) {
            user = new SysUser(new SysCompany(Long.valueOf(Long.parseLong(companyId))));
        }
        model.addAttribute("sysUser", (Object)user);
        model.addAttribute("showPower", (Object)"showPower");
        model.addAttribute("sysRoles", (Object)sysRoles);
        return SYSTEM_USER_ADDUSER;
    }

    @RequiresPermissions(value={"syscompany:list:addUser:distributor", "syscompany:list:addUser:terminal", "syscompany:list:addUser:supplier", "syscompany:list:addUser:resource"}, logical=Logical.OR)
    @RequestMapping(value={"/list/openUserList"})
    public String openUserList(Model model) {
        String companyId = this.getParameter("companyId");
        List list = this.sysUserService.selectList(new EntityWrapper().addFilter("company_id={0}", new Object[]{companyId}));
        model.addAttribute("sysUsers", (Object)list);
        model.addAttribute("companyId", (Object)companyId);
        return SYSTEM_USER_LISTUSER;
    }

    private String getUrl(Integer companyType, String type) {
        if ("list".equals(type)) {
            return this.checkUrlTYpeList(companyType);
        }
        return this.checkURlAdd(companyType);
    }

    private String checkUrlTYpeList(Integer type) {
        if (SysCompany.COMPANY_TYPE_DISTRIBUTOR.equals(type)) {
            return SYSTEM_COMPANY_DISTRIBUTOR_LIST;
        }
        if (SysCompany.COMPANY_TYPE_SUPPLIER.equals(type)) {
            return SYSTEM_COMPANY_SUPPLIER_LIST;
        }
        if (SysCompany.COMPANY_TYPE_TERMINAL.equals(type)) {
            return SYSTEM_COMPANY_TERMINAL_LIST;
        }
        if (SysCompany.COMPANY_TYPE_CHANNEL.equals(type)) {
            return SYSTEM_COMPANY_CHANNEL_LIST;
        }
        return "common/404";
    }

    private String checkURlAdd(Integer type) {
        if (SysCompany.COMPANY_TYPE_DISTRIBUTOR.equals(type)) {
            return SYSTEM_COMPANY_DISTRIBUTOR_ADD;
        }
        if (SysCompany.COMPANY_TYPE_SUPPLIER.equals(type)) {
            return SYSTEM_COMPANY_SUPPLIER_ADD;
        }
        if (SysCompany.COMPANY_TYPE_SUPPLIER_VIEW.equals(type)) {
            return SYSTEM_COMPANY_SUPPLIER_VIEW;
        }
        if (SysCompany.COMPANY_TYPE_CHANNEL.equals(type)) {
            return SYSTEM_COMPANY_CHANNEL_ADD;
        }
        return "common/404";
    }
}

