/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.web;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.MySysClientCompanyService;
import com.bcxin.ins.core.service.MySysClientUserService;
import com.bcxin.ins.core.service.MyUtilService;
import com.bcxin.ins.core.util.CTLUtil;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${systemPath}/myclientuser"})
public class MySysClientUserController
extends BaseController {
    private static final String LIST = MySysClientUserController.getViewPath((String)"admin/clientuser/client_user_list");
    private static final String ADD_PERSON = MySysClientUserController.getViewPath((String)"admin/clientuser/client_user_add_person");
    private static final String ADD_COMPANY = MySysClientUserController.getViewPath((String)"admin/clientuser/client_user_add_company");
    private static final String DETAIL = MySysClientUserController.getViewPath((String)"admin/clientuser/client_user_add_detail");
    @Autowired
    private MySysClientUserService cuserS;
    @Autowired
    private MySysClientCompanyService companyS;
    @Autowired
    private MyUtilService utilS;

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/list"})
    public String winList(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest request) {
        return LIST;
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/person/upd"})
    public String winPersonUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("row", this.cuserS.selectById((Serializable)Long.valueOf(String.valueOf(params.get("sys_client_user_id")))));
        model.addAttribute("mark", (Object)"upd");
        return ADD_PERSON;
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/person/add"})
    public String winPersonAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("mark", (Object)"add");
        return ADD_PERSON;
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/company/upd"})
    public String winCompanyUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("row", this.companyS.selectById((Serializable)Long.valueOf(String.valueOf(params.get("sys_client_company_id")))));
        model.addAttribute("mark", (Object)"upd");
        return ADD_COMPANY;
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/company/add"})
    public String winCompnayAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("mark", (Object)"add");
        return ADD_COMPANY;
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/win/detail"})
    public String detail(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("row", (Object)this.cuserS.selectByUserID(params));
        return DETAIL;
    }

    @RequestMapping(value={"/detail/json"})
    @ResponseBody
    public Object detailJson(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        return this.cuserS.selectByUserID(params);
    }

    @RequestMapping(value={"/district"})
    @ResponseBody
    public Object district(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        model.addAttribute("mark", (Object)"add");
        return this.utilS.getArea(params);
    }

    @RequestMapping(value={"/company"})
    @ResponseBody
    public Object company(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        return this.cuserS.getCompany(params);
    }

    @RequestMapping(value={"/tpos_area"})
    @ResponseBody
    public Object tposArea(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        return this.cuserS.getCountryCodeList(params);
    }

    @RequiresPermissions(value={"myclientuser:win:list"})
    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public Object query(@RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        CTLUtil.out((Object)this.cuserS.query(p), (HttpServletResponse)resp);
        return null;
    }

    @RequiresPermissions(value={"myclientuser:person:audit"})
    @RequestMapping(value={"/person/audit"})
    @ResponseBody
    public Object personAudit(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.cuserS.personUpd(p);
    }

    @RequiresPermissions(value={"myclientuser:person:add"})
    @RequestMapping(value={"/person/add"})
    @ResponseBody
    public Object personAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.cuserS.personAdd(p);
    }

    @RequiresPermissions(value={"myclientuser:person:upd"})
    @RequestMapping(value={"/person/upd"})
    @ResponseBody
    public Object personUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.cuserS.personUpd(p);
    }

    @RequiresPermissions(value={"myclientuser:company:add"})
    @RequestMapping(value={"/company/add"})
    @ResponseBody
    public Object companyAdd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.cuserS.companyAdd(p);
    }

    @RequiresPermissions(value={"myclientuser:company:upd"})
    @RequestMapping(value={"/company/upd"})
    @ResponseBody
    public Object companyUpd(Model model, @RequestParam Map<Object, Object> params, HttpServletRequest req, HttpServletResponse resp) {
        Map p = CTLUtil.init((HttpServletRequest)req, params);
        return this.cuserS.companyUpd(p);
    }
}

