/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.ueditor.util.upload;

import com.bcxin.ins.models.ueditor.util.upload.UploadUtils;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileRepository
implements ServletContextAware {
    private Logger log = LoggerFactory.getLogger(FileRepository.class);
    private ServletContext ctx;

    public String storeByExt(String path, String ext, MultipartFile file) throws IOException {
        String filename = UploadUtils.generateFilename(ext);
        File dest = new File(path);
        dest = UploadUtils.getUniqueFile(dest);
        this.store(file, dest);
        return filename;
    }

    public String storeByFilename(String filename, MultipartFile file) throws IOException {
        File dest = new File(this.getRealPath(filename));
        this.store(file, dest);
        return filename;
    }

    public String storeByExt(String path, String ext, File file) throws IOException {
        String filename = UploadUtils.generateFilename(path, ext);
        File dest = new File(this.getRealPath(filename));
        dest = UploadUtils.getUniqueFile(dest);
        this.store(file, dest);
        return filename;
    }

    public String storeByFilename(String filename, File file) throws IOException {
        File dest = new File(this.getRealPath(filename));
        this.store(file, dest);
        return filename;
    }

    private void store(MultipartFile file, File dest) throws IOException {
        try {
            UploadUtils.checkDirAndCreate(dest.getParentFile());
            file.transferTo(dest);
        }
        catch (IOException e) {
            this.log.error("Transfer file error when upload file", (Throwable)e);
            throw e;
        }
    }

    private void store(File file, File dest) throws IOException {
        try {
            UploadUtils.checkDirAndCreate(dest.getParentFile());
            FileUtils.copyFile((File)file, (File)dest);
        }
        catch (IOException e) {
            this.log.error("Transfer file error when upload file", (Throwable)e);
            throw e;
        }
    }

    public File retrieve(String name) {
        return new File(this.ctx.getRealPath(name));
    }

    private String getRealPath(String name) {
        String realpath = this.ctx.getRealPath(name);
        if (realpath == null) {
            realpath = this.ctx.getRealPath("/") + name;
        }
        return realpath;
    }

    public void setServletContext(ServletContext servletContext) {
        this.ctx = servletContext;
    }
}

