/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.product.service.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.entity.product_core.ProResponsibility;
import com.bcxin.ins.models.product.dao.InsProductResponsibilityDao;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.mybatisplus.service.impl.ServiceImpl;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InsProductResponsibilityServiceImpl
extends ServiceImpl<InsProductResponsibilityDao, ProResponsibility>
implements InsProductResponsibilityService {
    @Autowired
    private InsProductResponsibilityDao dao;

    @Override
    public List<ResponsibilityVo> getResponsibilityVoListByProductID(Long product_id) {
        return this.dao.getResponsibilityVoListByProductID(product_id);
    }

    @Override
    public List<ResponsibilityVo> findResponsibilityVoList(String pro_primary_id) {
        List voList;
        String key = "BLB:CACHE:PRODUCT-RESPONSIBILITY-";
        if (JedisUtils.exists((String)key)) {
            voList = JSON.parseArray((String)JedisUtils.get((String)key), ResponsibilityVo.class);
        } else {
            voList = this.dao.findResponsibilityVoList();
            JedisUtils.set((String)key, (String)JSON.toJSONString((Object)voList), (int)ConstProp.ONE_MONTH_TIMEOUT_SECONDS);
        }
        if (StringUtils.isNotEmpty((CharSequence)pro_primary_id)) {
            voList = voList.stream().filter(e -> pro_primary_id.contains(e.getPro_primary_id())).collect(Collectors.toList());
        }
        return voList;
    }

    @Override
    public List<ResponsibilityVo> findResponsibilityVoListByResponsibilityIds(String pro_primary_id, String responsibilityIds) {
        if (StringUtils.isEmpty((CharSequence)responsibilityIds) && StringUtils.isEmpty((CharSequence)pro_primary_id)) {
            return new ArrayList<ResponsibilityVo>();
        }
        if (StringUtils.isEmpty((CharSequence)responsibilityIds)) {
            return this.findResponsibilityVoList(pro_primary_id);
        }
        return this.dao.getResponsibilityVoListByResponsibilityIds(responsibilityIds.split(","));
    }
}

