/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ins.models.order.policy.service.impl;

import com.bcxin.ins.common.dto.AjaxResult;
import com.bcxin.ins.core.entity.MySysClientUser;
import com.bcxin.ins.core.entity.SysLog;
import com.bcxin.ins.core.service.MySysClientUserService;
import com.bcxin.ins.core.service.SysLogService;
import com.bcxin.ins.entity.policy_core.InsAgreement;
import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.entity.policy_core.InsMailPolicy;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.entity.policy_core.InsUnderwrite;
import com.bcxin.ins.entity.policy_special.Hireling;
import com.bcxin.ins.entity.policy_special.LnAccused;
import com.bcxin.ins.entity.policy_special.SpecialBid;
import com.bcxin.ins.entity.policy_special.SpecialCreditMicro;
import com.bcxin.ins.entity.policy_special.SpecialExhibition;
import com.bcxin.ins.entity.policy_special.SpecialLitigation;
import com.bcxin.ins.entity.policy_special.SpecialPerformance;
import com.bcxin.ins.entity.policy_special.SpecialPublicDuty;
import com.bcxin.ins.entity.product_core.ProPrimary;
import com.bcxin.ins.models.apply.service.ComTaskResidualService;
import com.bcxin.ins.models.apply.service.PreseverApplyService;
import com.bcxin.ins.models.order.policy.dao.HirelingDao;
import com.bcxin.ins.models.order.policy.dao.InsRoleInpolicyDao;
import com.bcxin.ins.models.order.policy.service.HirelingService;
import com.bcxin.ins.models.order.policy.service.InsAgreementService;
import com.bcxin.ins.models.order.policy.service.InsCommonExportService;
import com.bcxin.ins.models.order.policy.service.InsInsuranceSlipService;
import com.bcxin.ins.models.order.policy.service.InsMailPolicyService;
import com.bcxin.ins.models.order.policy.service.InsMicroExportService;
import com.bcxin.ins.models.order.policy.service.InsRoleInpolicyService;
import com.bcxin.ins.models.order.policy.service.InsTransactionService;
import com.bcxin.ins.models.order.policy.service.InsUnderwriteService;
import com.bcxin.ins.models.order.policy.service.InsuranceOperationService;
import com.bcxin.ins.models.order.policy.service.LnAccusedService;
import com.bcxin.ins.models.order.policy.service.SpecialBidService;
import com.bcxin.ins.models.order.policy.service.SpecialExhibitionService;
import com.bcxin.ins.models.order.policy.service.SpecialLitigationService;
import com.bcxin.ins.models.order.policy.service.SpecialPerformanceService;
import com.bcxin.ins.models.order.policy.service.SpecialPublicDutyService;
import com.bcxin.ins.models.product.service.InsProductResponsibilityService;
import com.bcxin.ins.models.product.service.InsProductService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.Exceptions;
import com.bcxin.ins.util.IdWorker;
import com.bcxin.ins.util.MyConverUtil;
import com.bcxin.ins.util.OrderSupportUtil;
import com.bcxin.ins.util.toolbox.StrUtil;
import com.bcxin.ins.vo.AdviceNoteVo;
import com.bcxin.ins.vo.CommonExportVo_1;
import com.bcxin.ins.vo.CommonExportVo_2;
import com.bcxin.ins.vo.CommonExportVo_3;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.GMRPolicyVo;
import com.bcxin.ins.vo.GYXPolicyVo;
import com.bcxin.ins.vo.LOTEPolicyVo;
import com.bcxin.ins.vo.MailPolicyVo;
import com.bcxin.ins.vo.MicroExportVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.ins.vo.ParamVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResponsibilityVo;
import com.bcxin.ins.vo.RoleSubjectVo;
import com.bcxin.ins.vo.SpecialBidVo;
import com.bcxin.ins.vo.SpecialExhibitionVo;
import com.bcxin.ins.vo.SpecialHirelingVo;
import com.bcxin.ins.vo.SpecialLitigationVo_1;
import com.bcxin.ins.vo.SpecialLitigationVo_2;
import com.bcxin.ins.vo.SpecialLitigationVo_3;
import com.bcxin.ins.vo.SpecialPerformanceVo_1;
import com.bcxin.ins.vo.SpecialPerformanceVo_2;
import com.bcxin.ins.vo.SpecialPerformanceVo_3;
import com.bcxin.ins.vo.SpecialPublicDutyVo;
import com.bcxin.ins.vo.SurrenderVo;
import com.bcxin.ins.vo.UnderwriteVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
@Transactional
public class InsuranceOperationServiceImpl
implements InsuranceOperationService {
    private Logger log = LoggerFactory.getLogger(InsuranceOperationServiceImpl.class);
    @Autowired
    private InsInsuranceSlipService insInsuranceSlipService;
    @Autowired
    private InsAgreementService insAgreementService;
    @Autowired
    private InsMicroExportService insMicroExportService;
    @Autowired
    private InsRoleInpolicyService insRoleInpolicyService;
    @Autowired
    private InsRoleInpolicyDao insRoleInpolicyDao;
    @Autowired
    private InsCommonExportService insCommonExportService;
    @Autowired
    private InsProductService insProductService;
    @Autowired
    private InsProductResponsibilityService insProductResponsibilityService;
    @Autowired
    private InsMailPolicyService insMailPolicyService;
    @Autowired
    private InsTransactionService insTransactionService;
    @Autowired
    private SpecialLitigationService specialLitigationService;
    @Autowired
    private SpecialBidService insSpecialBidService;
    @Autowired
    private SpecialPerformanceService insSpecialPerformanceService;
    @Autowired
    private SpecialPublicDutyService specialPublicDutyService;
    @Autowired
    private MySysClientUserService mySysClientUserService;
    @Autowired
    private SysLogService logService;
    @Autowired
    private InsUnderwriteService insUnderwriteService;
    @Autowired
    private SpecialExhibitionService specialExhibitionService;
    @Autowired
    private HirelingService hirelingService;
    @Autowired
    private HirelingDao hirelingDao;
    @Autowired
    private LnAccusedService lnAccusedService;
    @Autowired
    private PreseverApplyService preseverApplyService;
    @Autowired
    private ComTaskResidualService comTaskResidualService;

    @Override
    public UnderwriteVo getUnderwriteByOrder(InsInsuranceSlip order) {
        UnderwriteVo result = null;
        try {
            if (order != null) {
                if (order.getUnderwrite() == null) {
                    this.insUnderwriteService.initInsUnderwrite();
                    order.setUnderwrite(this.insUnderwriteService.initInsUnderwrite());
                    this.insInsuranceSlipService.updateById(order);
                }
                result = this.insUnderwriteService.accordingToInsUnderwriteIntoUnderwriteVo(order.getUnderwrite());
            }
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u627f\u4fdd\u8868\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return result;
    }

    @Override
    public AjaxResult updateOrderAudit(String signOperate, UnderwriteVo vo, Long order_id) {
        try {
            InsInsuranceSlip insInsuranceSlip;
            if ("1".equals(vo.getPayment_way())) {
                vo.setYear_premium(vo.getInitial_premium());
            }
            if ((insInsuranceSlip = this.insInsuranceSlipService.getInsOrderForm(order_id)) == null) {
                return new AjaxResult(false, "\u6838\u4fdd\u6570\u636e\u4e22\u5931!");
            }
            vo.setIns_insurance_slip_id(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            if (StrUtil.isNotBlank((CharSequence)vo.getYear_premium())) {
                insInsuranceSlip.setPremium(new BigDecimal(vo.getYear_premium()));
            }
            if (StrUtil.isNotBlank((CharSequence)vo.getTotal_rate())) {
                insInsuranceSlip.setRate(new BigDecimal(vo.getTotal_rate()));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            this.insUnderwriteService.accordingToTheUnderwriteVoSetUpInsUnderwrite(vo);
            if (StrUtil.isBlank((String)vo.getOid())) {
                return new AjaxResult(false, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u5931\u8d25!");
            }
            if (StrUtil.isNotBlank((CharSequence)signOperate)) {
                if (StrUtil.isNotBlank((CharSequence)this.updateDataByUnderWrite(order_id, vo))) {
                    return new AjaxResult(true, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
                }
                return new AjaxResult(false, "\u6838\u4fdd\u72b6\u6001\u66f4\u65b0\u5931\u8d25!");
            }
            return new AjaxResult(true, "\u6838\u4fdd\u4fe1\u606f\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            this.log.error("\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public AjaxResult updateOrderAudit_API(HttpServletRequest request, String signOperate, String sup_id, UnderwriteVo vo, Long order_id) {
        try {
            InsInsuranceSlip insInsuranceSlip;
            if ("1".equals(vo.getPayment_way())) {
                vo.setYear_premium(vo.getInitial_premium());
            }
            if ((insInsuranceSlip = this.insInsuranceSlipService.getInsOrderForm(order_id)) == null) {
                return new AjaxResult(false, "\u6838\u4fdd\u6570\u636e\u4e22\u5931!");
            }
            vo.setIns_insurance_slip_id(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
            if (StrUtil.isNotBlank((CharSequence)vo.getYear_premium())) {
                insInsuranceSlip.setPremium(new BigDecimal(vo.getYear_premium()));
            }
            if (StrUtil.isNotBlank((CharSequence)vo.getTotal_rate())) {
                insInsuranceSlip.setRate(new BigDecimal(vo.getTotal_rate()));
            }
            this.insInsuranceSlipService.updateById(insInsuranceSlip);
            this.insUnderwriteService.accordingToTheUnderwriteVoSetUpInsUnderwrite(vo);
            if (StrUtil.isBlank((String)vo.getOid())) {
                return new AjaxResult(false, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u5931\u8d25!");
            }
            if (StrUtil.isNotBlank((CharSequence)signOperate)) {
                if (StrUtil.isNotBlank((CharSequence)this.updateDataByUnderWrite(order_id, vo))) {
                    this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u6838\u4fdd-\u4fee\u6539", null, sup_id);
                    return new AjaxResult(true, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
                }
                return new AjaxResult(false, "\u6838\u4fdd\u72b6\u6001\u66f4\u65b0\u5931\u8d25!");
            }
            return new AjaxResult(true, "\u6838\u4fdd\u4fe1\u606f\u4fdd\u5b58\u6210\u529f!");
        }
        catch (Exception e) {
            this.log.error("\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u6838\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    private String updateDataByUnderWrite(Long order_id, UnderwriteVo vo) {
        String result = "";
        try {
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(order_id);
            String oStatus = "4";
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-DQCK".equals(orderVo.getProduct_code())) {
                oStatus = "3";
            }
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-XWCK".equals(orderVo.getProduct_code())) {
                oStatus = "5";
            }
            orderVo.setPolicy_status(oStatus);
            result = this.updateOrderFormStatus(orderVo);
        }
        catch (Exception e) {
            this.log.error("\u6838\u4fdd\u72b6\u6001\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return result;
    }

    @Override
    public String orderAuditFail(String ty, String remarks, Long order_id) {
        String result = "";
        try {
            if ("1".equals(ty)) {
                remarks = "\u6838\u4fdd\u4e0d\u901a\u8fc7\u7406\u7531\uff1a" + remarks;
            } else if ("2".equals(ty)) {
                remarks = "\u627f\u4fdd\u4e0d\u901a\u8fc7\u7406\u7531\uff1a" + remarks;
            }
            InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
            order.setRemarks(remarks);
            this.insInsuranceSlipService.updateById(order);
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(order_id);
            orderVo.setPolicy_status("15");
            result = this.updateOrderFormStatus(orderVo);
        }
        catch (Exception e) {
            this.log.error("\u6838\u4fdd\u4e0d\u901a\u8fc7\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return result;
    }

    @Override
    public String orderAuditFail_API(HttpServletRequest request, String sup_id, String ty, String remarks, Long order_id) {
        String result = "";
        try {
            if ("1".equals(ty)) {
                remarks = "\u6838\u4fdd\u4e0d\u901a\u8fc7\u7406\u7531\uff1a" + remarks;
            } else if ("2".equals(ty)) {
                remarks = "\u627f\u4fdd\u4e0d\u901a\u8fc7\u7406\u7531\uff1a" + remarks;
            }
            InsInsuranceSlip order = this.insInsuranceSlipService.selectById(order_id);
            order.setRemarks(remarks);
            this.insInsuranceSlipService.updateById(order);
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(order_id);
            orderVo.setPolicy_status("15");
            result = this.updateOrderFormStatus(orderVo);
            this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u6838/\u627f\u4fdd->\u62d2\u4fdd", null, sup_id);
        }
        catch (Exception e) {
            this.log.error("\u6838\u4fdd\u4e0d\u901a\u8fc7\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return result;
    }

    @Override
    public AjaxResult updateOrderUnderwriting(OrderFormVo orderFormVo, String underwritingOid, String acceptanceTime, String out_of_pocket, String signOperate) {
        if (StrUtil.isBlank((String)orderFormVo.getOid())) {
            return new AjaxResult(false, "\u627f\u4fdd\u5931\u8d25!");
        }
        try {
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(Long.parseLong(orderFormVo.getOid()));
            if (StrUtil.isNotBlank((CharSequence)underwritingOid) && StrUtil.isNotBlank((CharSequence)acceptanceTime)) {
                InsUnderwrite insUnderwrite = (InsUnderwrite)this.insUnderwriteService.selectById(Long.valueOf(Long.parseLong(underwritingOid)));
                insUnderwrite.setAcceptance_time(com.bcxin.ins.util.toolbox.DateUtil.parse((String)acceptanceTime, (String)"yyyy/MM/dd"));
                this.insUnderwriteService.updateById(insUnderwrite);
            }
            this.updatePayNumber(orderFormVo.getOid(), orderFormVo.getPay_order_number(), out_of_pocket, orderVo.getProduct_code());
            this.insInsuranceSlipService.updateOrderUnderwriting(orderFormVo);
            if (StrUtil.isBlank((String)signOperate)) {
                return new AjaxResult(true, "\u5df2\u4fdd\u5b58\u627f\u4fdd\u4fe1\u606f!");
            }
            String oStatus = "6";
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "BZX-SSBQ".equals(orderVo.getProduct_code())) {
                oStatus = "6";
            }
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-XWCK".equals(orderVo.getProduct_code())) {
                oStatus = "6";
            }
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-DQCK".equals(orderVo.getProduct_code())) {
                oStatus = "16";
            }
            orderVo.setPolicy_status(oStatus);
            if (StrUtil.isNotBlank((CharSequence)this.updateOrderFormStatus(orderVo))) {
                return new AjaxResult(true, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
            }
            return new AjaxResult(false, "\u627f\u4fdd\u72b6\u6001\u66f4\u65b0\u5931\u8d25!");
        }
        catch (Exception e) {
            this.log.error("\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    private void updatePayNumber(String oid, String pay_order_number, String out_of_pocket, String product_code) {
        if (StringUtils.isEmpty((CharSequence)product_code)) {
            return;
        }
        if (!"BZX-GCLY".equals(product_code) && !"BZX-SSBQ".equals(product_code)) {
            return;
        }
        if (StrUtil.isBlank((String)pay_order_number) || StrUtil.isBlank((String)out_of_pocket)) {
            return;
        }
        List<InsTransaction> tranList = this.insTransactionService.selectInsTransactionByInsOrderForm(Long.parseLong(oid));
        if (tranList != null && tranList.size() > ConstProp.INT_NUMBER_ZERO) {
            InsTransaction tran = tranList.get(ConstProp.INT_NUMBER_ZERO);
            tran.setPay_order_number(pay_order_number);
            tran.setOut_of_pocket(new BigDecimal(out_of_pocket));
            tran.setStatus(ConstProp.INT_NUMBER_ONE);
            tran.setTransaction_status("1");
            tran.setEnd_time(new Date());
            this.insTransactionService.updateById(tran);
        }
    }

    @Override
    public AjaxResult updateOrderUnderwriting_API(HttpServletRequest request, String sup_id, OrderFormVo orderFormVo, String underwritingOid, String acceptanceTime, String out_of_pocket, String signOperate) {
        if (StrUtil.isBlank((String)orderFormVo.getOid())) {
            return new AjaxResult(false, "\u627f\u4fdd\u5931\u8d25!");
        }
        try {
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(Long.parseLong(orderFormVo.getOid()));
            if (StrUtil.isNotBlank((CharSequence)underwritingOid) && StrUtil.isNotBlank((CharSequence)acceptanceTime)) {
                InsUnderwrite insUnderwrite = (InsUnderwrite)this.insUnderwriteService.selectById(Long.valueOf(Long.parseLong(underwritingOid)));
                insUnderwrite.setAcceptance_time(com.bcxin.ins.util.toolbox.DateUtil.parse((String)acceptanceTime, (String)"yyyy/MM/dd"));
                this.insUnderwriteService.updateById(insUnderwrite);
            }
            this.updatePayNumber(orderFormVo.getOid(), orderFormVo.getPay_order_number(), out_of_pocket, orderVo.getProduct_code());
            this.insInsuranceSlipService.updateOrderUnderwriting(orderFormVo);
            if (StrUtil.isBlank((String)signOperate)) {
                return new AjaxResult(true, "\u5df2\u4fdd\u5b58\u627f\u4fdd\u4fe1\u606f!");
            }
            String oStatus = "6";
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "BZX-SSBQ".equals(orderVo.getProduct_code())) {
                oStatus = "6";
            }
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-XWCK".equals(orderVo.getProduct_code())) {
                oStatus = "6";
            }
            if (!StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) && "XYX-DQCK".equals(orderVo.getProduct_code())) {
                oStatus = "16";
            }
            orderVo.setPolicy_status(oStatus);
            if (StrUtil.isNotBlank((CharSequence)this.updateOrderFormStatus(orderVo))) {
                this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u627f\u4fdd-\u4fee\u6539", null, sup_id);
                return new AjaxResult(true, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u6210\u529f!");
            }
            return new AjaxResult(false, "\u627f\u4fdd\u72b6\u6001\u66f4\u65b0\u5931\u8d25!");
        }
        catch (Exception e) {
            this.log.error("\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public AjaxResult updateTransactionPayOrderNumber(String[] payOrderNumbers, String order_id) {
        try {
            if (payOrderNumbers.length <= ConstProp.INT_NUMBER_ZERO || StrUtil.isBlank((String)order_id)) {
                return new AjaxResult(false, "\u627f\u4fdd\u5931\u8d25!");
            }
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(Long.parseLong(order_id));
            if (orderVo == null) {
                return new AjaxResult(false, "\u6570\u636e\u4e22\u5931!");
            }
            for (String str : payOrderNumbers) {
                String[] arr = str.split(";");
                if (StrUtil.isBlank((String)arr[ConstProp.INT_NUMBER_ONE])) {
                    return new AjaxResult(false, "\u652f\u4ed8\u51ed\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                InsTransaction insTransaction = (InsTransaction)this.insTransactionService.selectById((Serializable)((Object)arr[ConstProp.INT_NUMBER_ZERO]));
                if (insTransaction == null) continue;
                insTransaction.setPay_order_number(arr[ConstProp.INT_NUMBER_ONE]);
                insTransaction.setOut_of_pocket(new BigDecimal(arr[ConstProp.INT_NUMBER_TWO]));
                insTransaction.setTransaction_status("1");
                insTransaction.setEnd_time((Date)DateUtil.getTimestamp());
                this.insTransactionService.updateById(insTransaction);
                if (StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) || !"XYX-DQCK".equals(orderVo.getProduct_code()) && !orderVo.getProduct_code().contains("GZZRX-PAC")) continue;
                this.updateOrderStatusByTrans(orderVo);
                InsInsuranceSlip insPolicy = (InsInsuranceSlip)this.insInsuranceSlipService.selectById((Serializable)((Object)orderVo.getOid()));
                OrderSupportUtil.receiveTrancetionData((InsInsuranceSlip)insPolicy, (InsTransaction)insTransaction);
            }
            return new AjaxResult(true, "\u5df2\u4fdd\u5b58\u652f\u4ed8\u51ed\u8bc1\u4fe1\u606f!");
        }
        catch (Exception e) {
            this.log.error("\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    private void updateOrderStatusByTrans(OrderFormVo orderVo) {
        OrderFormVo ovo = null;
        if ("1".equals(orderVo.getPay_methods()) || orderVo.getProduct_code().contains("GZZRX-PAC")) {
            ovo = new OrderFormVo();
        } else if ("2".equals(orderVo.getPay_methods())) {
            List<InsTransaction> transactionList = this.accordingToOrderIDToGetInsTransaction(Long.parseLong(orderVo.getOid()));
            BigDecimal totalAm = BigDecimal.ZERO;
            for (InsTransaction tra : transactionList) {
                totalAm = totalAm.add(tra.getOut_of_pocket());
            }
            BigDecimal _a = totalAm.setScale((int)ConstProp.INT_NUMBER_TWO, 5);
            BigDecimal _b = new BigDecimal(orderVo.getGross_premium()).setScale((int)ConstProp.INT_NUMBER_TWO, 5);
            if (transactionList.size() < 6 && _a.compareTo(_b) >= 0) {
                ovo = new OrderFormVo();
            }
        }
        if (ovo != null) {
            ovo.setOid(orderVo.getOid());
            ovo.setPolicy_status("6");
            ovo.setProduct_code(orderVo.getProduct_code());
            this.updateOrderFormStatus(ovo);
        }
    }

    @Override
    public AjaxResult updateInsRolePolicyLink(ParamVo paramVo) {
        try {
            if (StringUtils.isEmpty((CharSequence)paramVo.getOid()) || StringUtils.isEmpty((CharSequence)paramVo.getTel()) || StringUtils.isEmpty((CharSequence)paramVo.getEmail())) {
                return new AjaxResult(false, "\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u5b8c\u6574!");
            }
            int count = this.insRoleInpolicyDao.updateInsRolePolicyLink(paramVo.getOid(), paramVo.getName(), paramVo.getTel(), paramVo.getEmail());
            if (count > 0) {
                return new AjaxResult(true, "\u4fee\u6539\u8054\u7cfb\u4eba\u4fe1\u606f\u6210\u529f!");
            }
            return new AjaxResult(false, "\u672a\u5b8c\u6210\u8054\u7cfb\u4eba\u4fe1\u606f\u4fee\u6539!");
        }
        catch (Exception e) {
            this.log.error("\u4fee\u6539\u8054\u7cfb\u4eba\u4fe1\u606f\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u4fee\u6539\u8054\u7cfb\u4eba\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public AjaxResult updateTransactionPayOrderNumber_API(HttpServletRequest request, String sup_id, String[] payOrderNumbers, String order_id) {
        try {
            if (payOrderNumbers.length <= ConstProp.INT_NUMBER_ZERO || StrUtil.isBlank((String)order_id)) {
                return new AjaxResult(false, "\u627f\u4fdd\u5931\u8d25!");
            }
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(Long.parseLong(order_id));
            if (orderVo == null) {
                return new AjaxResult(false, "\u6570\u636e\u4e22\u5931!");
            }
            for (String str : payOrderNumbers) {
                String[] arr = str.split(";");
                if (StrUtil.isBlank((String)arr[ConstProp.INT_NUMBER_ONE])) {
                    return new AjaxResult(false, "\u652f\u4ed8\u51ed\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                InsTransaction insTransaction = (InsTransaction)this.insTransactionService.selectById((Serializable)((Object)arr[ConstProp.INT_NUMBER_ZERO]));
                if (insTransaction == null) continue;
                insTransaction.setPay_order_number(arr[ConstProp.INT_NUMBER_ONE]);
                insTransaction.setOut_of_pocket(new BigDecimal(arr[ConstProp.INT_NUMBER_TWO]));
                insTransaction.setTransaction_status("1");
                insTransaction.setEnd_time((Date)DateUtil.getTimestamp());
                this.insTransactionService.updateById(insTransaction);
                if (StringUtils.isEmpty((CharSequence)orderVo.getProduct_code()) || !"XYX-DQCK".equals(orderVo.getProduct_code()) && !orderVo.getProduct_code().contains("GZZRX-PAC")) continue;
                this.updateOrderStatusByTrans(orderVo);
                InsInsuranceSlip insPolicy = (InsInsuranceSlip)this.insInsuranceSlipService.selectById((Serializable)((Object)orderVo.getOid()));
                OrderSupportUtil.receiveTrancetionData((InsInsuranceSlip)insPolicy, (InsTransaction)insTransaction);
            }
            this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u652f\u4ed8\u786e\u8ba4", null, sup_id);
            return new AjaxResult(true, "\u5df2\u4fdd\u5b58\u652f\u4ed8\u51ed\u8bc1\u4fe1\u606f!");
        }
        catch (Exception e) {
            this.log.error("\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u627f\u4fdd\u4fe1\u606f\u66f4\u65b0\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public InsInsuranceSlip initOrderCorrelation(Long poductID, Long user_id) {
        InsInsuranceSlip insOrderForm = this.insInsuranceSlipService.initOrderForm(poductID, user_id);
        return insOrderForm;
    }

    @Override
    public void setMicroExportByMicroExportVo(MicroExportVo vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        vo.setTrade_serial_number(insInsuranceSlip.getTrade_serial_number());
        vo.setOrder_status(insInsuranceSlip.getOrder_status());
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.insMicroExportService.accordingToTheMicroExportVoSetUpInsMicroExport(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(vo.getExport_amount()), insInsuranceSlip);
    }

    @Override
    public MicroExportVo getMicroExportVoByOrderID(Long orderID) {
        MicroExportVo vo = new MicroExportVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getPremium() != null) {
            vo.setGross_premium(String.valueOf(insInsuranceSlip.getPremium()));
        }
        if (insInsuranceSlip.getInsured_amount() != null) {
            vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        }
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        if (insInsuranceSlip.getPlanned_end_date() != null) {
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        this.insMicroExportService.getMicroExportVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public void setCommonExportByCommonExportVo_1(CommonExportVo_1 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(vo.getOid()));
        this.insRoleInpolicyService.setRoleInPolicyByRoleCompanyVo(vo.getRoleSubjectList(), insInsuranceSlip.getIns_insurance_slip_id());
        this.insCommonExportService.accordingToTheCommonExportVo_1SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
        this.insInsuranceSlipService.getInsuredAmountSetToInsInsuranceSlip(new BigDecimal(((RoleSubjectVo)vo.getRoleSubjectList().get(0)).getTurnover_export()), insInsuranceSlip);
    }

    @Override
    public void setCommonExportByCommonExportVo_2(CommonExportVo_2 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.insCommonExportService.accordingToTheCommonExportVo_2SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
    }

    @Override
    public void setCommonExportByCommonExportVo_3(CommonExportVo_3 vo) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(Long.parseLong(vo.getOid()));
        this.insCommonExportService.accordingToTheCommonExportVo_3SetUpInsCommonExport(vo, insInsuranceSlip.getSpecial_id());
        this.insMailPolicyService.accordingToTheMailPolicyVoSetUpInsMailPolicy(vo.getMailPolicyVo(), insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
    }

    @Override
    public CommonExportVo_1 getCommonExportVo_1ByOrderID(Long orderID) {
        CommonExportVo_1 vo = new CommonExportVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public CommonExportVo_2 getCommonExportVo_2ByOrderID(Long orderID) {
        CommonExportVo_2 vo = new CommonExportVo_2();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public CommonExportVo_3 getCommonExportVo_3ByOrderID(Long orderID) {
        CommonExportVo_3 vo = new CommonExportVo_3();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insCommonExportService.getCommonExportVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public List<OrderFormVo> selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(Long user_id, String status, DwzPage page) {
        return this.insInsuranceSlipService.selectInsOrderFormByUserIDAndStatusSetUpOrderFormVo(user_id, status, page);
    }

    @Override
    public OrderStatusCountVo selectOrderStatusCountVoByUserID(Long user_id) {
        return this.insInsuranceSlipService.selectOrderStatusCountVoByUserID(user_id);
    }

    @Override
    public List<ProductVo> selectProductVoList(ProPrimary insProduct) {
        return this.insProductService.selectProductVoList(insProduct);
    }

    @Override
    public ProductVo accordingToInsProductIDToGetInsProductInProductVo(Long insProductID) {
        return this.insProductService.accordingToInsProductIDToGetInsProductInProductVo(insProductID);
    }

    @Override
    public OrderFormVo accordingToOrderIDToGetOrderFormVo(Long order_id) {
        return this.insInsuranceSlipService.findOrderFormVoByID(order_id);
    }

    @Override
    public AdviceNoteVo accordingToOrderIDToGetAdviceNoteVo(Long order_id) {
        InsInsuranceSlip order = this.insInsuranceSlipService.packagingInsOrderForm(order_id);
        return this.insInsuranceSlipService.willInsOrderFormSetUpAdviceNoteVo(order);
    }

    @Override
    public String updateOrderFormStatus(OrderFormVo vo) {
        if ("6".equals(vo.getPolicy_status()) && !"XYX-DQCK".equals(vo.getProduct_code()) || "16".equals(vo.getPolicy_status())) {
            this.orderSyncZC(vo.getOid());
        }
        return this.insInsuranceSlipService.updateOrderFormStatus(vo);
    }

    @Override
    public AjaxResult orderUnSyncDispose() {
        try {
            List<OrderFormVo> voList = this.insInsuranceSlipService.findInsOrderFormByUnSync();
            for (OrderFormVo vo : voList) {
                this.orderSyncZC(vo.getOid());
            }
            return new AjaxResult(true, "\u8ba2\u5355\u540c\u6b65\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u540c\u6b65\u64cd\u4f5c\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u8ba2\u5355\u540c\u6b65\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public AjaxResult orderUnSyncDispose_API(HttpServletRequest request) {
        try {
            List<OrderFormVo> voList = this.insInsuranceSlipService.findInsOrderFormByUnSync();
            for (OrderFormVo vo : voList) {
                this.orderSyncZC(vo.getOid());
            }
            this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u8ba2\u5355\u540c\u6b65", null, request.getParameter("sup_id"));
            return new AjaxResult(true, "\u8ba2\u5355\u540c\u6b65\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            this.creatLog(request, "\u8ba2\u5355\u7ba1\u7406->\u8ba2\u5355\u540c\u6b65", e, request.getParameter("sup_id"));
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return new AjaxResult(false, "\u8ba2\u5355\u540c\u6b65\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38!");
        }
    }

    @Override
    public void creatLog(HttpServletRequest request, String title, Exception ex, String com_id) {
        try {
            SysLog log = new SysLog();
            log.setTitle(title);
            log.setType(ex == null ? "1" : "2");
            log.setRemoteAddr(StrUtil.getRemoteAddr((HttpServletRequest)request));
            log.setUserAgent(request.getHeader("user-agent"));
            log.setRequestUri(request.getRequestURI());
            log.setParams(request.getParameterMap());
            log.setMethod(request.getMethod());
            log.setCompany_id(com_id);
            if (ex != null) {
                log.setException(Exceptions.getStackTraceAsString((Throwable)ex));
            }
            log.preInsert();
            new Thread(() -> this.logService.insert((Object)log)).start();
        }
        catch (Exception e) {
            this.log.error("\u65e5\u5fd7\u66f4\u65b0\u8fc7\u7a0b\u4e8b\u52a1\u53d1\u73b0\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e", (Throwable)e);
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
    }

    @Override
    public void orderSyncZC(String oid) {
        if (StringUtils.isEmpty((CharSequence)oid)) {
            return;
        }
        InsInsuranceSlip policy = this.insInsuranceSlipService.packagingInsOrderForm(Long.parseLong(oid));
        if (policy.getOrder_zc_id() == null) {
            String sup_order_id;
            SpecialPublicDutyVo vo;
            OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(policy.getIns_insurance_slip_id());
            InsTransaction it = null;
            if (policy.getInsTransaction() != null && !policy.getInsTransaction().isEmpty()) {
                it = (InsTransaction)policy.getInsTransaction().get(0);
            }
            MySysClientUser user = (MySysClientUser)this.mySysClientUserService.selectById((Serializable)policy.getRegister_user_id());
            String insName = "";
            if ("GZX".equals(orderVo.getProduct_code().split("-")[0])) {
                vo = this.getSpecialPublicDutyVoByOrderID(Long.parseLong(orderVo.getOid()));
                insName = vo.getReport_name();
            }
            if ("ZZX".equals(orderVo.getProduct_code().split("-")[0])) {
                vo = this.getLOTEPolicyVoByOrderID(Long.parseLong(orderVo.getOid()));
                insName = vo.getSpecialExhibitionVo().getName();
            }
            if (StringUtils.isNotEmpty((CharSequence)(sup_order_id = OrderSupportUtil.receiveOrderFormData((String)String.valueOf(user.getBusiness_support_id()), (OrderFormVo)orderVo, (InsInsuranceSlip)policy, (InsTransaction)it, (String)insName)))) {
                policy.setOrder_zc_id(Long.valueOf(Long.parseLong(sup_order_id)));
                this.insInsuranceSlipService.updateById(policy);
            }
        }
        if (policy.getInsTransaction() != null && !policy.getInsTransaction().isEmpty()) {
            for (InsTransaction tr : policy.getInsTransaction()) {
                OrderSupportUtil.receiveTrancetionData((InsInsuranceSlip)policy, (InsTransaction)tr);
            }
        }
    }

    @Override
    public String uploadPayMentFileToTranction(String path_url, String order_id, String path_sign) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.getInsOrderForm(Long.parseLong(order_id));
        if (insInsuranceSlip != null) {
            this.insTransactionService.uploadPayMentFileToTranction(path_url, insInsuranceSlip, path_sign);
            return String.valueOf(insInsuranceSlip.getIns_insurance_slip_id());
        }
        return "";
    }

    @Override
    public String accordingToOrderIDGainPathSign(String order_id) {
        return this.insTransactionService.accordingToOrderIDGainPathSign(order_id);
    }

    @Override
    public void accordingToInsTopBuyersListGainInsRiskDuty(Long order_id) {
        this.insInsuranceSlipService.accordingToInsTopBuyersListGainInsRiskDuty(order_id);
    }

    @Override
    public void accordingToOrderIDCreatePolicySerialNumber(Long order_id) {
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.packagingInsOrderForm(order_id);
        this.insInsuranceSlipService.accordingToOrderIDCreatePolicySerialNumber(insInsuranceSlip);
    }

    @Override
    public List<InsTransaction> accordingToOrderIDToGetInsTransaction(Long order_id) {
        return this.insTransactionService.selectInsTransactionByInsOrderForm(order_id);
    }

    @Override
    public SpecialBidVo getSpecialBidVoByOrderID(Long orderID) {
        SpecialBidVo vo = new SpecialBidVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        this.insSpecialBidService.getSpecialBidVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getBid_time())) {
            vo.setBid_time(vo.getBid_time().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialPerformanceVo_1 getSpecialPerformanceVo_1ByOrderID(Long orderID) {
        SpecialPerformanceVo_1 vo = new SpecialPerformanceVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        this.insSpecialPerformanceService.getSpecialPerformanceVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialPerformanceVo_2 getSpecialPerformanceVo_2ByOrderID(Long orderID) {
        SpecialPerformanceVo_2 vo = new SpecialPerformanceVo_2();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.insSpecialPerformanceService.getSpecialPerformanceVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialPerformanceVo_3 getSpecialPerformanceVo_3ByOrderID(Long orderID) {
        SpecialPerformanceVo_3 vo = new SpecialPerformanceVo_3();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.insSpecialPerformanceService.getSpecialPerformanceVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialLitigationVo_1 getSpecialLitigationVo_1ByOrderID(Long orderID) {
        SpecialLitigationVo_1 vo = new SpecialLitigationVo_1();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.specialLitigationService.getSpecialLitigationVo_1BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public SpecialLitigationVo_2 getSpecialLitigationVo_2ByOrderID(Long orderID) {
        SpecialLitigationVo_2 vo = new SpecialLitigationVo_2();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specialLitigationService.getSpecialLitigationVo_2BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        MailPolicyVo voMP = new MailPolicyVo();
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        if (StringUtils.isNotEmpty((CharSequence)vo.getInception_date())) {
            vo.setInception_date(vo.getInception_date().replace(" 00:00:00", ""));
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getPlanned_end_date())) {
            vo.setPlanned_end_date(vo.getPlanned_end_date().replace(" 23:59:59", ""));
        }
        return vo;
    }

    @Override
    public SpecialLitigationVo_3 getSpecialLitigationVo_3ByOrderID(Long orderID) {
        SpecialLitigationVo_3 vo = new SpecialLitigationVo_3();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        this.specialLitigationService.getSpecialLitigationVo_3BySpecial_id(vo, insInsuranceSlip.getSpecial_id());
        return vo;
    }

    @Override
    public GMRPolicyVo getGMRPolicyVoByOrderID(Long orderID) {
        GMRPolicyVo vo = new GMRPolicyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setAccredit_path(insInsuranceSlip.getAccredit_path());
        vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        if (insInsuranceSlip.getSpecial_id() != null) {
            SpecialExhibitionVo seVo = new SpecialExhibitionVo();
            this.specialExhibitionService.getSpecialExhibitionVoByPolicyID2(seVo, insInsuranceSlip.getSpecial_id());
            vo.setSpecialExhibitionVo(seVo);
        }
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public SpecialHirelingVo getSpecialHirelingVoByOrderID(Long orderID) {
        SpecialHirelingVo vo = new SpecialHirelingVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setDispute(insInsuranceSlip.getDispute());
        vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
        vo.setPremium(String.valueOf(insInsuranceSlip.getPremium()));
        vo.setInsured_amount(String.valueOf(insInsuranceSlip.getInsured_amount()));
        vo.setIs_contain_repo(insInsuranceSlip.getIs_contain_repo());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        this.hirelingService.getSpecialHirelingVoByOrderID(vo, insInsuranceSlip.getIns_insurance_slip_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    private List<ResponsibilityVo> findResponsibilityVoList(String product_id, Long order_id) {
        InsAgreement insAgreement = this.insAgreementService.selectInsAgreementByInsInsuranceSlip(order_id);
        String responsibility_ids = "";
        if (insAgreement != null) {
            responsibility_ids = insAgreement.getResponsibility_ids();
        }
        return this.insProductResponsibilityService.findResponsibilityVoListByResponsibilityIds(product_id, responsibility_ids);
    }

    @Override
    public SpecialPublicDutyVo getSpecialPublicDutyVoByOrderID(Long orderID) {
        SpecialPublicDutyVo vo = new SpecialPublicDutyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        try {
            MyConverUtil.map2PO((Map)MyConverUtil.PO2Map((Object)insInsuranceSlip), (Object)vo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        this.specialPublicDutyService.getSpecialPublicDutyVoByPolicyID(vo, insInsuranceSlip.getSpecial_id());
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
        vo.setMailPolicyVo(voMP);
        return vo;
    }

    @Override
    public LOTEPolicyVo getLOTEPolicyVoByOrderID(Long orderID) {
        LOTEPolicyVo vo = new LOTEPolicyVo();
        MailPolicyVo voMP = new MailPolicyVo();
        SpecialExhibitionVo seVo = new SpecialExhibitionVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
        }
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        vo.setResponsibilityVoList(this.findResponsibilityVoList(vo.getProduct_id(), orderID));
        this.specialExhibitionService.getSpecialExhibitionVoByPolicyID(seVo, insInsuranceSlip.getSpecial_id());
        vo.setSpecialExhibitionVo(seVo);
        if (insInsuranceSlip.getMailPolicy() != null) {
            InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
            this.insMailPolicyService.accordingToInsMailPolicyIntoMailPolicyVo(voMP, insMailPolicy);
            vo.setMailPolicyVo(voMP);
        }
        return vo;
    }

    @Override
    public GYXPolicyVo getGYXPolicyVoByOrderID(Long orderID) {
        GYXPolicyVo vo = new GYXPolicyVo();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        vo.setOid(String.valueOf(insInsuranceSlip.getIns_insurance_slip_id()));
        if (insInsuranceSlip.getInception_date() != null) {
            vo.setInception_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getInception_date(), (String)"yyyy-MM-dd"));
            vo.setPlanned_end_date(DateUtil.convertDateToString((Date)insInsuranceSlip.getPlanned_end_date(), (String)"yyyy-MM-dd"));
        }
        vo.setDispute(insInsuranceSlip.getDispute());
        vo.setArbitral_institution(insInsuranceSlip.getArbitral_institution());
        vo.setRecommend_code(insInsuranceSlip.getRecommend_code());
        vo.setRoleSubjectList(this.insRoleInpolicyService.getRoleSubjectVoListByPolicyID(insInsuranceSlip.getIns_insurance_slip_id()));
        vo.setProduct_id(String.valueOf(insInsuranceSlip.getPro_primary().getPro_primary_id()));
        return vo;
    }

    @Override
    public List<Map<String, String>> findPersonByTYX(Long orderID) {
        return this.insRoleInpolicyDao.findPerson(orderID);
    }

    @Override
    public List<Map<String, String>> findPersonByGZZRX(Long orderID) {
        return this.hirelingDao.findPerson(orderID);
    }

    @Override
    public AjaxResult copyPolicy(Long orderID) {
        OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(orderID);
        if (orderVo == null || StringUtils.isEmpty((CharSequence)orderVo.getProduct_code())) {
            return new AjaxResult(false, "\u8ba2\u5355\u4e0d\u5b58\u5728!");
        }
        if ("XYX-DQCK".equals(orderVo.getProduct_code())) {
            return new AjaxResult(false, "\u77ed\u671f\u51fa\u53e3\u9669\u4e0d\u652f\u6301\u590d\u5236\u529f\u80fd!");
        }
        IdWorker idWorker = new IdWorker((long)ConstProp.INT_NUMBER_WORKERID.intValue(), (long)ConstProp.INT_NUMBER_ZERO.intValue());
        Long tNumber = idWorker.nextId();
        Long pId = idWorker.nextId();
        Long sId = idWorker.nextId();
        Long mId = idWorker.nextId();
        InsInsuranceSlip insInsuranceSlip = this.insInsuranceSlipService.selectById(orderID);
        InsMailPolicy insMailPolicy = (InsMailPolicy)this.insMailPolicyService.selectById(insInsuranceSlip.getMailPolicy().getIns_mail_policy_id());
        Long oldSpecial_id = insInsuranceSlip.getSpecial_id();
        insMailPolicy.setIns_mail_policy_id(mId);
        insInsuranceSlip.setIns_insurance_slip_id(pId);
        insInsuranceSlip.setTrade_serial_number(String.valueOf(tNumber));
        insInsuranceSlip.setMailPolicy(insMailPolicy);
        insInsuranceSlip.setUnderwrite(null);
        insInsuranceSlip.setPolicy_serial_number("");
        insInsuranceSlip.setSigned_date(new Date());
        insInsuranceSlip.setCreate_time(new Date());
        insInsuranceSlip.setStart_time(new Date());
        insInsuranceSlip.setOrder_status("1");
        HashMap columnMap = Maps.newHashMap();
        columnMap.put("insurance_slip_id", orderID);
        List roleList = this.insRoleInpolicyService.selectByMap(columnMap);
        for (Object role : roleList) {
            role.setIns_role_inpolicy_id(Long.valueOf(idWorker.nextId()));
            role.setInsurance_slip(insInsuranceSlip);
        }
        this.insMailPolicyService.insert(insMailPolicy);
        this.insRoleInpolicyService.insertBatch(roleList);
        if (orderVo.getProduct_code().contains("GZZRX")) {
            columnMap = Maps.newHashMap();
            columnMap.put("ins_insurance_slip_id", orderID);
            List hirelingList = this.hirelingService.selectByMap(columnMap);
            for (Hireling hireling : hirelingList) {
                hireling.setHireling_id(Long.valueOf(idWorker.nextId()));
                hireling.setIns_insurance_slip_id(pId);
            }
            this.hirelingService.insertBatch(hirelingList);
        } else if (orderVo.getProduct_code().contains("ZZX")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialExhibition specialExhibition = (SpecialExhibition)this.specialExhibitionService.selectById(oldSpecial_id);
            specialExhibition.setSpecial_exhibition_id(sId);
            this.specialExhibitionService.insert(specialExhibition);
        } else if (orderVo.getProduct_code().contains("GZX")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialPublicDuty specialPublicDuty = (SpecialPublicDuty)this.specialPublicDutyService.selectById(oldSpecial_id);
            specialPublicDuty.setSpecial_public_duty_id(sId);
            this.specialPublicDutyService.insert(specialPublicDuty);
        } else if (orderVo.getProduct_code().contains("GCLY")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialPerformance insSpecialPerformance = (SpecialPerformance)this.insSpecialPerformanceService.selectById(oldSpecial_id);
            insSpecialPerformance.setSpecial_performance_id(sId);
            this.insSpecialPerformanceService.insert(insSpecialPerformance);
        } else if (orderVo.getProduct_code().contains("GCTB")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialBid insSpecialBid = (SpecialBid)this.insSpecialBidService.selectById(oldSpecial_id);
            insSpecialBid.setSpecial_bid_id(sId);
            this.insSpecialBidService.insert(insSpecialBid);
        } else if (orderVo.getProduct_code().contains("XYX-XWCK")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialCreditMicro insMicroExport = (SpecialCreditMicro)this.insMicroExportService.selectById(oldSpecial_id);
            insMicroExport.setSpecial_credit_micro_id(sId);
            this.insMicroExportService.insert(insMicroExport);
        } else if (orderVo.getProduct_code().contains("BZX-SSBQ")) {
            insInsuranceSlip.setSpecial_id(sId);
            SpecialLitigation specialLitigation = (SpecialLitigation)this.specialLitigationService.selectById(oldSpecial_id);
            columnMap = Maps.newHashMap();
            columnMap.put("special_litigation_id", specialLitigation.getSpecial_litigation_id());
            List lnAccusedList = this.lnAccusedService.selectByMap(columnMap);
            specialLitigation.setSpecial_litigation_id(sId);
            for (LnAccused lnAccused : lnAccusedList) {
                lnAccused.setLn_accused_id(Long.valueOf(idWorker.nextId()));
                lnAccused.setSpecial_litigation(specialLitigation);
            }
            this.specialLitigationService.insert(specialLitigation);
            this.lnAccusedService.insertBatch(lnAccusedList);
        }
        this.insInsuranceSlipService.insert(insInsuranceSlip);
        return new AjaxResult(true, "\u8ba2\u5355\u590d\u5236\u6210\u529f!\u8ba2\u5355\u7f16\u53f7\uff1a" + tNumber);
    }

    @Override
    public AjaxResult surrender(SurrenderVo surrenderVo, HttpServletRequest request) {
        OrderFormVo orderVo = this.accordingToOrderIDToGetOrderFormVo(Long.parseLong(surrenderVo.getOid()));
        if (orderVo == null) {
            return new AjaxResult(false, "\u8ba2\u5355\u4e0d\u7b26\u5408\u9000\u4fdd\u6761\u4ef6!");
        }
        if ("4".equals(orderVo.getPolicy_status())) {
            OrderFormVo vo = new OrderFormVo();
            vo.setOid(orderVo.getOid());
            vo.setPolicy_status("13");
            this.updateOrderFormStatus(vo);
            return new AjaxResult(true, "\u9000\u4fdd\u64cd\u4f5c\u6210\u529f!");
        }
        if (StringUtils.isEmpty((CharSequence)surrenderVo.getInception_date()) || StringUtils.isEmpty((CharSequence)surrenderVo.getPremium())) {
            return new AjaxResult(false, "\u5fc5\u8981\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ((orderVo.getProduct_code().contains("TYX") || orderVo.getProduct_code().contains("GZZRX")) && ("6".equals(orderVo.getPolicy_status()) || "16".equals(orderVo.getPolicy_status()))) {
            OrderFormVo vo = new OrderFormVo();
            vo.setOid(orderVo.getOid());
            vo.setPolicy_status("13");
            this.updateOrderFormStatus(vo);
            this.preseverApplyService.saveSurrenderRecord(surrenderVo, orderVo, request);
            if (!"BLB".equals(orderVo.getWeb_type())) {
                this.comTaskResidualService.saveComTaskResidual("deletePolicyPush", "\u8bf7\u6c42\u7b2c\u4e09\u65b9\u5e9f\u5f03\u4fdd\u5355", "com.bcxin.ins.service.order.PolicyService", 1, "String", orderVo.getOid());
            }
            return new AjaxResult(true, "\u9000\u4fdd\u64cd\u4f5c\u6210\u529f!");
        }
        return new AjaxResult(false, "\u8ba2\u5355\u4e0d\u7b26\u5408\u9000\u4fdd\u6761\u4ef6!");
    }
}

